/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.server;

import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugScope;
import com.oracle.truffle.api.debug.DebugStackFrame;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.tools.dap.server.ExecutionContext;
import com.oracle.truffle.tools.dap.server.StackFramesHandler;
import com.oracle.truffle.tools.dap.server.ThreadsHandler;
import com.oracle.truffle.tools.dap.types.SetVariableArguments;
import com.oracle.truffle.tools.dap.types.Variable;
import com.oracle.truffle.tools.dap.types.VariablesArguments;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class VariablesHandler {
    private final ExecutionContext context;

    public VariablesHandler(ExecutionContext context) {
        this.context = context;
    }

    public List<Variable> getVariables(ThreadsHandler.SuspendedThreadInfo info, VariablesArguments args) {
        ArrayList<Variable> vars;
        block10: {
            Collection properties;
            int id;
            block9: {
                DebugScope dScope;
                vars = new ArrayList<Variable>();
                id = args.getVariablesReference();
                StackFramesHandler.ScopeWrapper scopeWrapper = info.getById(StackFramesHandler.ScopeWrapper.class, id);
                if (scopeWrapper != null) {
                    dScope = scopeWrapper.getScope();
                    if (scopeWrapper.getReturnValue() != null) {
                        vars.add(VariablesHandler.createVariable(info, scopeWrapper.getReturnValue(), "Return value"));
                    }
                    if (scopeWrapper.getThisValue() != null) {
                        vars.add(VariablesHandler.createVariable(info, scopeWrapper.getThisValue(), scopeWrapper.getThisValue().getName()));
                    }
                } else {
                    dScope = info.getById(DebugScope.class, id);
                }
                if (dScope == null) break block9;
                for (DebugValue val : dScope.getDeclaredValues()) {
                    if (!this.context.isInspectInternal() && val.isInternal()) continue;
                    vars.add(VariablesHandler.createVariable(info, val, "Unnamed value"));
                }
                break block10;
            }
            DebugValue dValue = info.getById(DebugValue.class, id);
            if (dValue == null) break block10;
            if (dValue.isArray()) {
                for (DebugValue val : dValue.getArray()) {
                    if (!this.context.isInspectInternal() && val.isInternal()) continue;
                    vars.add(VariablesHandler.createVariable(info, val, "Unnamed value"));
                }
            }
            if ((properties = dValue.getProperties()) != null) {
                for (DebugValue val : properties) {
                    if (!this.context.isInspectInternal() && val.isInternal()) continue;
                    vars.add(VariablesHandler.createVariable(info, val, "Unnamed value"));
                }
            }
        }
        return vars;
    }

    public static Variable setVariable(ThreadsHandler.SuspendedThreadInfo info, SetVariableArguments args) throws DebugException {
        DebugStackFrame frame;
        DebugValue value = null;
        int id = args.getVariablesReference();
        String name = args.getName();
        StackFramesHandler.ScopeWrapper scopeWrapper = info.getById(StackFramesHandler.ScopeWrapper.class, id);
        boolean updateReturnValue = false;
        LanguageInfo language = null;
        if (scopeWrapper != null) {
            frame = scopeWrapper.getFrame();
            value = scopeWrapper.getScope().getDeclaredValue(name);
            if (value == null && "Return value".equals(name)) {
                value = scopeWrapper.getReturnValue();
                updateReturnValue = true;
                language = frame.getLanguage();
            }
        } else {
            frame = info.getSuspendedEvent().getTopStackFrame();
            DebugScope dScope = info.getById(DebugScope.class, id);
            if (dScope != null) {
                value = dScope.getDeclaredValue(name);
            } else {
                DebugValue dValue = info.getById(DebugValue.class, id);
                if (dValue != null && (value = dValue.getProperty(name)) == null && dValue.isArray()) {
                    try {
                        value = (DebugValue)dValue.getArray().get(Integer.parseInt(name));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if (value != null && (updateReturnValue || value.isWritable())) {
            Object newValueObject;
            DebugValue newValue;
            DebugException dex = null;
            try {
                newValue = VariablesHandler.getDebugValue(frame, args.getValue());
            }
            catch (DebugException ex) {
                newValue = null;
                dex = ex;
            }
            if (!(newValue != null && newValue.isReadable() || (newValueObject = VariablesHandler.getValue(args.getValue())) == null)) {
                newValue = value.getSession().createPrimitiveValue(newValueObject, language);
            }
            if (newValue != null && newValue.isReadable()) {
                if (updateReturnValue) {
                    info.getSuspendedEvent().setReturnValue(newValue);
                } else {
                    value.set(newValue);
                    newValue = value;
                }
                return VariablesHandler.createVariable(info, newValue, "");
            }
            throw dex;
        }
        return null;
    }

    static Variable createVariable(ThreadsHandler.SuspendedThreadInfo info, DebugValue val, String defaultName) throws DebugException {
        Collection properties = val.getProperties();
        int valId = val.isArray() && !val.getArray().isEmpty() || properties != null && !properties.isEmpty() ? info.getId(val) : 0;
        Variable var = Variable.create(val.getName() != null ? val.getName() : defaultName, val.isReadable() ? val.toDisplayString() : "<not readable>", valId);
        DebugValue metaObject = val.getMetaObject();
        if (metaObject != null) {
            var.setType(metaObject.getMetaSimpleName());
        }
        if (val.isArray()) {
            var.setIndexedVariables(val.getArray().size());
        }
        if (properties != null) {
            var.setNamedVariables(properties.size());
        }
        return var;
    }

    static DebugValue getDebugValue(DebugStackFrame frame, String value) throws DebugException {
        try {
            return frame.eval(value);
        }
        catch (DebugException de) {
            DebugException dex = de;
            DebugValue receiver = frame.getScope().getReceiver();
            if (receiver != null && value.equals(receiver.getName())) {
                return receiver;
            }
            for (DebugScope scope = frame.getScope(); scope != null; scope = scope.getParent()) {
                DebugValue debugValue = scope.getDeclaredValue(value);
                if (debugValue == null) continue;
                return debugValue;
            }
            throw dex;
        }
    }

    private static Object getValue(String value) {
        String trimmedValue = value.trim();
        if (trimmedValue.length() > 1 && trimmedValue.charAt(0) == '\"' && trimmedValue.charAt(trimmedValue.length() - 1) == '\"') {
            return trimmedValue.substring(1, trimmedValue.length() - 1);
        }
        if (trimmedValue.equalsIgnoreCase("true") || trimmedValue.equalsIgnoreCase("false")) {
            return Boolean.valueOf(trimmedValue);
        }
        try {
            return Long.valueOf(trimmedValue);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

