/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.truffle.TruffleBaseFeature;
import com.oracle.svm.truffle.nfi.NativeObjectReplacer;
import java.util.Arrays;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public final class TruffleNFIFeature
implements InternalFeature {
    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(TruffleBaseFeature.class);
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        access.registerObjectReplacer((Function)new NativeObjectReplacer(access));
    }

    public static class IsEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return ImageSingletons.contains(TruffleNFIFeature.class);
        }
    }
}

