/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.fieldvaluetransformer.NewEmptyArrayFieldValueTransformer;
import com.oracle.svm.truffle.nfi.ErrnoMirror;
import com.oracle.svm.truffle.nfi.LocalNativeScope;
import com.oracle.svm.truffle.nfi.NFIInitialization;
import com.oracle.svm.truffle.nfi.NativeAPI;
import com.oracle.svm.truffle.nfi.NativeClosure;
import com.oracle.svm.truffle.nfi.NativeSignature;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_ClosureNativePointer;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_LibFFILibrary;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_LibFFISignature;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_LibFFISymbol;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_LibFFIType;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_spi_types_NativeSimpleType;
import com.oracle.svm.truffle.nfi.TruffleNFIFeature;
import com.oracle.svm.truffle.nfi.TruffleNFISupport;
import com.oracle.svm.truffle.nfi.TruffleObjectHandle;
import com.oracle.svm.truffle.nfi.libffi.LibFFI;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.TruffleObject;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

@TargetClass(className="com.oracle.truffle.nfi.backend.libffi.LibFFIContext", onlyWith={TruffleNFIFeature.IsEnabled.class})
final class Target_com_oracle_truffle_nfi_backend_libffi_LibFFIContext {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private long nativeContext;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=NewEmptyArrayFieldValueTransformer.class)
    Target_com_oracle_truffle_nfi_backend_libffi_LibFFIType[] simpleTypeMap;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=NewEmptyArrayFieldValueTransformer.class)
    Target_com_oracle_truffle_nfi_backend_libffi_LibFFIType[] arrayTypeMap;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Target_com_oracle_truffle_nfi_backend_libffi_LibFFIType cachedEnvType;

    Target_com_oracle_truffle_nfi_backend_libffi_LibFFIContext() {
    }

    @Alias
    native long getNativeEnv();

    @Alias
    native boolean attachThread();

    @Alias
    native void detachThread();

    @Alias
    native Target_com_oracle_truffle_nfi_backend_libffi_ClosureNativePointer createClosureNativePointer(long var1, long var3, CallTarget var5, Target_com_oracle_truffle_nfi_backend_libffi_LibFFISignature var6, Object var7);

    @Alias
    native void newClosureRef(long var1);

    @Alias
    native void releaseClosureRef(long var1);

    @Alias
    native TruffleObject getClosureObject(long var1);

    @Alias
    protected native void initializeSimpleType(Target_com_oracle_truffle_nfi_backend_spi_types_NativeSimpleType var1, int var2, int var3, long var4);

    @Substitute
    private long initializeNativeContext() {
        TruffleNFISupport support = (TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class);
        NativeAPI.NativeTruffleContext ret = (NativeAPI.NativeTruffleContext)UnmanagedMemory.malloc((int)SizeOf.get(NativeAPI.NativeTruffleContext.class));
        ret.setContextHandle(support.createContextHandle(this));
        NFIInitialization.initializeContext(ret);
        NFIInitialization.initializeSimpleTypes(this);
        return ret.rawValue();
    }

    @Substitute
    private static void disposeNativeContext(long context) {
        TruffleNFISupport support = (TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class);
        NativeAPI.NativeTruffleContext ctx = (NativeAPI.NativeTruffleContext)WordFactory.pointer((long)context);
        support.destroyContextHandle(ctx.contextHandle());
        UnmanagedMemory.free((PointerBase)ctx);
    }

    @Substitute
    private static long initializeNativeEnv(long context) {
        NativeAPI.NativeTruffleContext ctx = (NativeAPI.NativeTruffleContext)WordFactory.pointer((long)context);
        NativeAPI.NativeTruffleEnv env = (NativeAPI.NativeTruffleEnv)UnmanagedMemory.malloc((int)SizeOf.get(NativeAPI.NativeTruffleEnv.class));
        NFIInitialization.initializeEnv(env, ctx);
        return env.rawValue();
    }

    @Substitute
    Target_com_oracle_truffle_nfi_backend_libffi_ClosureNativePointer allocateClosureObjectRet(Target_com_oracle_truffle_nfi_backend_libffi_LibFFISignature signature, CallTarget callTarget, Object receiver) {
        return NativeClosure.prepareClosure(this, signature, callTarget, receiver, (LibFFI.ffi_closure_callback)NativeClosure.INVOKE_CLOSURE_OBJECT_RET.getFunctionPointer());
    }

    @Substitute
    Target_com_oracle_truffle_nfi_backend_libffi_ClosureNativePointer allocateClosureStringRet(Target_com_oracle_truffle_nfi_backend_libffi_LibFFISignature signature, CallTarget callTarget, Object receiver) {
        return NativeClosure.prepareClosure(this, signature, callTarget, receiver, (LibFFI.ffi_closure_callback)NativeClosure.INVOKE_CLOSURE_STRING_RET.getFunctionPointer());
    }

    @Substitute
    Target_com_oracle_truffle_nfi_backend_libffi_ClosureNativePointer allocateClosureBufferRet(Target_com_oracle_truffle_nfi_backend_libffi_LibFFISignature signature, CallTarget callTarget, Object receiver) {
        return NativeClosure.prepareClosure(this, signature, callTarget, receiver, (LibFFI.ffi_closure_callback)NativeClosure.INVOKE_CLOSURE_BUFFER_RET.getFunctionPointer());
    }

    @Substitute
    Target_com_oracle_truffle_nfi_backend_libffi_ClosureNativePointer allocateClosureVoidRet(Target_com_oracle_truffle_nfi_backend_libffi_LibFFISignature signature, CallTarget callTarget, Object receiver) {
        return NativeClosure.prepareClosure(this, signature, callTarget, receiver, (LibFFI.ffi_closure_callback)NativeClosure.INVOKE_CLOSURE_VOID_RET.getFunctionPointer());
    }

    @Substitute
    long prepareSignature(Target_com_oracle_truffle_nfi_backend_libffi_LibFFIType retType, int argCount, Target_com_oracle_truffle_nfi_backend_libffi_LibFFIType ... args) {
        NativeSignature.CifData data = NativeSignature.PrepareHelper.prepareArgs(argCount, args);
        int ret = LibFFI.ffi_prep_cif(data.cif(), LibFFI.FFI_DEFAULT_ABI(), WordFactory.unsigned((int)argCount), (LibFFI.ffi_type)WordFactory.pointer((long)retType.type), data.args());
        return NativeSignature.PrepareHelper.checkRet(data, ret);
    }

    @Substitute
    long prepareSignatureVarargs(Target_com_oracle_truffle_nfi_backend_libffi_LibFFIType retType, int argCount, int nFixedArgs, Target_com_oracle_truffle_nfi_backend_libffi_LibFFIType ... args) {
        NativeSignature.CifData data = NativeSignature.PrepareHelper.prepareArgs(argCount, args);
        int ret = LibFFI.ffi_prep_cif_var(data.cif(), LibFFI.FFI_DEFAULT_ABI(), WordFactory.unsigned((int)nFixedArgs), WordFactory.unsigned((int)argCount), (LibFFI.ffi_type)WordFactory.pointer((long)retType.type), data.args());
        return NativeSignature.PrepareHelper.checkRet(data, ret);
    }

    @Substitute
    @CompilerDirectives.TruffleBoundary
    void executeNative(long cif, long functionPointer, byte[] primArgs, int patchCount, int[] patchOffsets, Object[] objArgs, byte[] ret) {
        try (LocalNativeScope scope = TruffleNFISupport.createLocalScope(patchCount);
             PinnedObject retBuffer = PinnedObject.create((Object)ret);){
            NativeAPI.NativeTruffleContext ctx = (NativeAPI.NativeTruffleContext)WordFactory.pointer((long)this.nativeContext);
            LibFFI.ffi_cif ffiCif = (LibFFI.ffi_cif)WordFactory.pointer((long)cif);
            NativeSignature.ExecuteHelper.execute(ctx, ffiCif, retBuffer.addressOfArrayElement(0), functionPointer, primArgs, patchCount, patchOffsets, objArgs, scope);
        }
    }

    @Substitute
    @CompilerDirectives.TruffleBoundary
    long executePrimitive(long cif, long functionPointer, byte[] primArgs, int patchCount, int[] patchOffsets, Object[] objArgs) {
        try (LocalNativeScope scope = TruffleNFISupport.createLocalScope(patchCount);){
            NativeAPI.NativeTruffleContext ctx = (NativeAPI.NativeTruffleContext)WordFactory.pointer((long)this.nativeContext);
            LibFFI.ffi_cif ffiCif = (LibFFI.ffi_cif)WordFactory.pointer((long)cif);
            CLongPointer retPtr = (CLongPointer)StackValue.get((int)8);
            NativeSignature.ExecuteHelper.execute(ctx, ffiCif, (PointerBase)retPtr, functionPointer, primArgs, patchCount, patchOffsets, objArgs, scope);
            long l = retPtr.read();
            return l;
        }
    }

    @Substitute
    @CompilerDirectives.TruffleBoundary
    Object executeObject(long cif, long functionPointer, byte[] primArgs, int patchCount, int[] patchOffsets, Object[] objArgs) {
        try (LocalNativeScope scope = TruffleNFISupport.createLocalScope(patchCount);){
            NativeAPI.NativeTruffleContext ctx = (NativeAPI.NativeTruffleContext)WordFactory.pointer((long)this.nativeContext);
            LibFFI.ffi_cif ffiCif = (LibFFI.ffi_cif)WordFactory.pointer((long)cif);
            WordPointer retPtr = (WordPointer)StackValue.get((int)8);
            NativeSignature.ExecuteHelper.execute(ctx, ffiCif, (PointerBase)retPtr, functionPointer, primArgs, patchCount, patchOffsets, objArgs, scope);
            Object object = ((TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class)).resolveHandle((TruffleObjectHandle)retPtr.read());
            return object;
        }
    }

    @Substitute
    private static void loadNFILib() {
    }

    @Substitute
    @CompilerDirectives.TruffleBoundary
    static long loadLibrary(long nativeContext, String name, int flags) {
        return TruffleNFISupport.loadLibrary(nativeContext, name, flags);
    }

    @Substitute
    @CompilerDirectives.TruffleBoundary
    static void freeLibrary(long library) {
        TruffleNFISupport.freeLibrary(library);
    }

    @Substitute
    @CompilerDirectives.TruffleBoundary
    Object lookupSymbol(Target_com_oracle_truffle_nfi_backend_libffi_LibFFILibrary library, String name) {
        if (((TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class)).errnoGetterFunctionName.equals(name)) {
            return new ErrnoMirror();
        }
        Target_com_oracle_truffle_nfi_backend_libffi_LibFFISymbol ret = Target_com_oracle_truffle_nfi_backend_libffi_LibFFISymbol.create(library, name, Target_com_oracle_truffle_nfi_backend_libffi_LibFFIContext.lookup(this.nativeContext, library.handle, name));
        return ret;
    }

    @Substitute
    @CompilerDirectives.TruffleBoundary
    static long lookup(long nativeContext, long library, String name) {
        return TruffleNFISupport.lookup(nativeContext, library, name);
    }
}

