/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.truffle.nfi.ErrnoMirror;
import com.oracle.svm.truffle.nfi.LibFFI;
import com.oracle.svm.truffle.nfi.NativeAPI;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_ClosureNativePointer;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_LibFFIClosure_RetPatches;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_LibFFIContext;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_LibFFISignature;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_LibFFIType_CachedTypeInfo;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_LibFFIType_EnvType;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_LibFFIType_NullableType;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_LibFFIType_ObjectType;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_LibFFIType_StringType;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_NativeArgumentBuffer_Pointer;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_NativeArgumentBuffer_TypeTag;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_NativeString;
import com.oracle.svm.truffle.nfi.TruffleNFISupport;
import com.oracle.svm.truffle.nfi.TruffleObjectHandle;
import com.oracle.svm.truffle.nfi.libffi.LibFFI;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import java.lang.ref.WeakReference;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class NativeClosure {
    private final WeakReference<CallTarget> callTarget;
    private final WeakReference<Object> receiver;
    private final ClosureArgType[] argTypes;
    static final FastThreadLocalObject<Throwable> pendingException = FastThreadLocalFactory.createObject(Throwable.class, (String)"NativeClosure.pendingException");
    static final CEntryPointLiteral<LibFFI.ffi_closure_callback> INVOKE_CLOSURE_BUFFER_RET = CEntryPointLiteral.create(NativeClosure.class, (String)"invokeClosureBufferRet", (Class[])new Class[]{LibFFI.ffi_cif.class, Pointer.class, WordPointer.class, LibFFI.ClosureData.class});
    static final CEntryPointLiteral<LibFFI.ffi_closure_callback> INVOKE_CLOSURE_VOID_RET = CEntryPointLiteral.create(NativeClosure.class, (String)"invokeClosureVoidRet", (Class[])new Class[]{LibFFI.ffi_cif.class, WordPointer.class, WordPointer.class, LibFFI.ClosureData.class});
    static final CEntryPointLiteral<LibFFI.ffi_closure_callback> INVOKE_CLOSURE_STRING_RET = CEntryPointLiteral.create(NativeClosure.class, (String)"invokeClosureStringRet", (Class[])new Class[]{LibFFI.ffi_cif.class, WordPointer.class, WordPointer.class, LibFFI.ClosureData.class});
    static final CEntryPointLiteral<LibFFI.ffi_closure_callback> INVOKE_CLOSURE_OBJECT_RET = CEntryPointLiteral.create(NativeClosure.class, (String)"invokeClosureObjectRet", (Class[])new Class[]{LibFFI.ffi_cif.class, WordPointer.class, WordPointer.class, LibFFI.ClosureData.class});

    private NativeClosure(CallTarget callTarget, Object receiver, ClosureArgType[] argTypes) {
        this.callTarget = new WeakReference<CallTarget>(callTarget);
        this.receiver = receiver != null ? new WeakReference<Object>(receiver) : null;
        this.argTypes = argTypes;
    }

    static Target_com_oracle_truffle_nfi_backend_libffi_ClosureNativePointer prepareClosure(Target_com_oracle_truffle_nfi_backend_libffi_LibFFIContext ctx, Target_com_oracle_truffle_nfi_backend_libffi_LibFFISignature signature, CallTarget callTarget, Object receiver, LibFFI.ffi_closure_callback callback) {
        int envArgIdx = -1;
        Target_com_oracle_truffle_nfi_backend_libffi_LibFFIType_CachedTypeInfo[] argTypeInfo = signature.signatureInfo.getArgTypes();
        ClosureArgType[] argTypes = new ClosureArgType[argTypeInfo.length];
        for (int i = 0; i < argTypeInfo.length; ++i) {
            Target_com_oracle_truffle_nfi_backend_libffi_LibFFIType_CachedTypeInfo type = argTypeInfo[i];
            if (Target_com_oracle_truffle_nfi_backend_libffi_LibFFIType_StringType.class.isInstance(type)) {
                argTypes[i] = ClosureArgType.ARG_STRING;
                continue;
            }
            if (Target_com_oracle_truffle_nfi_backend_libffi_LibFFIType_ObjectType.class.isInstance(type)) {
                argTypes[i] = ClosureArgType.ARG_OBJECT;
                continue;
            }
            if (Target_com_oracle_truffle_nfi_backend_libffi_LibFFIType_NullableType.class.isInstance(type)) {
                argTypes[i] = ClosureArgType.ARG_OBJECT;
                continue;
            }
            if (Target_com_oracle_truffle_nfi_backend_libffi_LibFFIType_EnvType.class.isInstance(type)) {
                argTypes[i] = ClosureArgType.ARG_SKIP;
                envArgIdx = i;
                continue;
            }
            argTypes[i] = ClosureArgType.ARG_BUFFER;
        }
        NativeClosure closure = new NativeClosure(callTarget, receiver, argTypes);
        LibFFI.NativeClosureHandle handle = ((TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class)).createClosureHandle(closure);
        WordPointer codePtr = (WordPointer)UnsafeStackValue.get(WordPointer.class);
        LibFFI.ClosureData data = (LibFFI.ClosureData)LibFFI.ffi_closure_alloc(SizeOf.unsigned(LibFFI.ClosureData.class), codePtr);
        data.setNativeClosureHandle(handle);
        data.setIsolate(CurrentIsolate.getIsolate());
        data.setEnvArgIdx(envArgIdx);
        PointerBase code = (PointerBase)codePtr.read();
        LibFFI.ffi_prep_closure_loc(data.ffiClosure(), (LibFFI.ffi_cif)WordFactory.pointer((long)signature.cif), callback, (WordBase)data, code);
        return ctx.createClosureNativePointer(data.rawValue(), code.rawValue(), callTarget, signature, receiver);
    }

    private Object call(WordPointer argPointers, Target_com_oracle_truffle_nfi_backend_libffi_NativeArgumentBuffer_Pointer retBuffer) {
        CallTarget c;
        int length = this.argTypes.length;
        if (this.receiver != null) {
            ++length;
        }
        if (retBuffer != null) {
            ++length;
        }
        Object[] args = new Object[length];
        block5: for (int i = 0; i < this.argTypes.length; ++i) {
            switch (this.argTypes[i]) {
                case ARG_STRING: {
                    CCharPointerPointer strPtr = (CCharPointerPointer)argPointers.read(i);
                    args[i] = TruffleNFISupport.utf8ToJavaString(strPtr.read());
                    continue block5;
                }
                case ARG_OBJECT: {
                    WordPointer objPtr = (WordPointer)argPointers.read(i);
                    args[i] = ((TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class)).resolveHandle((TruffleObjectHandle)objPtr.read());
                    continue block5;
                }
                case ARG_BUFFER: {
                    WordPointer argPtr = (WordPointer)argPointers.read(i);
                    args[i] = new Target_com_oracle_truffle_nfi_backend_libffi_NativeArgumentBuffer_Pointer(argPtr.rawValue());
                    continue block5;
                }
            }
        }
        if (this.receiver != null) {
            args[i++] = this.receiver.get();
        }
        if (retBuffer != null) {
            args[i++] = retBuffer;
        }
        if ((c = (CallTarget)this.callTarget.get()) == null) {
            throw CompilerDirectives.shouldNotReachHere((String)"Native closure used after free.");
        }
        return c.call(args);
    }

    private static NativeClosure lookup(LibFFI.ClosureData data) {
        return ((TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class)).resolveClosureHandle(data.nativeClosureHandle());
    }

    private static PointerBase serializeStringRet(Object retValue) {
        if (retValue == null) {
            return (PointerBase)WordFactory.zero();
        }
        if (retValue instanceof Target_com_oracle_truffle_nfi_backend_libffi_NativeString) {
            Target_com_oracle_truffle_nfi_backend_libffi_NativeString nativeString = (Target_com_oracle_truffle_nfi_backend_libffi_NativeString)retValue;
            return WordFactory.pointer((long)nativeString.nativePointer);
        }
        if (retValue instanceof String) {
            byte[] utf8 = TruffleNFISupport.javaStringToUtf8((String)retValue);
            try (PinnedObject pinned = PinnedObject.create((Object)utf8);){
                CCharPointer source = (CCharPointer)pinned.addressOfArrayElement(0);
                CCharPointer cCharPointer = TruffleNFISupport.strdup(source);
                return cCharPointer;
            }
        }
        return (PointerBase)WordFactory.zero();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @Uninterruptible(reason="contains prologue and epilogue for thread state transition", calleeMustBe=false)
    static void invokeClosureBufferRet(LibFFI.ffi_cif cif, Pointer ret, WordPointer args, LibFFI.ClosureData user) {
        int errno = LibC.errno();
        if (user.envArgIdx() >= 0) {
            WordPointer envArgPtr = (WordPointer)args.read(user.envArgIdx());
            NativeAPI.NativeTruffleEnv env = (NativeAPI.NativeTruffleEnv)envArgPtr.read();
            CEntryPointActions.enter((IsolateThread)env.isolateThread());
        } else {
            CEntryPointActions.enterByIsolate((Isolate)user.isolate());
        }
        ((CIntPointer)ErrnoMirror.errnoMirror.getAddress()).write(errno);
        try {
            NativeClosure.doInvokeClosureBufferRet(ret, args, user);
        }
        catch (Throwable t) {
            pendingException.set((Object)t);
        }
        errno = ((CIntPointer)ErrnoMirror.errnoMirror.getAddress()).read();
        CEntryPointActions.leave();
        LibC.setErrno((int)errno);
    }

    private static void doInvokeClosureBufferRet(Pointer ret, WordPointer args, LibFFI.ClosureData user) {
        Target_com_oracle_truffle_nfi_backend_libffi_NativeArgumentBuffer_Pointer retBuffer;
        NativeClosure closure = NativeClosure.lookup(user);
        Target_com_oracle_truffle_nfi_backend_libffi_LibFFIClosure_RetPatches patches = (Target_com_oracle_truffle_nfi_backend_libffi_LibFFIClosure_RetPatches)closure.call(args, retBuffer = new Target_com_oracle_truffle_nfi_backend_libffi_NativeArgumentBuffer_Pointer(ret.rawValue()));
        if (patches != null) {
            for (int i = 0; i < patches.count; ++i) {
                Target_com_oracle_truffle_nfi_backend_libffi_NativeArgumentBuffer_TypeTag tag = Target_com_oracle_truffle_nfi_backend_libffi_NativeArgumentBuffer_TypeTag.getTag(patches.patches[i]);
                int offset = Target_com_oracle_truffle_nfi_backend_libffi_NativeArgumentBuffer_TypeTag.getOffset(patches.patches[i]);
                Object obj = patches.objects[i];
                if (tag == Target_com_oracle_truffle_nfi_backend_libffi_NativeArgumentBuffer_TypeTag.OBJECT) {
                    TruffleObjectHandle handle = ((TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class)).createGlobalHandle(obj);
                    ret.writeWord(offset, (WordBase)handle);
                    continue;
                }
                if (tag != Target_com_oracle_truffle_nfi_backend_libffi_NativeArgumentBuffer_TypeTag.STRING) continue;
                ret.writeWord(offset, (WordBase)NativeClosure.serializeStringRet(obj));
            }
        }
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @Uninterruptible(reason="contains prologue and epilogue for thread state transition", calleeMustBe=false)
    static void invokeClosureVoidRet(LibFFI.ffi_cif cif, WordPointer ret, WordPointer args, LibFFI.ClosureData user) {
        int errno = LibC.errno();
        if (user.envArgIdx() >= 0) {
            WordPointer envArgPtr = (WordPointer)args.read(user.envArgIdx());
            NativeAPI.NativeTruffleEnv env = (NativeAPI.NativeTruffleEnv)envArgPtr.read();
            CEntryPointActions.enter((IsolateThread)env.isolateThread());
        } else {
            CEntryPointActions.enterByIsolate((Isolate)user.isolate());
        }
        ((CIntPointer)ErrnoMirror.errnoMirror.getAddress()).write(errno);
        try {
            NativeClosure.doInvokeClosureVoidRet(args, user);
        }
        catch (Throwable t) {
            pendingException.set((Object)t);
        }
        errno = ((CIntPointer)ErrnoMirror.errnoMirror.getAddress()).read();
        CEntryPointActions.leave();
        LibC.setErrno((int)errno);
    }

    private static void doInvokeClosureVoidRet(WordPointer args, LibFFI.ClosureData user) {
        NativeClosure.lookup(user).call(args, null);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @Uninterruptible(reason="contains prologue and epilogue for thread state transition", calleeMustBe=false)
    static void invokeClosureStringRet(LibFFI.ffi_cif cif, WordPointer ret, WordPointer args, LibFFI.ClosureData user) {
        int errno = LibC.errno();
        if (user.envArgIdx() >= 0) {
            WordPointer envArgPtr = (WordPointer)args.read(user.envArgIdx());
            NativeAPI.NativeTruffleEnv env = (NativeAPI.NativeTruffleEnv)envArgPtr.read();
            CEntryPointActions.enter((IsolateThread)env.isolateThread());
        } else {
            CEntryPointActions.enterByIsolate((Isolate)user.isolate());
        }
        ((CIntPointer)ErrnoMirror.errnoMirror.getAddress()).write(errno);
        try {
            NativeClosure.doInvokeClosureStringRet(ret, args, user);
        }
        catch (Throwable t) {
            pendingException.set((Object)t);
        }
        errno = ((CIntPointer)ErrnoMirror.errnoMirror.getAddress()).read();
        CEntryPointActions.leave();
        LibC.setErrno((int)errno);
    }

    private static void doInvokeClosureStringRet(WordPointer ret, WordPointer args, LibFFI.ClosureData user) {
        Object retValue = NativeClosure.lookup(user).call(args, null);
        ret.write((WordBase)NativeClosure.serializeStringRet(retValue));
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @Uninterruptible(reason="contains prologue and epilogue for thread state transition", calleeMustBe=false)
    static void invokeClosureObjectRet(LibFFI.ffi_cif cif, WordPointer ret, WordPointer args, LibFFI.ClosureData user) {
        int errno = LibC.errno();
        if (user.envArgIdx() >= 0) {
            WordPointer envArgPtr = (WordPointer)args.read(user.envArgIdx());
            NativeAPI.NativeTruffleEnv env = (NativeAPI.NativeTruffleEnv)envArgPtr.read();
            CEntryPointActions.enter((IsolateThread)env.isolateThread());
        } else {
            CEntryPointActions.enterByIsolate((Isolate)user.isolate());
        }
        ((CIntPointer)ErrnoMirror.errnoMirror.getAddress()).write(errno);
        try {
            NativeClosure.doInvokeClosureObjectRet(ret, args, user);
        }
        catch (Throwable t) {
            pendingException.set((Object)t);
        }
        errno = ((CIntPointer)ErrnoMirror.errnoMirror.getAddress()).read();
        CEntryPointActions.leave();
        LibC.setErrno((int)errno);
    }

    private static void doInvokeClosureObjectRet(WordPointer ret, WordPointer args, LibFFI.ClosureData user) {
        Object obj = NativeClosure.lookup(user).call(args, null);
        if (obj == null) {
            ret.write(WordFactory.zero());
        } else {
            TruffleObjectHandle handle = ((TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class)).createGlobalHandle(obj);
            ret.write((WordBase)handle);
        }
    }

    private static enum ClosureArgType {
        ARG_BUFFER,
        ARG_STRING,
        ARG_OBJECT,
        ARG_SKIP;

    }
}

