/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi;

import com.oracle.svm.truffle.nfi.TruffleObjectHandle;
import com.oracle.svm.truffle.nfi.libffi.LibFFIHeaderDirectives;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CFieldAddress;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;

@CContext(value=LibFFIHeaderDirectives.class)
final class NativeAPI {
    NativeAPI() {
    }

    public static interface GetClosureObjectFunction
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public TruffleObjectHandle getClosureObject(NativeTruffleEnv var1, PointerBase var2);
    }

    public static interface ReleaseClosureRefFunction
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void releaseClosureRef(NativeTruffleEnv var1, PointerBase var2);
    }

    public static interface NewClosureRefFunction
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void newClosureRef(NativeTruffleEnv var1, PointerBase var2);
    }

    public static interface IsSameObjectFunction
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int isSameObject(NativeTruffleEnv var1, TruffleObjectHandle var2, TruffleObjectHandle var3);
    }

    public static interface ReleaseAndReturnFunction
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public TruffleObjectHandle releaseAndReturn(NativeTruffleEnv var1, TruffleObjectHandle var2);
    }

    public static interface ReleaseObjectRefFunction
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void releaseObjectRef(NativeTruffleEnv var1, TruffleObjectHandle var2);
    }

    public static interface NewObjectRefFunction
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public TruffleObjectHandle newObjectRef(NativeTruffleEnv var1, TruffleObjectHandle var2);
    }

    public static interface GetTruffleContextFunction
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public NativeTruffleContext getTruffleContext(NativeTruffleEnv var1);
    }

    @CStruct(value="struct __TruffleNativeAPI")
    public static interface TruffleNativeAPI
    extends PointerBase {
        @CField(value="getTruffleContext")
        public void setGetTruffleContextFunction(GetTruffleContextFunction var1);

        @CField(value="newObjectRef")
        public void setNewObjectRefFunction(NewObjectRefFunction var1);

        @CField(value="releaseObjectRef")
        public void setReleaseObjectRefFunction(ReleaseObjectRefFunction var1);

        @CField(value="releaseAndReturn")
        public void setReleaseAndReturnFunction(ReleaseAndReturnFunction var1);

        @CField(value="isSameObject")
        public void setIsSameObjectFunction(IsSameObjectFunction var1);

        @CField(value="newClosureRef")
        public void setNewClosureRefFunction(NewClosureRefFunction var1);

        @CField(value="releaseClosureRef")
        public void setReleaseClosureRefFunction(ReleaseClosureRefFunction var1);

        @CField(value="getClosureObject")
        public void setGetClosureObjectFunction(GetClosureObjectFunction var1);
    }

    public static interface DetachCurrentThreadFunction
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void detachCurrentThread(NativeTruffleContext var1);
    }

    public static interface AttachCurrentThreadFunction
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public NativeTruffleEnv attachCurrentThread(NativeTruffleContext var1);
    }

    public static interface GetTruffleEnvFunction
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public NativeTruffleEnv getTruffleEnv(NativeTruffleContext var1);
    }

    @CStruct(value="struct __TruffleThreadAPI")
    public static interface TruffleThreadAPI
    extends PointerBase {
        @CField(value="getTruffleEnv")
        public void setGetTruffleEnvFunction(GetTruffleEnvFunction var1);

        @CField(value="attachCurrentThread")
        public void setAttachCurrentThreadFunction(AttachCurrentThreadFunction var1);

        @CField(value="detachCurrentThread")
        public void setDetachCurrentThreadFunction(DetachCurrentThreadFunction var1);
    }

    @CStruct(value="svm_truffle_env")
    public static interface NativeTruffleEnv
    extends PointerBase {
        @CField(value="functions")
        public void setFunctions(TruffleNativeAPI var1);

        @CField
        public NativeTruffleContext context();

        @CField(value="context")
        public void setContext(NativeTruffleContext var1);

        @CField
        public IsolateThread isolateThread();

        @CField(value="isolateThread")
        public void setIsolateThread(IsolateThread var1);
    }

    @CStruct(value="svm_truffle_context")
    public static interface NativeTruffleContext
    extends PointerBase {
        @CField(value="functions")
        public void setFunctions(TruffleThreadAPI var1);

        @CField
        public TruffleContextHandle contextHandle();

        @CField(value="contextHandle")
        public void setContextHandle(TruffleContextHandle var1);

        @CField
        public Isolate isolate();

        @CField(value="isolate")
        public void setIsolate(Isolate var1);

        @CFieldAddress
        public TruffleThreadAPI threadAPI();

        @CFieldAddress
        public TruffleNativeAPI nativeAPI();
    }

    static interface TruffleContextHandle
    extends ComparableWord {
    }
}

