/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck.impl;

import org.graalvm.polyglot.Engine;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

public abstract class TruffleLanguageRunner
extends BlockJUnit4ClassRunner {
    private final String languageId;

    private TruffleLanguageRunner(Class<?> klass, String languageId) throws InitializationError {
        super(klass);
        this.languageId = languageId;
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        if (TruffleLanguageRunner.skipOnMissingLanguage(this.languageId)) {
            notifier.fireTestIgnored(Description.createTestDescription((Class)method.getType(), (String)method.getName()));
        } else {
            super.runChild(method, notifier);
        }
    }

    private static boolean skipOnMissingLanguage(String languageId) {
        try (Engine engine = Engine.create();){
            boolean bl = !engine.getLanguages().containsKey(languageId);
            return bl;
        }
    }

    public static final class RRunner
    extends TruffleLanguageRunner {
        public RRunner(Class<?> klass) throws InitializationError {
            super(klass, "R");
        }
    }

    public static final class RubyRunner
    extends TruffleLanguageRunner {
        public RubyRunner(Class<?> klass) throws InitializationError {
            super(klass, "ruby");
        }
    }

    public static final class JavaScriptRunner
    extends TruffleLanguageRunner {
        public JavaScriptRunner(Class<?> klass) throws InitializationError {
            super(klass, "js");
        }
    }
}

