/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck.impl;

import com.oracle.truffle.tck.impl.TruffleLanguageRunner;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=TruffleLanguageRunner.RRunner.class)
public class PolyglotEngineWithR {
    private Context engine;

    @Before
    public void initEngine() {
        this.engine = Context.newBuilder((String[])new String[0]).build();
    }

    @After
    public void disposeEngine() {
        this.engine.close();
    }

    @Test
    public void testCallRtFunctionFromJava() {
        this.callRFunctionFromJava();
    }

    public void callRFunctionFromJava() {
        Source src = Source.newBuilder((String)"R", (CharSequence)"qbinom", (String)"qbinom.R").buildLiteral();
        BinomQuantile func = (BinomQuantile)this.engine.eval(src).as(BinomQuantile.class);
        Assert.assertEquals((long)4L, (long)func.qbinom(0.37, 10, 0.5));
    }

    @FunctionalInterface
    static interface BinomQuantile {
        public int qbinom(double var1, int var3, double var4);
    }
}

