/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.util;

import com.oracle.svm.core.VM;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.c.codegen.CCompilerInvoker;
import com.oracle.svm.hosted.util.DiagnosticUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.ImageSingletonsSupport;

public final class VMErrorReporter {
    public static void generateErrorReport(PrintWriter pw, StringBuilder buildOutputLog, ImageClassLoader classLoader, Optional<FeatureHandler> featureHandler, Throwable t) {
        pw.println("# GraalVM Native Image Error Report");
        pw.println();
        VMErrorReporter.reportBuildLog(pw, buildOutputLog);
        pw.println();
        VMErrorReporter.reportStackTrace(pw, t);
        pw.println();
        VMErrorReporter.reportGraalVMSetup(pw);
        pw.println();
        VMErrorReporter.reportBuilderSetup(pw, classLoader, featureHandler);
    }

    private static void reportBuildLog(PrintWriter pw, StringBuilder buildOutputLog) {
        pw.println("## Build Output");
        pw.println();
        pw.println("```");
        pw.append(ProgressReporter.ANSI.strip(buildOutputLog.toString()));
        pw.println("```");
    }

    private static void reportStackTrace(PrintWriter pw, Throwable t) {
        pw.println("## Stack Trace");
        pw.println();
        pw.println("```java");
        Throwable current = t;
        while (current != null) {
            t.printStackTrace(pw);
            if ((current = current.getCause()) == null) continue;
            pw.println("Caused by:");
        }
        pw.println("```");
    }

    private static void reportGraalVMSetup(PrintWriter pw) {
        String releaseContent;
        pw.println("## GraalVM Setup");
        pw.println();
        pw.println("| Name | Value |");
        pw.println("| ---- | ----- |");
        pw.printf("| Java version | `%s` |%n", VM.getVersion());
        pw.printf("| Vendor version | `%s` |%n", VM.getVendorVersion());
        pw.printf("| Runtime version | `%s` |%n", System.getProperty("java.runtime.version"));
        if (ImageSingletonsSupport.isInstalled() && ImageSingletons.contains(CCompilerInvoker.class)) {
            pw.printf("| C compiler | `%s` |%n", ((CCompilerInvoker)ImageSingletons.lookup(CCompilerInvoker.class)).compilerInfo.getShortDescription());
        }
        if ((releaseContent = VMErrorReporter.getReleaseFileContent()) != null) {
            try (DetailsPrinter d = new DetailsPrinter(pw, "GraalVM <code>release</code> file");){
                pw.println(releaseContent);
            }
        }
    }

    private static String getReleaseFileContent() {
        Path releaseFile = Path.of(System.getProperty("java.home"), new String[0]).resolve("release");
        if (Files.exists(releaseFile, new LinkOption[0])) {
            try {
                return Files.readString(releaseFile);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private static void reportBuilderSetup(PrintWriter pw, ImageClassLoader classLoader, Optional<FeatureHandler> featureHandler) {
        pw.println("## Builder Setup");
        pw.println();
        try (DetailsPrinter p = new DetailsPrinter(pw, "Class path");){
            for (String entry : DiagnosticUtils.getClassPath(classLoader)) {
                pw.println(entry);
            }
        }
        pw.println();
        p = new DetailsPrinter(pw, "Module path");
        try {
            for (String entry : DiagnosticUtils.getModulePath(classLoader)) {
                pw.println(entry);
            }
        }
        finally {
            p.close();
        }
        pw.println();
        p = new DetailsPrinter(pw, "Builder arguments");
        try {
            for (String entry : DiagnosticUtils.getBuilderArguments(classLoader)) {
                pw.println(entry);
            }
        }
        finally {
            p.close();
        }
        pw.println();
        p = new DetailsPrinter(pw, "Builder properties");
        try {
            for (String entry : DiagnosticUtils.getBuilderProperties()) {
                pw.println(entry);
            }
        }
        finally {
            p.close();
        }
        pw.println();
        p = new DetailsPrinter(pw, "Features enabled");
        try {
            if (featureHandler.isPresent()) {
                featureHandler.get().dumpAllFeatures(pw);
            } else {
                pw.println("*FeatureHandler not present.*");
            }
        }
        finally {
            p.close();
        }
    }

    private static final class DetailsPrinter
    implements AutoCloseable {
        private final PrintWriter pw;

        private DetailsPrinter(PrintWriter pw, String title) {
            this.pw = pw;
            pw.printf("<details>%n<summary>%s</summary>%n%n```%n", title);
        }

        @Override
        public void close() {
            this.pw.printf("```%n%n</details>%n", new Object[0]);
        }
    }
}

