/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.RestrictHeapAccessCallees;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.code.CompilationGraph;
import com.oracle.svm.hosted.code.RestrictHeapAccessCalleesImpl;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import jdk.vm.ci.meta.JavaMethod;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.nativeimage.ImageSingletons;

public final class RestrictHeapAccessAnnotationChecker {
    public static void check(DebugContext debug, HostedUniverse universe, Collection<HostedMethod> methods) {
        RestrictHeapAccessWarningVisitor visitor = new RestrictHeapAccessWarningVisitor(universe);
        for (HostedMethod method : methods) {
            visitor.visitMethod(debug, method);
        }
    }

    static CompilationGraph.AllocationInfo checkViolatingNode(CompilationGraph graph) {
        Iterator<CompilationGraph.AllocationInfo> iterator;
        if (graph != null && (iterator = graph.getAllocationInfos().iterator()).hasNext()) {
            CompilationGraph.AllocationInfo node = iterator.next();
            return node;
        }
        return null;
    }

    static class RestrictHeapAccessWarningVisitor {
        private final HostedUniverse universe;
        private final RestrictHeapAccessCalleesImpl restrictHeapAccessCallees;

        RestrictHeapAccessWarningVisitor(HostedUniverse universe) {
            this.universe = universe;
            this.restrictHeapAccessCallees = (RestrictHeapAccessCalleesImpl)ImageSingletons.lookup(RestrictHeapAccessCallees.class);
        }

        public void visitMethod(DebugContext debug, HostedMethod method) {
            RestrictHeapAccessCalleesImpl.RestrictionInfo info = this.restrictHeapAccessCallees.getRestrictionInfo(method);
            if (info == null || info.getAccess() == RestrictHeapAccess.Access.UNRESTRICTED) {
                return;
            }
            CompilationGraph graph = method.compilationInfo.getCompilationGraph();
            if (RestrictHeapAccessAnnotationChecker.checkViolatingNode(graph) != null) {
                try (DebugContext.Scope s = debug.scope((Object)"RestrictHeapAccessAnnotationChecker", (Object)graph, (Object)method, (Object)this);){
                    this.postRestrictHeapAccessWarning(method.getWrapped(), this.restrictHeapAccessCallees.getCallerMap());
                }
                catch (Throwable t) {
                    throw debug.handle(t);
                }
            }
        }

        private void postRestrictHeapAccessWarning(AnalysisMethod violatingCallee, Map<AnalysisMethod, RestrictHeapAccessCalleesImpl.RestrictionInfo> callerMap) {
            if (Options.PrintRestrictHeapAccessWarnings.getValue().booleanValue()) {
                RestrictHeapAccess.Access violatedAccess = callerMap.get(violatingCallee).getAccess();
                Object message = "@RestrictHeapAccess warning: ";
                ArrayDeque<RestrictHeapAccessCalleesImpl.RestrictionInfo> callChain = new ArrayDeque<RestrictHeapAccessCalleesImpl.RestrictionInfo>();
                AnalysisMethod current = violatingCallee;
                while (current != null) {
                    RestrictHeapAccessCalleesImpl.RestrictionInfo info = callerMap.get(current);
                    callChain.addFirst(info);
                    current = info.getCaller();
                }
                ArrayDeque<RestrictHeapAccessCalleesImpl.RestrictionInfo> allocationList = new ArrayDeque<RestrictHeapAccessCalleesImpl.RestrictionInfo>();
                for (RestrictHeapAccessCalleesImpl.RestrictionInfo element : callChain) {
                    allocationList.addLast(element);
                    if (this.checkHostedViolatingNode(element.getMethod()) == null) continue;
                    break;
                }
                assert (!allocationList.isEmpty());
                if (allocationList.size() == 1) {
                    StackTraceElement allocationStackTraceElement = this.getViolatingStackTraceElement(violatingCallee);
                    message = allocationStackTraceElement != null ? (String)message + "Restricted method '" + allocationStackTraceElement.toString() + "' directly violates restriction " + String.valueOf((Object)violatedAccess) + "." : (String)message + "Restricted method '" + violatingCallee.format("%H.%n(%p)") + "' directly violates restriction " + String.valueOf((Object)violatedAccess) + ".";
                } else {
                    RestrictHeapAccessCalleesImpl.RestrictionInfo first = (RestrictHeapAccessCalleesImpl.RestrictionInfo)allocationList.getFirst();
                    RestrictHeapAccessCalleesImpl.RestrictionInfo last = (RestrictHeapAccessCalleesImpl.RestrictionInfo)allocationList.getLast();
                    message = (String)message + "Restricted method: '" + first.getMethod().format("%h.%n(%p)") + "' calls '" + last.getMethod().format("%h.%n(%p)") + "' that violates restriction " + String.valueOf((Object)violatedAccess) + ".";
                    if (Options.PrintRestrictHeapAccessPath.getValue().booleanValue()) {
                        message = (String)message + "\n  [Path:";
                        for (RestrictHeapAccessCalleesImpl.RestrictionInfo element : allocationList) {
                            if (element == first) continue;
                            message = (String)message + "\n    " + element.getInvocationStackTraceElement().toString();
                        }
                        StackTraceElement allocationStackTraceElement = this.getViolatingStackTraceElement(last.getMethod());
                        message = allocationStackTraceElement != null ? (String)message + "\n    " + allocationStackTraceElement.toString() : (String)message + "\n    " + last.getMethod().format("%H.%n(%p)");
                        message = (String)message + "]";
                    }
                }
                throw UserError.abort("%s", message);
            }
        }

        CompilationGraph.AllocationInfo checkHostedViolatingNode(AnalysisMethod method) {
            HostedMethod hostedMethod = this.universe.optionalLookup((JavaMethod)method);
            if (hostedMethod != null) {
                CompilationGraph graph = hostedMethod.compilationInfo.getCompilationGraph();
                return RestrictHeapAccessAnnotationChecker.checkViolatingNode(graph);
            }
            return null;
        }

        private StackTraceElement getViolatingStackTraceElement(AnalysisMethod method) {
            NodeSourcePosition sourcePosition;
            CompilationGraph graph;
            CompilationGraph.AllocationInfo node;
            HostedMethod hostedMethod = this.universe.optionalLookup((JavaMethod)method);
            if (hostedMethod != null && (node = RestrictHeapAccessAnnotationChecker.checkViolatingNode(graph = hostedMethod.compilationInfo.getCompilationGraph())) != null && (sourcePosition = node.getNodeSourcePosition()) != null && sourcePosition.getBCI() != -1) {
                return method.asStackTraceElement(sourcePosition.getBCI());
            }
            return null;
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> PrintRestrictHeapAccessWarnings = new HostedOptionKey<Boolean>(true);
        public static final HostedOptionKey<Boolean> PrintRestrictHeapAccessPath = new HostedOptionKey<Boolean>(true);
    }
}

