/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.deopt.DeoptEntryInfopoint;
import com.oracle.svm.core.deopt.DeoptTest;
import com.oracle.svm.core.graal.GraalConfiguration;
import com.oracle.svm.core.graal.code.StubCallingConvention;
import com.oracle.svm.core.graal.nodes.DeoptTestNode;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.lir.RedundantMoveElimination;
import org.graalvm.compiler.lir.alloc.RegisterAllocationPhase;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.BoxNodeOptimizationPhase;
import org.graalvm.compiler.phases.common.FixReadsPhase;
import org.graalvm.compiler.phases.common.FloatingReadPhase;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapePhase;
import org.graalvm.compiler.virtual.phases.ea.ReadEliminationPhase;

public class DeoptimizationUtils {
    static void insertDeoptTests(HostedMethod method, StructuredGraph graph) {
        for (Node node : graph.getNodes()) {
            if (!(node instanceof FixedWithNextNode) || !(node instanceof StateSplit) || node instanceof InvokeNode || node instanceof ForeignCallNode || node instanceof DeoptTestNode || method.isSynchronized() && node instanceof StartNode) continue;
            FixedWithNextNode fixedWithNext = (FixedWithNextNode)node;
            FixedNode next = fixedWithNext.next();
            DeoptTestNode testNode = (DeoptTestNode)graph.add((Node)new DeoptTestNode());
            fixedWithNext.setNext(null);
            testNode.setNext(next);
            fixedWithNext.setNext((FixedNode)testNode);
            if (((StateSplit)node).hasSideEffect() && ((StateSplit)node).stateAfter() != null) {
                testNode.setStateAfter(((StateSplit)node).stateAfter().duplicateWithVirtualState());
                continue;
            }
            testNode.setStateAfter(GraphUtil.findLastFrameState((FixedNode)((FixedNode)node)).duplicateWithVirtualState());
        }
    }

    private static boolean containsStackValueNode(HostedUniverse universe, HostedMethod method) {
        return universe.getBigBang().getHostVM().containsStackValueNode(method.wrapped);
    }

    static boolean canDeoptForTesting(HostedUniverse universe, HostedMethod method, boolean deoptimizeAll) {
        if (method.getName().equals("<clinit>")) {
            return false;
        }
        if (method.getAnnotation(DeoptTest.class) != null) {
            return true;
        }
        if (method.isEntryPoint()) {
            return false;
        }
        if (method.isNative()) {
            return false;
        }
        if (method.wrapped.isIntrinsicMethod()) {
            return false;
        }
        if (Uninterruptible.Utils.isUninterruptible(method)) {
            return false;
        }
        if (method.getAnnotation(RestrictHeapAccess.class) != null) {
            return false;
        }
        if (StubCallingConvention.Utils.hasStubCallingConvention(method)) {
            return false;
        }
        if (DeoptimizationUtils.containsStackValueNode(universe, method)) {
            return false;
        }
        if (deoptimizeAll) {
            String className = method.getDeclaringClass().getName();
            if (className.contains("/svm/core/code/CodeInfoEncoder") || className.contains("com/oracle/svm/core/thread/JavaThreads") || className.contains("com/oracle/svm/core/thread/PlatformThreads") || className.contains("com/oracle/svm/core/heap/") || className.contains("com/oracle/svm/core/genscavenge/") || className.contains("com/oracle/svm/core/thread/VMOperationControl") || className.contains("debug/internal/DebugValueMap") && method.getName().equals("registerTopLevel")) {
                return false;
            }
            return method.getCode() != null;
        }
        return false;
    }

    static void removeDeoptTargetOptimizations(Suites suites) {
        GraalConfiguration.hostedInstance().removeDeoptTargetOptimizations(suites);
        PhaseSuite highTier = suites.getHighTier();
        highTier.removePhase(PartialEscapePhase.class);
        highTier.removePhase(ReadEliminationPhase.class);
        highTier.removePhase(BoxNodeOptimizationPhase.class);
        PhaseSuite midTier = suites.getMidTier();
        midTier.removePhase(FloatingReadPhase.class);
        PhaseSuite lowTier = suites.getLowTier();
        ListIterator it = lowTier.findPhase(FixReadsPhase.class);
        if (it != null) {
            FixReadsPhase fixReads = (FixReadsPhase)it.previous();
            it.remove();
            boolean replaceInputsWithConstants = false;
            it.add(new FixReadsPhase(replaceInputsWithConstants, fixReads.getSchedulePhase()));
        }
    }

    static void removeDeoptTargetOptimizations(LIRSuites lirSuites) {
        ListIterator it = lirSuites.getPostAllocationOptimizationStage().findPhase(RedundantMoveElimination.class);
        if (it != null) {
            it.remove();
        }
        ((RegisterAllocationPhase)lirSuites.getAllocationStage().findPhaseInstance(RegisterAllocationPhase.class)).setNeverSpillConstants(true);
    }

    public static boolean isDeoptEntry(HostedMethod method, CompilationResult compilation, Infopoint infopoint) {
        BytecodeFrame topFrame;
        BytecodeFrame rootFrame = topFrame = infopoint.debugInfo.frame();
        while (rootFrame.caller() != null) {
            rootFrame = rootFrame.caller();
        }
        assert (rootFrame.getMethod().equals((Object)method));
        boolean isBciDeoptEntry = method.compilationInfo.isDeoptEntry(rootFrame.getBCI(), rootFrame.duringCall, rootFrame.rethrowException);
        if (isBciDeoptEntry) {
            assert (topFrame == rootFrame) : "Deoptimization target has inlined frame: " + String.valueOf(topFrame);
            if (topFrame.duringCall) {
                VMError.guarantee(infopoint instanceof Call, "Unexpected infopoint type: %s%nFrame: %s", infopoint, topFrame);
                return compilation.isValidCallDeoptimizationState((Call)infopoint);
            }
            return infopoint instanceof DeoptEntryInfopoint;
        }
        return false;
    }

    static boolean verifyDeoptTarget(HostedMethod method, StructuredGraph graph, CompilationResult result) {
        HashMap<Long, BytecodeFrame> encodedBciMap = new HashMap<Long, BytecodeFrame>();
        assert (graph != null) : "Deopt target must have a graph.";
        assert (graph.getNodes(StackValueNode.TYPE).isEmpty()) : "No stack value nodes must be present in deopt target.";
        for (Infopoint infopoint : result.getInfopoints()) {
            DebugInfo debugInfo;
            if (infopoint.debugInfo == null || !(debugInfo = infopoint.debugInfo).hasFrame() || !DeoptimizationUtils.isDeoptEntry(method, result, infopoint)) continue;
            BytecodeFrame frame = debugInfo.frame();
            long encodedBci = FrameInfoEncoder.encodeBci(frame.getBCI(), frame.duringCall, frame.rethrowException);
            BytecodeFrame previous = encodedBciMap.put(encodedBci, frame);
            assert (previous == null) : "duplicate encoded bci " + encodedBci + " in deopt target " + String.valueOf(method) + " found.\n\n" + String.valueOf(frame) + "\n\n" + String.valueOf(previous);
        }
        return true;
    }

    static boolean canBeUsedForInlining(HostedUniverse universe, HostedMethod caller, HostedMethod callee, int bci, boolean deoptimizeAll) {
        if (DeoptimizationUtils.canDeoptForTesting(universe, caller, deoptimizeAll) && Modifier.isNative(callee.getModifiers())) {
            return false;
        }
        if (DeoptimizationUtils.canDeoptForTesting(universe, caller, deoptimizeAll) && DeoptimizationUtils.containsStackValueNode(universe, callee)) {
            return false;
        }
        if (caller.isDeoptTarget()) {
            if (caller.compilationInfo.isDeoptEntry(bci, true, false)) {
                return false;
            }
            if (SubstrateCompilationDirectives.singleton().isDeoptInliningExclude(callee)) {
                return false;
            }
        }
        return true;
    }

    public static Collection<ResolvedJavaMethod> registerDeoptEntries(StructuredGraph graph, boolean isRoot, DeoptTargetRetriever deoptRetriever) {
        HashSet<ResolvedJavaMethod> changedMethods = new HashSet<ResolvedJavaMethod>();
        for (FrameState frameState : graph.getNodes(FrameState.TYPE)) {
            if (frameState.hasExactlyOneUsage()) {
                Node usage = frameState.usages().first();
                if (!isRoot && usage == graph.start()) continue;
                if (usage instanceof Invoke && ((Invoke)usage).stateAfter() == frameState) {
                    FixedNode next = ((Invoke)usage).next();
                    while (next instanceof AbstractBeginNode) {
                        next = ((AbstractBeginNode)next).next();
                    }
                    if (next instanceof LoweredDeadEndNode) continue;
                }
            }
            for (FrameState inlineState = frameState; inlineState != null; inlineState = inlineState.outerFrameState()) {
                if (inlineState.bci < 0) continue;
                ResolvedJavaMethod method = deoptRetriever.getDeoptTarget(inlineState.getMethod());
                if (!SubstrateCompilationDirectives.singleton().registerDeoptEntry(inlineState, method)) continue;
                changedMethods.add(method);
            }
        }
        for (Node n : graph.getNodes()) {
            if (!(n instanceof Invoke)) continue;
            Invoke invoke = (Invoke)n;
            FrameState stateDuring = invoke.stateAfter().duplicateModifiedDuringCall(invoke.bci(), invoke.asNode().getStackKind());
            assert (stateDuring.duringCall() && !stateDuring.rethrowException());
            ResolvedJavaMethod method = deoptRetriever.getDeoptTarget(stateDuring.getMethod());
            if (!SubstrateCompilationDirectives.singleton().registerDeoptEntry(stateDuring, method)) continue;
            changedMethods.add(method);
        }
        return changedMethods;
    }

    public static interface DeoptTargetRetriever {
        public ResolvedJavaMethod getDeoptTarget(ResolvedJavaMethod var1);
    }
}

