/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.BootModuleLayerSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageClassLoaderSupport;
import com.oracle.svm.hosted.ResourcesFeature;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.module.Configuration;
import java.lang.module.FindException;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.module.ResolutionException;
import java.lang.module.ResolvedModule;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.internal.module.DefaultRoots;
import jdk.internal.module.ModuleBootstrap;
import jdk.internal.module.SystemModuleFinders;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public final class ModuleLayerFeature
implements InternalFeature {
    private ModuleLayerFeatureUtils moduleLayerFeatureUtils;

    public void duringSetup(Feature.DuringSetupAccess access) {
        FeatureImpl.DuringSetupAccessImpl accessImpl = (FeatureImpl.DuringSetupAccessImpl)access;
        this.moduleLayerFeatureUtils = new ModuleLayerFeatureUtils(accessImpl.imageClassLoader);
        Set<String> baseModules = ModuleLayer.boot().modules().stream().map(Module::getName).collect(Collectors.toSet());
        Function<String, ClassLoader> clf = this.moduleLayerFeatureUtils::getClassLoaderForBootLayerModule;
        ModuleLayer runtimeBootLayer = this.synthesizeRuntimeModuleLayer(new ArrayList<ModuleLayer>(List.of(ModuleLayer.empty())), accessImpl.imageClassLoader, baseModules, Set.of(), clf, null);
        BootModuleLayerSupport.instance().setBootLayer(runtimeBootLayer);
        access.registerObjectReplacer(this::replaceHostedModules);
    }

    private Object replaceHostedModules(Object source) {
        if (source instanceof Module) {
            Module module = (Module)source;
            return this.moduleLayerFeatureUtils.getOrCreateRuntimeModuleForHostedModule(module, module.getDescriptor());
        }
        return source;
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(BootModuleLayerSupport.class, (Object)new BootModuleLayerSupport());
        List bootLayerAutomaticModules = ModuleLayer.boot().modules().stream().filter(m -> m.isNamed() && m.getDescriptor().isAutomatic()).collect(Collectors.toList());
        if (!bootLayerAutomaticModules.isEmpty()) {
            System.out.println("Warning: Detected automatic module(s) on the module-path of the image builder:" + System.lineSeparator() + bootLayerAutomaticModules.stream().map(ModuleLayerFeatureUtils::formatModule).collect(Collectors.joining(System.lineSeparator())) + System.lineSeparator() + "Extending the image builder with automatic modules is not supported and might result in failed build. This is probably caused by specifying a jar-file that is not a proper module on the module-path. Please ensure that only proper modules are found on the module-path");
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        FeatureImpl.AfterAnalysisAccessImpl accessImpl = (FeatureImpl.AfterAnalysisAccessImpl)access;
        Set<Module> runtimeImageNamedModules = accessImpl.getUniverse().getTypes().stream().filter(ModuleLayerFeature::typeIsReachable).map(t -> t.getJavaClass().getModule()).filter(Module::isNamed).collect(Collectors.toSet());
        Set<String> extraModules = ModuleLayerFeatureUtils.parseModuleSetModifierProperty("org.graalvm.nativeimage.module.addmods");
        Set includedResourceModules = ((ResourcesFeature)ImageSingletons.lookup(ResourcesFeature.class)).includedResourcesModules.stream().map(Module::getName).filter(Objects::nonNull).collect(Collectors.toSet());
        extraModules.addAll(includedResourceModules);
        extraModules.stream().filter(Predicate.not(ModuleSupport.nonExplicitModules::contains)).forEach(moduleName -> {
            Optional<Module> module = accessImpl.imageClassLoader.findModule((String)moduleName);
            if (module.isEmpty()) {
                throw VMError.shouldNotReachHere("Explicitly required module " + moduleName + " is not available");
            }
            runtimeImageNamedModules.add(module.get());
        });
        Set<Module> analysisReachableSyntheticModules = runtimeImageNamedModules.stream().filter(ModuleLayerFeatureUtils::isModuleSynthetic).collect(Collectors.toSet());
        List<ModuleLayer> reachableModuleLayers = runtimeImageNamedModules.stream().map(Module::getLayer).filter(Objects::nonNull).distinct().sorted(Comparator.comparingInt(ModuleLayerFeatureUtils::distanceFromBootModuleLayer)).collect(Collectors.toList());
        if (!accessImpl.imageClassLoader.applicationClassPath().isEmpty()) {
            extraModules.add("ALL-MODULE-PATH");
        }
        Set<String> rootModules = this.calculateRootModules(extraModules);
        List<ModuleLayer> runtimeModuleLayers = this.synthesizeRuntimeModuleLayers(accessImpl, reachableModuleLayers, runtimeImageNamedModules, analysisReachableSyntheticModules, rootModules);
        ModuleLayer runtimeBootLayer = runtimeModuleLayers.get(0);
        BootModuleLayerSupport.instance().setBootLayer(runtimeBootLayer);
        this.replicateVisibilityModifications(runtimeBootLayer, accessImpl.imageClassLoader, runtimeImageNamedModules);
    }

    private Set<String> calculateRootModules(Collection<String> addModules) {
        ModuleFinder f;
        boolean haveModulePath;
        ModuleFinder upgradeModulePath = NativeImageClassLoaderSupport.finderFor("jdk.module.upgrade.path");
        ModuleFinder appModulePath = this.moduleLayerFeatureUtils.getAppModuleFinder();
        String mainModule = ModuleLayerFeatureUtils.getMainModuleName();
        Set<String> limitModules = ModuleLayerFeatureUtils.parseModuleSetModifierProperty("org.graalvm.nativeimage.module.limitmods");
        Object systemModules = null;
        boolean bl = haveModulePath = appModulePath != null || upgradeModulePath != null;
        if (!haveModulePath && addModules.isEmpty() && limitModules.isEmpty()) {
            systemModules = this.moduleLayerFeatureUtils.invokeSystemModuleFinderSystemModules(mainModule);
        }
        if (systemModules == null) {
            systemModules = this.moduleLayerFeatureUtils.invokeSystemModuleFinderAllSystemModules();
        }
        ModuleFinder systemModuleFinder = systemModules != null ? this.moduleLayerFeatureUtils.invokeSystemModuleFinderOf(systemModules) : SystemModuleFinders.ofSystem();
        ModuleFinder builderModuleFinder = NativeImageClassLoaderSupport.finderFor("jdk.module.path");
        if (builderModuleFinder != null) {
            systemModuleFinder = ModuleFinder.compose(systemModuleFinder, builderModuleFinder);
        }
        if (upgradeModulePath != null) {
            systemModuleFinder = ModuleFinder.compose(upgradeModulePath, systemModuleFinder);
        }
        ModuleFinder finder = appModulePath != null ? ModuleFinder.compose(systemModuleFinder, appModulePath) : systemModuleFinder;
        HashSet<String> roots = new HashSet<String>();
        if (mainModule != null) {
            roots.add(mainModule);
        }
        boolean addAllDefaultModules = false;
        boolean addAllSystemModules = false;
        boolean addAllApplicationModules = false;
        Iterator<String> iterator = addModules.iterator();
        block10: while (iterator.hasNext()) {
            String mod;
            switch (mod = iterator.next()) {
                case "ALL-DEFAULT": {
                    addAllDefaultModules = true;
                    continue block10;
                }
                case "ALL-SYSTEM": {
                    addAllSystemModules = true;
                    continue block10;
                }
                case "ALL-MODULE-PATH": {
                    addAllApplicationModules = true;
                    continue block10;
                }
            }
            roots.add(mod);
        }
        if (!limitModules.isEmpty()) {
            finder = this.moduleLayerFeatureUtils.invokeModuleBootstrapLimitFinder(finder, limitModules, roots);
        }
        if (mainModule == null || addAllDefaultModules) {
            roots.addAll(this.moduleLayerFeatureUtils.invokeDefaultRootsComputeMethod(systemModuleFinder, finder));
        }
        if (addAllSystemModules) {
            f = finder;
            systemModuleFinder.findAll().stream().map(ModuleReference::descriptor).map(ModuleDescriptor::name).filter(mn -> f.find((String)mn).isPresent()).forEach(roots::add);
        }
        if (appModulePath != null && addAllApplicationModules) {
            f = finder;
            appModulePath.findAll().stream().map(ModuleReference::descriptor).map(ModuleDescriptor::name).filter(mn -> f.find((String)mn).isPresent()).forEach(roots::add);
        }
        return roots;
    }

    private static boolean typeIsReachable(AnalysisType t) {
        return t.isReachable() && !t.isArray();
    }

    private static Stream<String> extractRequiredModuleNames(Module m) {
        Stream<String> requiredModules = m.getDescriptor().requires().stream().map(ModuleDescriptor.Requires::name);
        return Stream.concat(Stream.of(m.getName()), requiredModules);
    }

    private List<ModuleLayer> synthesizeRuntimeModuleLayers(FeatureImpl.AfterAnalysisAccessImpl accessImpl, List<ModuleLayer> hostedModuleLayers, Collection<Module> reachableNamedModules, Collection<Module> reachableSyntheticModules, Collection<String> rootModuleNames) {
        HashMap<ModuleLayer, ModuleLayer> moduleLayerPairs = new HashMap<ModuleLayer, ModuleLayer>(hostedModuleLayers.size());
        moduleLayerPairs.put(ModuleLayer.empty(), ModuleLayer.empty());
        Set allReachableAndRequiredModuleNames = reachableNamedModules.stream().flatMap(ModuleLayerFeature::extractRequiredModuleNames).collect(Collectors.toSet());
        for (ModuleLayer hostedModuleLayer : hostedModuleLayers) {
            if (hostedModuleLayer == accessImpl.imageClassLoader.classLoaderSupport.moduleLayerForImageBuild) continue;
            boolean isBootModuleLayer = hostedModuleLayer == ModuleLayer.boot();
            Set<String> moduleNames = hostedModuleLayer.modules().stream().map(Module::getName).collect(Collectors.toSet());
            moduleNames.retainAll(allReachableAndRequiredModuleNames);
            if (isBootModuleLayer) {
                moduleNames.addAll(rootModuleNames);
            }
            HashSet<Module> syntheticModules = new HashSet<Module>();
            if (isBootModuleLayer) {
                syntheticModules.addAll(reachableSyntheticModules);
            }
            List<ModuleLayer> parents = hostedModuleLayer.parents().stream().map(moduleLayerPairs::get).collect(Collectors.toList());
            Configuration cf = isBootModuleLayer ? null : hostedModuleLayer.configuration();
            Function<String, ClassLoader> clf = name -> this.moduleLayerFeatureUtils.getClassLoaderForModuleInModuleLayer(hostedModuleLayer, (String)name);
            ModuleLayer runtimeModuleLayer = this.synthesizeRuntimeModuleLayer(parents, accessImpl.imageClassLoader, moduleNames, syntheticModules, clf, cf);
            moduleLayerPairs.put(hostedModuleLayer, runtimeModuleLayer);
        }
        moduleLayerPairs.remove(ModuleLayer.empty());
        return new ArrayList<ModuleLayer>(moduleLayerPairs.values());
    }

    private ModuleLayer synthesizeRuntimeModuleLayer(List<ModuleLayer> parentLayers, ImageClassLoader cl, Set<String> reachableModules, Set<Module> syntheticModules, Function<String, ClassLoader> clf, Configuration cfOverride) {
        Configuration runtimeModuleLayerConfiguration;
        NativeImageClassLoaderSupport classLoaderSupport = cl.classLoaderSupport;
        ModuleFinder beforeFinder = classLoaderSupport.modulepathModuleFinder;
        ModuleFinder afterFinder = classLoaderSupport.upgradeAndSystemModuleFinder;
        if (cfOverride == null) {
            List<Configuration> parentConfigs = parentLayers.stream().map(ModuleLayer::configuration).collect(Collectors.toList());
            runtimeModuleLayerConfiguration = ModuleLayerFeature.synthesizeRuntimeModuleLayerConfiguration(beforeFinder, parentConfigs, afterFinder, reachableModules);
        } else {
            runtimeModuleLayerConfiguration = cfOverride;
        }
        ModuleLayer runtimeModuleLayer = null;
        try {
            runtimeModuleLayer = this.moduleLayerFeatureUtils.createNewModuleLayerInstance(runtimeModuleLayerConfiguration);
            Map<String, Module> nameToModule = this.moduleLayerFeatureUtils.synthesizeNameToModule(runtimeModuleLayer, clf);
            for (Module syntheticModule : syntheticModules) {
                Module runtimeSyntheticModule = this.moduleLayerFeatureUtils.getOrCreateRuntimeModuleForHostedModule(syntheticModule, syntheticModule.getDescriptor());
                nameToModule.putIfAbsent(runtimeSyntheticModule.getName(), runtimeSyntheticModule);
                this.moduleLayerFeatureUtils.patchModuleLayerField(runtimeSyntheticModule, runtimeModuleLayer);
            }
            this.patchRuntimeModuleLayer(runtimeModuleLayer, nameToModule, parentLayers);
            return runtimeModuleLayer;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw VMError.shouldNotReachHere("Failed to synthesize the runtime module layer: " + String.valueOf(runtimeModuleLayer), ex);
        }
    }

    private void replicateVisibilityModifications(ModuleLayer runtimeBootLayer, ImageClassLoader cl, Set<Module> analysisReachableNamedModules) {
        List<Module> applicationModules = ModuleLayerFeature.findApplicationModules(runtimeBootLayer, cl.applicationModulePath());
        Map<Module, Module> modulePairs = analysisReachableNamedModules.stream().collect(Collectors.toMap(m -> m, m -> this.moduleLayerFeatureUtils.getRuntimeModuleForHostedModule((Module)m, false)));
        modulePairs.put(this.moduleLayerFeatureUtils.allUnnamedModule, this.moduleLayerFeatureUtils.allUnnamedModule);
        modulePairs.put(this.moduleLayerFeatureUtils.everyoneModule, this.moduleLayerFeatureUtils.everyoneModule);
        Module builderModule = ModuleLayerFeatureUtils.getBuilderModule();
        assert (builderModule != null);
        try {
            for (Map.Entry<Module, Module> e1 : modulePairs.entrySet()) {
                Module hostedFrom = e1.getKey();
                if (!hostedFrom.isNamed()) continue;
                Module runtimeFrom = e1.getValue();
                for (Map.Entry<Module, Module> e2 : modulePairs.entrySet()) {
                    Module hostedTo = e2.getKey();
                    if (hostedTo == hostedFrom) continue;
                    Module runtimeTo = e2.getValue();
                    if (ModuleLayerFeatureUtils.isModuleSynthetic(hostedFrom) || hostedFrom.canRead(hostedTo)) {
                        this.moduleLayerFeatureUtils.addReads(runtimeFrom, runtimeTo);
                        if (hostedFrom == builderModule) {
                            for (Module appModule : applicationModules) {
                                this.moduleLayerFeatureUtils.addReads(appModule, runtimeTo);
                            }
                        }
                    }
                    for (String pn : runtimeFrom.getPackages()) {
                        if (ModuleLayerFeatureUtils.isModuleSynthetic(hostedFrom) || hostedFrom.isOpen(pn, hostedTo)) {
                            this.moduleLayerFeatureUtils.addOpens(runtimeFrom, pn, runtimeTo);
                            if (hostedTo == builderModule) {
                                for (Module appModule : applicationModules) {
                                    this.moduleLayerFeatureUtils.addOpens(runtimeFrom, pn, appModule);
                                }
                            }
                        }
                        if (!ModuleLayerFeatureUtils.isModuleSynthetic(hostedFrom) && !hostedFrom.isExported(pn, hostedTo)) continue;
                        this.moduleLayerFeatureUtils.addExports(runtimeFrom, pn, runtimeTo);
                        if (hostedTo != builderModule) continue;
                        for (Module appModule : applicationModules) {
                            this.moduleLayerFeatureUtils.addExports(runtimeFrom, pn, appModule);
                        }
                    }
                }
            }
        }
        catch (IllegalAccessException ex) {
            throw VMError.shouldNotReachHere("Failed to transfer hosted module relations to the runtime boot module layer.", ex);
        }
    }

    private static List<Module> findApplicationModules(ModuleLayer runtimeBootLayer, List<Path> applicationModulePath) {
        List applicationModuleNames;
        ArrayList<Module> applicationModules = new ArrayList<Module>();
        try {
            ModuleFinder applicationModuleFinder = ModuleFinder.of((Path[])applicationModulePath.toArray(Path[]::new));
            applicationModuleNames = applicationModuleFinder.findAll().stream().map(m -> m.descriptor().name()).collect(Collectors.toList());
        }
        catch (SecurityException | FindException | ResolutionException ex) {
            throw VMError.shouldNotReachHere("Failed to locate application modules.", ex);
        }
        for (String moduleName : applicationModuleNames) {
            Optional<Module> module = runtimeBootLayer.findModule(moduleName);
            if (module.isEmpty()) continue;
            applicationModules.add(module.get());
        }
        return applicationModules;
    }

    private static Configuration synthesizeRuntimeModuleLayerConfiguration(ModuleFinder beforeFinder, List<Configuration> parentConfigs, ModuleFinder afterFinder, Set<String> reachableModules) {
        try {
            ModuleFinder composed = ModuleFinder.compose(beforeFinder, afterFinder);
            ArrayList<String> missingModules = new ArrayList<String>();
            for (String module : reachableModules) {
                Optional<ModuleReference> mref = composed.find(module);
                if (!mref.isEmpty()) continue;
                missingModules.add(module);
            }
            reachableModules.removeAll(missingModules);
            return Configuration.resolve(beforeFinder, parentConfigs, afterFinder, reachableModules);
        }
        catch (SecurityException | FindException | ResolutionException ex) {
            throw VMError.shouldNotReachHere("Failed to synthesize the runtime boot module layer configuration.", ex);
        }
    }

    private void patchRuntimeModuleLayer(ModuleLayer runtimeModuleLayer, Map<String, Module> nameToModule, List<ModuleLayer> parents) {
        try {
            this.moduleLayerFeatureUtils.patchModuleLayerNameToModuleField(runtimeModuleLayer, nameToModule);
            this.moduleLayerFeatureUtils.patchModuleLayerParentsField(runtimeModuleLayer, parents);
        }
        catch (IllegalAccessException ex) {
            throw VMError.shouldNotReachHere("Failed to patch the runtime boot module layer.", ex);
        }
        runtimeModuleLayer.modules();
    }

    private static final class ModuleLayerFeatureUtils {
        private final Map<ClassLoader, Map<String, Module>> runtimeModules = new HashMap<ClassLoader, Map<String, Module>>();
        private final ImageClassLoader imageClassLoader;
        private final Module allUnnamedModule;
        private final Set<Module> allUnnamedModuleSet;
        private final Module everyoneModule;
        private final Set<Module> everyoneSet;
        private final Constructor<Module> moduleConstructor;
        private final Field moduleDescriptorField;
        private final Field moduleLayerField;
        private final Field moduleLoaderField;
        private final Field moduleReadsField;
        private final Field moduleOpenPackagesField;
        private final Field moduleExportedPackagesField;
        private final Method moduleFindModuleMethod;
        private final Method systemModuleFindersAllSystemModulesMethod;
        private final Method systemModuleFindersOfMethod;
        private final Method systemModuleFindersSystemModulesMethod;
        private final Method moduleBootstrapLimitFinderMethod;
        private final Method defaultRootsComputeMethod;
        private final Constructor<ModuleLayer> moduleLayerConstructor;
        private final Field moduleLayerNameToModuleField;
        private final Field moduleLayerParentsField;

        ModuleLayerFeatureUtils(ImageClassLoader cl) {
            this.imageClassLoader = cl;
            Method classGetDeclaredMethods0Method = ReflectionUtil.lookupMethod(Class.class, (String)"getDeclaredFields0", (Class[])new Class[]{Boolean.TYPE});
            try {
                ModuleSupport.accessModuleByClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, ModuleLayerFeature.class, Module.class);
                Field[] moduleClassFields = (Field[])classGetDeclaredMethods0Method.invoke(Module.class, false);
                Field everyoneModuleField = ModuleLayerFeatureUtils.findFieldByName(moduleClassFields, "EVERYONE_MODULE");
                everyoneModuleField.setAccessible(true);
                this.everyoneModule = (Module)everyoneModuleField.get(null);
                Field allUnnamedModuleField = ModuleLayerFeatureUtils.findFieldByName(moduleClassFields, "ALL_UNNAMED_MODULE");
                allUnnamedModuleField.setAccessible(true);
                this.allUnnamedModule = (Module)allUnnamedModuleField.get(null);
                this.moduleDescriptorField = ModuleLayerFeatureUtils.findFieldByName(moduleClassFields, "descriptor");
                this.moduleLayerField = ModuleLayerFeatureUtils.findFieldByName(moduleClassFields, "layer");
                this.moduleLoaderField = ModuleLayerFeatureUtils.findFieldByName(moduleClassFields, "loader");
                this.moduleReadsField = ModuleLayerFeatureUtils.findFieldByName(moduleClassFields, "reads");
                this.moduleOpenPackagesField = ModuleLayerFeatureUtils.findFieldByName(moduleClassFields, "openPackages");
                this.moduleExportedPackagesField = ModuleLayerFeatureUtils.findFieldByName(moduleClassFields, "exportedPackages");
                this.moduleDescriptorField.setAccessible(true);
                this.moduleLayerField.setAccessible(true);
                this.moduleLoaderField.setAccessible(true);
                this.moduleReadsField.setAccessible(true);
                this.moduleOpenPackagesField.setAccessible(true);
                this.moduleExportedPackagesField.setAccessible(true);
                this.allUnnamedModuleSet = new HashSet<Module>(1);
                this.allUnnamedModuleSet.add(this.allUnnamedModule);
                this.patchModuleLoaderField(this.allUnnamedModule, this.imageClassLoader.getClassLoader());
                this.everyoneSet = new HashSet<Module>(1);
                this.everyoneSet.add(this.everyoneModule);
                this.moduleConstructor = ReflectionUtil.lookupConstructor(Module.class, (Class[])new Class[]{ClassLoader.class, ModuleDescriptor.class});
                this.moduleFindModuleMethod = ReflectionUtil.lookupMethod(Module.class, (String)"findModule", (Class[])new Class[]{String.class, Map.class, Map.class, List.class});
                this.systemModuleFindersAllSystemModulesMethod = ReflectionUtil.lookupMethod(SystemModuleFinders.class, (String)"allSystemModules", (Class[])new Class[0]);
                this.systemModuleFindersOfMethod = ReflectionUtil.lookupMethod(SystemModuleFinders.class, (String)"of", (Class[])new Class[]{Class.forName("jdk.internal.module.SystemModules")});
                this.systemModuleFindersSystemModulesMethod = ReflectionUtil.lookupMethod(SystemModuleFinders.class, (String)"systemModules", (Class[])new Class[]{String.class});
                this.moduleBootstrapLimitFinderMethod = ReflectionUtil.lookupMethod(ModuleBootstrap.class, (String)"limitFinder", (Class[])new Class[]{ModuleFinder.class, Set.class, Set.class});
                this.defaultRootsComputeMethod = ReflectionUtil.lookupMethod(DefaultRoots.class, (String)"compute", (Class[])new Class[]{ModuleFinder.class, ModuleFinder.class});
                this.moduleLayerConstructor = ReflectionUtil.lookupConstructor(ModuleLayer.class, (Class[])new Class[]{Configuration.class, List.class, Function.class});
                this.moduleLayerNameToModuleField = ReflectionUtil.lookupField(ModuleLayer.class, (String)"nameToModule");
                this.moduleLayerParentsField = ReflectionUtil.lookupField(ModuleLayer.class, (String)"parents");
            }
            catch (ReflectiveOperationException | NoSuchElementException ex) {
                throw VMError.shouldNotReachHere("Failed to retrieve fields of the Module/ModuleLayer class.", ex);
            }
        }

        private static Field findFieldByName(Field[] fields, String name) {
            return Arrays.stream(fields).filter(f -> f.getName().equals(name)).findAny().orElseThrow(VMError::shouldNotReachHere);
        }

        private static boolean isModuleSynthetic(Module m) {
            return m.getDescriptor() != null && m.getDescriptor().modifiers().contains((Object)ModuleDescriptor.Modifier.SYNTHETIC);
        }

        static String formatModule(Module module) {
            if (!module.isNamed()) {
                return module.toString();
            }
            Optional<ResolvedModule> optionalResolvedModule = module.getLayer().configuration().findModule(module.getName());
            assert (optionalResolvedModule.isPresent());
            ResolvedModule resolvedModule = optionalResolvedModule.get();
            Optional<URI> location = resolvedModule.reference().location();
            if (location.isPresent()) {
                return String.valueOf(module) + ", location: " + String.valueOf(location);
            }
            return module.toString();
        }

        static Set<String> parseModuleSetModifierProperty(String prop) {
            HashSet<String> specifiedModules = new HashSet<String>();
            String args = System.getProperty(prop, "");
            if (!args.isEmpty()) {
                specifiedModules.addAll(Arrays.asList(SubstrateUtil.split(args, ",")));
            }
            return specifiedModules;
        }

        static int distanceFromBootModuleLayer(ModuleLayer layer) {
            if (layer == ModuleLayer.boot()) {
                return 0;
            }
            return layer.parents().stream().map(p -> 1 + ModuleLayerFeatureUtils.distanceFromBootModuleLayer(p)).max(Integer::compareTo).orElse(0);
        }

        public static Module getBuilderModule() {
            return ModuleLayerFeature.class.getModule();
        }

        public static String getMainModuleName() {
            String mainModule = SubstrateOptions.Module.getValue();
            return mainModule.isEmpty() ? null : mainModule;
        }

        public ModuleFinder getAppModuleFinder() {
            List<Path> appModulePath = this.imageClassLoader.applicationModulePath();
            if (appModulePath.isEmpty()) {
                return null;
            }
            return ModuleFinder.of(appModulePath.toArray(new Path[0]));
        }

        public Module getRuntimeModuleForHostedModule(Module hostedModule, boolean optional) {
            if (hostedModule.isNamed()) {
                return this.getRuntimeModuleForHostedModule(hostedModule.getClassLoader(), hostedModule.getName(), optional);
            }
            if (hostedModule == this.everyoneModule) {
                return this.everyoneModule;
            }
            return this.allUnnamedModule;
        }

        public Module getRuntimeModuleForHostedModule(ClassLoader loader, String hostedModuleName, boolean optional) {
            Map<String, Module> loaderRuntimeModules = this.runtimeModules.get(loader);
            if (loaderRuntimeModules == null) {
                if (optional) {
                    return null;
                }
                throw VMError.shouldNotReachHere("Failed to find runtime module for hosted module " + hostedModuleName + ". No runtime modules have been registered for class loader: " + String.valueOf(loader));
            }
            Module runtimeModule = loaderRuntimeModules.get(hostedModuleName);
            if (runtimeModule == null) {
                if (optional) {
                    return null;
                }
                throw VMError.shouldNotReachHere("Runtime module " + hostedModuleName + " is not registered for class loader: " + String.valueOf(loader));
            }
            return runtimeModule;
        }

        public Module getOrCreateRuntimeModuleForHostedModule(Module hostedModule, ModuleDescriptor runtimeModuleDescriptor) {
            if (hostedModule.isNamed()) {
                return this.getOrCreateRuntimeModuleForHostedModule(hostedModule.getClassLoader(), hostedModule.getName(), runtimeModuleDescriptor);
            }
            return hostedModule == this.everyoneModule ? this.everyoneModule : this.allUnnamedModule;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Module getOrCreateRuntimeModuleForHostedModule(ClassLoader loader, String hostedModuleName, ModuleDescriptor runtimeModuleDescriptor) {
            Map<ClassLoader, Map<String, Module>> map = this.runtimeModules;
            synchronized (map) {
                Module runtimeModule = this.getRuntimeModuleForHostedModule(loader, hostedModuleName, true);
                if (runtimeModule != null) {
                    return runtimeModule;
                }
                try {
                    runtimeModule = this.moduleConstructor.newInstance(loader, runtimeModuleDescriptor);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                    throw VMError.shouldNotReachHere("Failed to reflectively construct a runtime Module object.", ex);
                }
                this.runtimeModules.putIfAbsent(loader, new HashMap());
                this.runtimeModules.get(loader).put(hostedModuleName, runtimeModule);
                return runtimeModule;
            }
        }

        Map<String, Module> synthesizeNameToModule(ModuleLayer runtimeModuleLayer, Function<String, ClassLoader> clf) throws IllegalAccessException, InvocationTargetException {
            ModuleDescriptor descriptor;
            ModuleReference mref;
            Configuration cf = runtimeModuleLayer.configuration();
            int cap = (int)((float)cf.modules().size() / 0.75f + 1.0f);
            HashMap<String, Module> nameToModule = new HashMap<String, Module>(cap);
            for (ResolvedModule resolvedModule : cf.modules()) {
                String name;
                ClassLoader loader;
                Module m;
                mref = resolvedModule.reference();
                descriptor = mref.descriptor();
                if (!descriptor.equals((m = this.getOrCreateRuntimeModuleForHostedModule(loader = clf.apply(name = descriptor.name()), name, descriptor)).getDescriptor())) {
                    this.moduleDescriptorField.set(m, descriptor);
                }
                this.patchModuleLayerField(m, runtimeModuleLayer);
                nameToModule.put(name, m);
            }
            for (ResolvedModule resolvedModule : cf.modules()) {
                Module m2;
                HashSet<Module> targets;
                String source;
                mref = resolvedModule.reference();
                descriptor = mref.descriptor();
                String mn = descriptor.name();
                Module m = (Module)nameToModule.get(mn);
                assert (m != null);
                HashSet<Module> reads = new HashSet<Module>(resolvedModule.reads().size());
                for (ResolvedModule resolvedModule2 : resolvedModule.reads()) {
                    Module m22 = (Module)nameToModule.get(resolvedModule2.name());
                    reads.add(m22);
                }
                if (descriptor.isAutomatic()) {
                    reads.add(this.allUnnamedModule);
                }
                this.moduleReadsField.set(m, reads);
                if (descriptor.isOpen() || descriptor.isAutomatic()) continue;
                if (descriptor.opens().isEmpty()) {
                    HashMap<String, Set<Object>> exportedPackages = new HashMap<String, Set<Object>>(m.getDescriptor().exports().size());
                    for (ModuleDescriptor.Exports exports : m.getDescriptor().exports()) {
                        source = exports.source();
                        if (exports.isQualified()) {
                            targets = new HashSet(exports.targets().size());
                            for (String target : exports.targets()) {
                                m2 = (Module)nameToModule.get(target);
                                if (m2 == null) continue;
                                targets.add(m2);
                            }
                            if (targets.isEmpty()) continue;
                            exportedPackages.put(source, targets);
                            continue;
                        }
                        exportedPackages.put(source, this.everyoneSet);
                    }
                    this.moduleExportedPackagesField.set(m, exportedPackages);
                    continue;
                }
                HashMap<String, Set<Object>> openPackages = new HashMap<String, Set<Object>>(descriptor.opens().size());
                for (ModuleDescriptor.Opens opens : descriptor.opens()) {
                    source = opens.source();
                    if (opens.isQualified()) {
                        targets = new HashSet<Module>(opens.targets().size());
                        for (String target : opens.targets()) {
                            m2 = (Module)this.moduleFindModuleMethod.invoke(null, target, Map.of(), nameToModule, runtimeModuleLayer.parents());
                            if (m2 == null) continue;
                            targets.add(m2);
                        }
                        if (targets.isEmpty()) continue;
                        openPackages.put(source, targets);
                        continue;
                    }
                    openPackages.put(source, this.everyoneSet);
                }
                HashMap<String, Set<Object>> hashMap = new HashMap<String, Set<Object>>(descriptor.exports().size());
                for (ModuleDescriptor.Exports exports : descriptor.exports()) {
                    String source2 = exports.source();
                    Set openToTargets = (Set)openPackages.get(source2);
                    if (openToTargets != null && openToTargets.contains(this.everyoneModule)) continue;
                    if (exports.isQualified()) {
                        HashSet<Module> targets2 = new HashSet<Module>(exports.targets().size());
                        for (String target : exports.targets()) {
                            Module m23 = (Module)this.moduleFindModuleMethod.invoke(null, target, Map.of(), nameToModule, runtimeModuleLayer.parents());
                            if (m23 == null || openToTargets != null && openToTargets.contains(m23)) continue;
                            targets2.add(m23);
                        }
                        if (targets2.isEmpty()) continue;
                        hashMap.put(source2, targets2);
                        continue;
                    }
                    hashMap.put(source2, this.everyoneSet);
                }
                this.moduleOpenPackagesField.set(m, openPackages);
                this.moduleExportedPackagesField.set(m, hashMap);
            }
            return nameToModule;
        }

        void addReads(Module module, Module other) throws IllegalAccessException {
            HashSet<Module> reads = (HashSet<Module>)this.moduleReadsField.get(module);
            if (reads == null) {
                reads = new HashSet<Module>(1);
                this.moduleReadsField.set(module, reads);
            }
            reads.add(other == null ? this.allUnnamedModule : other);
        }

        void addExports(Module module, String pn, Module other) throws IllegalAccessException {
            Set prev;
            if (other != null && module.isExported(pn, other)) {
                return;
            }
            HashMap<String, Set<Module>> exports = (HashMap<String, Set<Module>>)this.moduleExportedPackagesField.get(module);
            if (exports == null) {
                exports = new HashMap<String, Set<Module>>(1);
                this.moduleExportedPackagesField.set(module, exports);
            }
            if (other == null) {
                prev = exports.putIfAbsent(pn, this.allUnnamedModuleSet);
            } else {
                HashSet<Module> targets = new HashSet<Module>(1);
                targets.add(other);
                prev = exports.putIfAbsent(pn, targets);
            }
            if (prev != null) {
                prev.add((Module)(other == null ? this.allUnnamedModule : other));
            }
        }

        void addOpens(Module module, String pn, Module other) throws IllegalAccessException {
            Set prev;
            if (other != null && module.isOpen(pn, other)) {
                return;
            }
            HashMap<String, Set<Module>> opens = (HashMap<String, Set<Module>>)this.moduleOpenPackagesField.get(module);
            if (opens == null) {
                opens = new HashMap<String, Set<Module>>(1);
                this.moduleOpenPackagesField.set(module, opens);
            }
            if (other == null) {
                prev = opens.putIfAbsent(pn, this.allUnnamedModuleSet);
            } else {
                HashSet<Module> targets = new HashSet<Module>(1);
                targets.add(other);
                prev = opens.putIfAbsent(pn, targets);
            }
            if (prev != null) {
                prev.add((Module)(other == null ? this.allUnnamedModule : other));
            }
        }

        void patchModuleLayerField(Module module, ModuleLayer runtimeBootLayer) throws IllegalAccessException {
            this.moduleLayerField.set(module, runtimeBootLayer);
        }

        void patchModuleLoaderField(Module module, ClassLoader loader) throws IllegalAccessException {
            this.moduleLoaderField.set(module, loader);
        }

        ModuleLayer createNewModuleLayerInstance(Configuration cf) throws InvocationTargetException, InstantiationException, IllegalAccessException {
            return this.moduleLayerConstructor.newInstance(cf, List.of(), null);
        }

        void patchModuleLayerNameToModuleField(ModuleLayer moduleLayer, Map<String, Module> nameToModule) throws IllegalAccessException {
            this.moduleLayerNameToModuleField.set(moduleLayer, nameToModule);
        }

        void patchModuleLayerParentsField(ModuleLayer moduleLayer, List<ModuleLayer> parents) throws IllegalAccessException {
            this.moduleLayerParentsField.set(moduleLayer, parents);
        }

        ClassLoader getClassLoaderForBootLayerModule(String name) {
            Optional<Module> module = ModuleLayer.boot().findModule(name);
            assert (module.isPresent());
            return module.get().getClassLoader();
        }

        ClassLoader getClassLoaderForModuleInModuleLayer(ModuleLayer hostedModuleLayer, String name) {
            Optional<Module> module = hostedModuleLayer.findModule(name);
            return module.isPresent() ? module.get().getClassLoader() : this.imageClassLoader.getClassLoader();
        }

        Object invokeSystemModuleFinderAllSystemModules() {
            try {
                return this.systemModuleFindersAllSystemModulesMethod.invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw VMError.shouldNotReachHere("Failed to reflectively invoke SystemModuleFinders.allSystemModules().", e);
            }
        }

        ModuleFinder invokeSystemModuleFinderOf(Object systemModules) {
            try {
                return (ModuleFinder)this.systemModuleFindersOfMethod.invoke(null, systemModules);
            }
            catch (ReflectiveOperationException e) {
                throw VMError.shouldNotReachHere("Failed to reflectively invoke SystemModuleFinders.of().", e);
            }
        }

        Object invokeSystemModuleFinderSystemModules(String mainModule) {
            try {
                return this.systemModuleFindersSystemModulesMethod.invoke(null, mainModule);
            }
            catch (ReflectiveOperationException e) {
                throw VMError.shouldNotReachHere("Failed to reflectively invoke SystemModuleFinders.systemModules().", e);
            }
        }

        ModuleFinder invokeModuleBootstrapLimitFinder(ModuleFinder finder, Set<String> roots, Set<String> otherModules) {
            try {
                return (ModuleFinder)this.moduleBootstrapLimitFinderMethod.invoke(null, finder, roots, otherModules);
            }
            catch (ReflectiveOperationException e) {
                throw VMError.shouldNotReachHere("Failed to reflectively invoke ModuleBootstrap.limitFinder().", e);
            }
        }

        Set<String> invokeDefaultRootsComputeMethod(ModuleFinder finder1, ModuleFinder finder2) {
            try {
                return (Set)this.defaultRootsComputeMethod.invoke(null, finder1, finder2);
            }
            catch (ReflectiveOperationException e) {
                throw VMError.shouldNotReachHere("Failed to reflectively invoke DefaultRoots.compute().", e);
            }
        }
    }
}

