/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.thread.ThreadCpuTimeSupport;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.windows.headers.Process;
import com.oracle.svm.core.windows.headers.WinBase;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={ThreadCpuTimeSupport.class})
final class WindowsThreadCpuTimeSupport
implements ThreadCpuTimeSupport {
    WindowsThreadCpuTimeSupport() {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getCurrentThreadCpuTime(boolean includeSystemTime) {
        WinBase.HANDLE hThread = Process.NoTransitions.GetCurrentThread();
        return this.getThreadCpuTime((VMThreads.OSThreadHandle)((Object)hThread), includeSystemTime);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getThreadCpuTime(VMThreads.OSThreadHandle osThreadHandle, boolean includeSystemTime) {
        WinBase.FILETIME user;
        WinBase.FILETIME kernel;
        WinBase.FILETIME exit;
        WinBase.FILETIME create = (WinBase.FILETIME)StackValue.get(WinBase.FILETIME.class);
        if (!Process.NoTransitions.GetThreadTimes((WinBase.HANDLE)((Object)osThreadHandle), create, exit = (WinBase.FILETIME)StackValue.get(WinBase.FILETIME.class), kernel = (WinBase.FILETIME)StackValue.get(WinBase.FILETIME.class), user = (WinBase.FILETIME)StackValue.get(WinBase.FILETIME.class))) {
            return -1L;
        }
        UnsignedWord total = WordFactory.unsigned((int)user.dwHighDateTime()).shiftLeft(32).or(WordFactory.unsigned((int)user.dwLowDateTime()));
        if (includeSystemTime) {
            total.add(WordFactory.unsigned((int)kernel.dwHighDateTime()).shiftLeft(32).or(WordFactory.unsigned((int)kernel.dwLowDateTime())));
        }
        return total.multiply(100).rawValue();
    }
}

