/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.Parker;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.windows.headers.SynchAPI;
import com.oracle.svm.core.windows.headers.WinBase;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.WINDOWS.class})
class WindowsParker
extends Parker {
    private static final long MAX_DWORD = 0xFFFFFFFFL;
    private WinBase.HANDLE eventHandle = SynchAPI.CreateEventA(WordFactory.nullPointer(), 1, 0, WordFactory.nullPointer());

    WindowsParker() {
        VMError.guarantee(this.eventHandle.rawValue() != 0L, "CreateEventA failed");
    }

    @Override
    protected void reset() {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            int status = SynchAPI.ResetEvent(this.eventHandle);
            VMError.guarantee(status != 0, "ResetEvent failed");
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void park(boolean isAbsolute, long time) {
        long millis;
        assert (!(time < 0L || isAbsolute && time == 0L)) : "must not be called otherwise";
        if (time == 0L) {
            millis = (long)SynchAPI.INFINITE() & 0xFFFFFFFFL;
        } else if (isAbsolute) {
            millis = time - System.currentTimeMillis();
            if (millis <= 0L) {
                return;
            }
        } else {
            millis = TimeUtils.divideNanosToMillis(time);
            if (millis == 0L) {
                millis = 1L;
            }
        }
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            int status = SynchAPI.WaitForSingleObject(this.eventHandle, 0);
            if (status == SynchAPI.WAIT_OBJECT_0()) {
                SynchAPI.ResetEvent(this.eventHandle);
            } else {
                status = SynchAPI.WaitForSingleObject(this.eventHandle, WindowsParker.toDword(millis));
                SynchAPI.ResetEvent(this.eventHandle);
            }
            assert (status == SynchAPI.WAIT_OBJECT_0() || status == SynchAPI.WAIT_TIMEOUT());
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    private static int toDword(long value) {
        assert (value >= 0L);
        if (value > 0xFFFFFFFFL) {
            return -1;
        }
        return (int)value;
    }

    @Override
    protected void unpark() {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            int status = SynchAPI.SetEvent(this.eventHandle);
            VMError.guarantee(status != 0, "SetEvent failed");
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void release() {
        WinBase.CloseHandle(this.eventHandle);
        this.eventHandle = WinBase.INVALID_HANDLE_VALUE();
    }
}

