/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.IsolateListenerSupport;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CFunctionOptions;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.threadlocal.VMThreadLocalMTSupport;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.nodes.AssertionNode;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public abstract class VMThreads {
    protected static final VMMutex THREAD_MUTEX = new VMMutex("thread");
    protected static final VMCondition THREAD_LIST_CONDITION = new VMCondition(THREAD_MUTEX);
    private static IsolateThread head;
    private static final UninterruptibleUtils.AtomicWord<OSThreadHandle> detachedOsThreadToCleanup;
    public static final FastThreadLocalWord<IsolateThread> nextTL;
    private static final FastThreadLocalWord<OSThreadId> OSThreadIdTL;
    protected static final FastThreadLocalWord<OSThreadHandle> OSThreadHandleTL;
    public static final FastThreadLocalWord<Isolate> IsolateTL;
    public static final FastThreadLocalWord<UnsignedWord> StackBase;
    public static final FastThreadLocalWord<UnsignedWord> StackEnd;
    private static final FastThreadLocalBytes<Pointer> StartedByCurrentIsolate;
    private static final int STATE_UNINITIALIZED = 1;
    private static final int STATE_INITIALIZING = 2;
    private static final int STATE_INITIALIZED = 3;
    private static final int STATE_TEARING_DOWN = 4;
    private static final UninterruptibleUtils.AtomicInteger initializationState;
    private static final FastThreadLocalWord<Pointer> unalignedIsolateThreadMemoryTL;

    @Fold
    public static VMThreads singleton() {
        return (VMThreads)ImageSingletons.lookup(VMThreads.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code. Too early for safepoints.")
    public static boolean isInitialized() {
        return initializationState.get() >= 3;
    }

    @Uninterruptible(reason="Called from uninterruptible code during tear down.")
    public static boolean isTearingDown() {
        return initializationState.get() >= 4;
    }

    static void setTearingDown() {
        initializationState.set(4);
    }

    @Uninterruptible(reason="Called from uninterruptible code. Too early for safepoints.")
    public static boolean ensureInitialized() {
        boolean result = true;
        if (initializationState.compareAndSet(1, 2)) {
            result = VMThreads.singleton().initializeOnce();
            initializationState.set(3);
        } else {
            while (initializationState.get() < 3) {
            }
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code. Too early for safepoints.")
    protected abstract boolean initializeOnce();

    @Uninterruptible(reason="Thread state not set up.")
    public IsolateThread allocateIsolateThread(int isolateThreadSize) {
        UnsignedWord alignment = WordFactory.unsigned((int)64);
        UnsignedWord memorySize = WordFactory.unsigned((int)isolateThreadSize).add(alignment);
        Pointer memory = (Pointer)((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).calloc(memorySize);
        if (memory.isNull()) {
            return (IsolateThread)WordFactory.nullPointer();
        }
        IsolateThread isolateThread = (IsolateThread)UnsignedUtils.roundUp((UnsignedWord)memory, alignment);
        unalignedIsolateThreadMemoryTL.set(isolateThread, memory);
        return isolateThread;
    }

    @Uninterruptible(reason="Thread state not set up.")
    public void freeIsolateThread(IsolateThread thread) {
        Pointer memory = unalignedIsolateThreadMemoryTL.get(thread);
        ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)memory);
    }

    @Uninterruptible(reason="Unknown thread state.")
    public abstract void failFatally(int var1, CCharPointer var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static IsolateThread firstThread() {
        VMThreads.guaranteeOwnsThreadMutex("Threads mutex must be locked before accessing/iterating the thread list.");
        return VMThreads.firstThreadUnsafe();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static IsolateThread firstThreadUnsafe() {
        return head;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static IsolateThread nextThread(IsolateThread cur) {
        return nextTL.get(cur);
    }

    @Uninterruptible(reason="Thread is not attached yet.")
    public int attachThread(IsolateThread thread, boolean startedByCurrentIsolate) {
        StartedByCurrentIsolate.getAddress().writeByte(0, (byte)(startedByCurrentIsolate ? 1 : 0));
        return this.attachThread(thread);
    }

    @Uninterruptible(reason="Thread is not attached yet.")
    protected int attachThread(IsolateThread thread) {
        assert (StatusSupport.isStatusCreated(thread)) : "Status should be initialized on creation.";
        OSThreadIdTL.set(thread, this.getCurrentOSThreadId());
        OSThreadHandleTL.set(thread, this.getCurrentOSThreadHandle());
        assert (!ThreadingSupportImpl.isRecurringCallbackRegistered(thread));
        Safepoint.setSafepointRequested(thread, Integer.MAX_VALUE);
        THREAD_MUTEX.lockNoTransition();
        try {
            nextTL.set(thread, head);
            head = thread;
            Heap.getHeap().attachThread(CurrentIsolate.getCurrentThread());
            ActionOnTransitionToJavaSupport.setSynchronizeCode(thread);
            StatusSupport.setStatusNative(thread);
            THREAD_LIST_CONDITION.broadcast();
        }
        finally {
            THREAD_MUTEX.unlock();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Manipulates the threads list; broadcasts on changes.")
    public void detachThread(IsolateThread thread) {
        OSThreadHandle threadToCleanup;
        assert (thread.equal((ComparableWord)CurrentIsolate.getCurrentThread())) : "Cannot detach different thread with this method";
        OSThreadHandle nextOsThreadToCleanup = (OSThreadHandle)WordFactory.nullPointer();
        if (VMThreads.wasStartedByCurrentIsolate(thread)) {
            nextOsThreadToCleanup = OSThreadHandleTL.get(thread);
        }
        VMThreads.threadExit(thread);
        PlatformThreads.afterThreadExit(thread);
        VMThreads.lockThreadMutexInNativeCode();
        try {
            VMThreads.detachThreadInSafeContext(thread);
            threadToCleanup = detachedOsThreadToCleanup.getAndSet(nextOsThreadToCleanup);
            VMThreads.releaseThread(thread);
        }
        finally {
            THREAD_MUTEX.unlock();
        }
        this.cleanupExitedOsThread(threadToCleanup);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean wasStartedByCurrentIsolate(IsolateThread thread) {
        return StartedByCurrentIsolate.getAddress(thread).readByte(0) != 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    @NeverInline(value="Must not be inlined in a caller that has an exception handler: We only support InvokeNode and not InvokeWithExceptionNode between a CFunctionPrologueNode and CFunctionEpilogueNode.")
    static void lockThreadMutexInNativeCode() {
        CFunctionPrologueNode.cFunctionPrologue(3);
        VMThreads.lockThreadMutexInNativeCode0();
        CFunctionEpilogueNode.cFunctionEpilogue(3);
    }

    @Uninterruptible(reason="Must not stop while in native.")
    @NeverInline(value="Provide a return address for the Java frame anchor.")
    private static void lockThreadMutexInNativeCode0() {
        THREAD_MUTEX.lockNoTransition();
    }

    @Uninterruptible(reason="Thread is detaching and holds the THREAD_MUTEX.")
    private static void releaseThread(IsolateThread thread) {
        THREAD_MUTEX.guaranteeIsOwner("This mutex must be locked to prevent that a GC is triggered while detaching a thread from the heap");
        Heap.getHeap().detachThread(thread);
        VMThreads.singleton().freeIsolateThread(thread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void cleanupExitedOsThreads() {
        OSThreadHandle threadToCleanup = detachedOsThreadToCleanup.getAndSet((OSThreadHandle)WordFactory.nullPointer());
        this.cleanupExitedOsThread(threadToCleanup);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void cleanupExitedOsThread(OSThreadHandle threadToCleanup) {
        if (threadToCleanup.isNonNull()) {
            this.joinNoTransition(threadToCleanup);
        }
    }

    @Uninterruptible(reason="Thread is detaching and holds the THREAD_MUTEX.")
    private static void detachThreadInSafeContext(IsolateThread thread) {
        PlatformThreads.detachThread(thread);
        VMThreads.removeFromThreadList(thread);
        THREAD_LIST_CONDITION.broadcast();
    }

    @Uninterruptible(reason="Thread is detaching and holds the THREAD_MUTEX.")
    private static void removeFromThreadList(IsolateThread thread) {
        IsolateThread previous = (IsolateThread)WordFactory.nullPointer();
        IsolateThread current = head;
        while (current.isNonNull()) {
            IsolateThread next = nextTL.get(current);
            if (current == thread) {
                if (previous.isNull()) {
                    head = next;
                } else {
                    nextTL.set(previous, next);
                }
                nextTL.set(thread, thread);
                break;
            }
            previous = current;
            current = next;
        }
    }

    @Uninterruptible(reason="Only uninterruptible code may be executed after VMThreads#threadExit.")
    public void tearDown() {
        ThreadingSupportImpl.pauseRecurringCallback("Execution of arbitrary code is prohibited during the last teardown steps.");
        IsolateThread curThread = CurrentIsolate.getCurrentThread();
        VMThreads.threadExit(curThread);
        PlatformThreads.afterThreadExit(curThread);
        if (VMOperationControl.useDedicatedVMOperationThread()) {
            VMOperationControl.shutdownAndDetachVMOperationThread();
        }
        IsolateListenerSupport.singleton().onIsolateTeardown();
        this.waitUntilLastOsThreadExited();
    }

    @Uninterruptible(reason="Only uninterruptible code may be executed after VMThreads#threadExit.")
    private void waitUntilLastOsThreadExited() {
        this.cleanupExitedOsThreads();
    }

    @Uninterruptible(reason="Called from uninterruptible code, but still safe at this point.", calleeMustBe=false)
    private static void threadExit(IsolateThread thread) {
        VMError.guarantee(thread.equal((ComparableWord)CurrentIsolate.getCurrentThread()), "Cleanup must execute in detaching thread");
        Thread javaThread = PlatformThreads.currentThread.get(thread);
        if (javaThread != null) {
            PlatformThreads.exit(javaThread);
        }
    }

    public static void detachAllThreadsExceptCurrentWithoutCleanupForTearDown() {
        DetachAllExternallyStartedThreadsExceptCurrentOperation vmOp = new DetachAllExternallyStartedThreadsExceptCurrentOperation();
        vmOp.enqueue();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract void joinNoTransition(OSThreadHandle var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract OSThreadHandle getCurrentOSThreadHandle();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract OSThreadId getCurrentOSThreadId();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void nativeSleep(int milliseconds) {
        throw VMError.shouldNotReachHere();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void yield() {
        throw VMError.shouldNotReachHere();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean supportsNativeYieldAndSleep() {
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean verifyThreadIsAttached(IsolateThread thread) {
        return VMThreads.nextThread(thread) != thread;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean verifyIsCurrentThread(IsolateThread thread) {
        OSThreadId osThreadId = this.getCurrentOSThreadId();
        return OSThreadIdTL.get(thread).equal((ComparableWord)osThreadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public IsolateThread findIsolateThreadForCurrentOSThread(boolean inCrashHandler) {
        boolean needsLock;
        OSThreadId osThreadId = this.getCurrentOSThreadId();
        boolean bl = needsLock = !inCrashHandler;
        if (needsLock) {
            THREAD_MUTEX.lockNoTransitionUnspecifiedOwner();
        }
        try {
            IsolateThread thread = VMThreads.firstThreadUnsafe();
            while (thread.isNonNull() && OSThreadIdTL.get(thread).notEqual((ComparableWord)osThreadId)) {
                thread = VMThreads.nextThread(thread);
            }
            IsolateThread isolateThread = thread;
            return isolateThread;
        }
        finally {
            if (needsLock) {
                THREAD_MUTEX.unlockNoTransitionUnspecifiedOwner();
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static OSThreadHandle findOSThreadHandleForIsolateThread(IsolateThread isolateThread) {
        return OSThreadHandleTL.get(isolateThread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void guaranteeOwnsThreadMutex(String message) {
        THREAD_MUTEX.guaranteeIsOwner(message);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean ownsThreadMutex() {
        return THREAD_MUTEX.isOwner();
    }

    public static boolean printLocationInfo(Log log, UnsignedWord value, boolean allowUnsafeOperations) {
        IsolateThread thread = VMThreads.firstThreadUnsafe();
        while (thread.isNonNull()) {
            if (thread.equal((ComparableWord)value)) {
                log.string("is a thread");
                return true;
            }
            if (allowUnsafeOperations || VMOperation.isInProgressAtSafepoint()) {
                UnsignedWord stackBase = StackBase.get(thread);
                UnsignedWord stackEnd = StackEnd.get(thread);
                if (value.belowThan(stackBase) && value.aboveOrEqual(stackEnd)) {
                    log.string("points into the stack for thread ").zhex((WordBase)thread);
                    return true;
                }
            }
            if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                int sizeOfThreadLocals = ((VMThreadLocalMTSupport)ImageSingletons.lookup(VMThreadLocalMTSupport.class)).vmThreadSize;
                UnsignedWord endOfThreadLocals = ((UnsignedWord)thread).add(sizeOfThreadLocals);
                if (value.aboveOrEqual((UnsignedWord)thread) && value.belowThan(endOfThreadLocals)) {
                    log.string("points into the thread locals for thread ").zhex((WordBase)thread);
                    return true;
                }
            }
            thread = VMThreads.nextThread(thread);
        }
        return false;
    }

    static {
        detachedOsThreadToCleanup = new UninterruptibleUtils.AtomicWord();
        nextTL = FastThreadLocalFactory.createWord("VMThreads.nextTL");
        OSThreadIdTL = FastThreadLocalFactory.createWord("VMThreads.OSThreadIdTL");
        OSThreadHandleTL = FastThreadLocalFactory.createWord("VMThreads.OSThreadHandleTL");
        IsolateTL = FastThreadLocalFactory.createWord("VMThreads.IsolateTL");
        StackBase = FastThreadLocalFactory.createWord("VMThreads.StackBase");
        StackEnd = FastThreadLocalFactory.createWord("VMThreads.StackEnd");
        StartedByCurrentIsolate = FastThreadLocalFactory.createBytes(() -> 1, "VMThreads.StartedByCurrentIsolate");
        initializationState = new UninterruptibleUtils.AtomicInteger(1);
        unalignedIsolateThreadMemoryTL = FastThreadLocalFactory.createWord("VMThreads.unalignedIsolateThreadMemoryTL");
    }

    public static class StatusSupport {
        public static final FastThreadLocalInt statusTL = (FastThreadLocalInt)FastThreadLocalFactory.createInt("StatusSupport.statusTL").setMaxOffset(63);
        public static final int STATUS_ILLEGAL = -1;
        public static final int STATUS_CREATED = 0;
        public static final int STATUS_IN_JAVA = 1;
        public static final int STATUS_IN_SAFEPOINT = 2;
        public static final int STATUS_IN_NATIVE = 3;
        public static final int STATUS_IN_VM = 4;
        private static final int MAX_STATUS = 4;

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static String statusToString(int status) {
            switch (status) {
                case 0: {
                    return "STATUS_CREATED";
                }
                case 1: {
                    return "STATUS_IN_JAVA";
                }
                case 2: {
                    return "STATUS_IN_SAFEPOINT";
                }
                case 3: {
                    return "STATUS_IN_NATIVE";
                }
                case 4: {
                    return "STATUS_IN_VM";
                }
            }
            return "STATUS error";
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static String getStatusString(IsolateThread vmThread) {
            return StatusSupport.statusToString(statusTL.getVolatile(vmThread));
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int getStatusVolatile(IsolateThread vmThread) {
            return statusTL.getVolatile(vmThread);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int getStatusVolatile() {
            return statusTL.getVolatile();
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void setStatusNative() {
            statusTL.setVolatile(3);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void setStatusNative(IsolateThread vmThread) {
            statusTL.setVolatile(vmThread, 3);
        }

        public static boolean compareAndSetNativeToSafepoint(IsolateThread vmThread) {
            return statusTL.compareAndSet(vmThread, 3, 2);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void setStatusJavaUnguarded() {
            statusTL.setVolatile(1);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void setStatusVM() {
            statusTL.setVolatile(4);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean compareAndSetNativeToNewStatus(int newStatus) {
            return statusTL.compareAndSet(3, newStatus);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isStatusCreated(IsolateThread vmThread) {
            return statusTL.getVolatile(vmThread) == 0;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isStatusNativeOrSafepoint(IsolateThread vmThread) {
            int status = statusTL.getVolatile(vmThread);
            return status == 3 || status == 2;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isStatusNativeOrSafepoint() {
            int status = statusTL.getVolatile();
            return status == 3 || status == 2;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isStatusVM() {
            return statusTL.getVolatile() == 4;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isStatusJava() {
            return statusTL.getVolatile() == 1;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void assertStatusJava() {
            String msg = "Thread status must be 'Java'.";
            if (GraalDirectives.inIntrinsic()) {
                if (ReplacementsUtil.REPLACEMENTS_ASSERTIONS_ENABLED) {
                    AssertionNode.dynamicAssert((boolean)StatusSupport.isStatusJava(), (String)msg);
                }
            } else assert (StatusSupport.isStatusJava()) : msg;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void assertStatusNativeOrSafepoint() {
            String msg = "Thread status must be 'native' or 'safepoint'.";
            if (GraalDirectives.inIntrinsic()) {
                if (ReplacementsUtil.REPLACEMENTS_ASSERTIONS_ENABLED) {
                    AssertionNode.dynamicAssert((boolean)StatusSupport.isStatusNativeOrSafepoint(), (String)msg);
                }
            } else assert (StatusSupport.isStatusNativeOrSafepoint()) : msg;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void assertStatusVM() {
            String msg = "Thread status must be 'VM'.";
            if (GraalDirectives.inIntrinsic()) {
                if (ReplacementsUtil.REPLACEMENTS_ASSERTIONS_ENABLED) {
                    AssertionNode.dynamicAssert((boolean)StatusSupport.isStatusVM(), (String)msg);
                }
            } else assert (StatusSupport.isStatusVM()) : msg;
        }

        public static boolean isValidStatus(int status) {
            return status > -1 && status <= 4;
        }

        public static int getNewThreadStatus(CFunction.Transition transition) {
            switch (transition) {
                case NO_TRANSITION: {
                    return -1;
                }
                case TO_NATIVE: {
                    return 3;
                }
            }
            throw VMError.shouldNotReachHere("Unknown transition type " + String.valueOf(transition));
        }

        public static int getNewThreadStatus(CFunctionOptions.Transition transition) {
            switch (transition) {
                case TO_VM: {
                    return 4;
                }
            }
            throw VMError.shouldNotReachHere("Unknown transition type " + String.valueOf((Object)transition));
        }
    }

    public static interface OSThreadId
    extends PointerBase {
    }

    public static interface OSThreadHandle
    extends PointerBase {
    }

    public static class ActionOnTransitionToJavaSupport {
        private static final FastThreadLocalInt actionTL = FastThreadLocalFactory.createInt("ActionOnTransitionToJavaSupport.actionTL");
        private static final int NO_ACTION = 0;
        private static final int SYNCHRONIZE_CODE = 1;

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isActionPending() {
            return actionTL.getVolatile() != 0;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isSynchronizeCode() {
            return actionTL.getVolatile() == 1;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void clearActions() {
            actionTL.setVolatile(0);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void setSynchronizeCode(IsolateThread vmThread) {
            assert (StatusSupport.isStatusCreated(vmThread) || VMOperation.isInProgressAtSafepoint()) : "Invariant to avoid races between setting and clearing.";
            actionTL.setVolatile(vmThread, 1);
        }

        public static void requestAllThreadsSynchronizeCode() {
            IsolateThread myself = CurrentIsolate.getCurrentThread();
            IsolateThread vmThread = VMThreads.firstThread();
            while (vmThread.isNonNull()) {
                if (myself != vmThread) {
                    ActionOnTransitionToJavaSupport.setSynchronizeCode(vmThread);
                }
                vmThread = VMThreads.nextThread(vmThread);
            }
        }
    }

    private static class DetachAllExternallyStartedThreadsExceptCurrentOperation
    extends JavaVMOperation {
        DetachAllExternallyStartedThreadsExceptCurrentOperation() {
            super(VMOperationInfos.get(DetachAllExternallyStartedThreadsExceptCurrentOperation.class, "Detach all externally started threads except current", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        protected void operate() {
            IsolateThread currentThread = CurrentIsolate.getCurrentThread();
            IsolateThread thread = VMThreads.firstThread();
            while (thread.isNonNull()) {
                IsolateThread next = VMThreads.nextThread(thread);
                if (thread.notEqual((ComparableWord)currentThread) && !VMThreads.wasStartedByCurrentIsolate(thread)) {
                    VMThreads.detachThreadInSafeContext(thread);
                    VMThreads.releaseThread(thread);
                }
                thread = next;
            }
        }
    }

    public static class ActionOnExitSafepointSupport {
        private static final FastThreadLocalInt actionTL = FastThreadLocalFactory.createInt("ActionOnExitSafepointSupport.actionTL");
        private static final int NO_ACTION = 0;
        private static final int SWITCH_STACK = 1;
        private static final FastThreadLocalWord<Pointer> returnSP = FastThreadLocalFactory.createWord("ActionOnExitSafepointSupport.returnSP");
        private static final FastThreadLocalWord<CodePointer> returnIP = FastThreadLocalFactory.createWord("ActionOnExitSafepointSupport.returnIP");

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isActionPending() {
            return actionTL.getVolatile() != 0;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isSwitchStackPending() {
            return actionTL.getVolatile() == 1;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void setSwitchStack(IsolateThread vmThread) {
            assert (VMOperation.isInProgressAtSafepoint()) : "Invariant to avoid races between setting and clearing.";
            actionTL.setVolatile(vmThread, 1);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void setSwitchStackTarget(IsolateThread vmThread, Pointer sp, CodePointer ip) {
            returnSP.setVolatile(vmThread, sp);
            returnIP.setVolatile(vmThread, ip);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected static Pointer getSwitchStackSP() {
            Pointer sp = returnSP.getVolatile();
            assert (sp.isNonNull());
            return sp;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected static CodePointer getSwitchStackIP() {
            CodePointer ip = returnIP.getVolatile();
            assert (ip.isNonNull());
            return ip;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void clearActions() {
            actionTL.setVolatile(0);
        }
    }

    public static class SafepointBehavior {
        private static final FastThreadLocalInt safepointBehaviorTL = FastThreadLocalFactory.createInt("StatusSupport.safepointBehaviorTL");
        public static final int ALLOW_SAFEPOINT = 0;
        static final int PREVENT_VM_FROM_REACHING_SAFEPOINT = 1;
        static final int THREAD_CRASHED = 2;

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean ignoresSafepoints() {
            return safepointBehaviorTL.getVolatile() != 0;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean ignoresSafepoints(IsolateThread vmThread) {
            return safepointBehaviorTL.getVolatile(vmThread) != 0;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int getSafepointBehaviorVolatile(IsolateThread vmThread) {
            return safepointBehaviorTL.getVolatile(vmThread);
        }

        @Uninterruptible(reason="May only be called from uninterruptible code to prevent races with the safepoint handling.", callerMustBe=true)
        public static void preventSafepoints() {
            safepointBehaviorTL.setVolatile(1);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void markThreadAsCrashed() {
            safepointBehaviorTL.setVolatile(2);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static String toString(int safepointBehavior) {
            switch (safepointBehavior) {
                case 0: {
                    return "ALLOW_SAFEPOINT";
                }
                case 1: {
                    return "PREVENT_VM_FROM_REACHING_SAFEPOINT";
                }
                case 2: {
                    return "THREAD_CRASHED";
                }
            }
            return "Invalid safepoint behavior";
        }
    }
}

