/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.sampler.SamplerSampleWriter;
import com.oracle.svm.core.sampler.SamplerSampleWriterData;
import com.oracle.svm.core.stack.ParameterizedStackFrameVisitor;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

public final class SamplerStackWalkVisitor
extends ParameterizedStackFrameVisitor {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SamplerStackWalkVisitor() {
    }

    @Override
    @Uninterruptible(reason="The method executes during signal handling.", callerMustBe=true)
    protected boolean visitFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame, Object data) {
        return SamplerStackWalkVisitor.recordIp(ip);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean shouldContinueWalk(SamplerSampleWriterData data) {
        int numFrames = data.getNumFrames() - data.getSkipCount();
        if (numFrames > data.getMaxDepth()) {
            data.setTruncated(true);
            return false;
        }
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean shouldSkipFrame(SamplerSampleWriterData data) {
        data.setNumFrames(data.getNumFrames() + 1);
        return data.getNumFrames() <= data.getSkipCount();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int computeHash(int oldHash, long ip) {
        int hash = (int)(ip ^ ip >>> 32);
        return 31 * oldHash + hash;
    }

    @Override
    @Uninterruptible(reason="The method executes during signal handling.", callerMustBe=true)
    protected boolean unknownFrame(Pointer sp, CodePointer ip, DeoptimizedFrame deoptimizedFrame, Object data) {
        JfrThreadLocal.increaseUnparseableStacks();
        return false;
    }

    @Uninterruptible(reason="The method executes during signal handling.", callerMustBe=true)
    private static boolean recordIp(CodePointer ip) {
        SamplerSampleWriterData writerData = JfrThreadLocal.getSamplerWriterData();
        assert (writerData.isNonNull());
        boolean shouldSkipFrame = SamplerStackWalkVisitor.shouldSkipFrame(writerData);
        boolean shouldContinueWalk = SamplerStackWalkVisitor.shouldContinueWalk(writerData);
        if (!shouldSkipFrame && shouldContinueWalk) {
            writerData.setHashCode(SamplerStackWalkVisitor.computeHash(writerData.getHashCode(), ip.rawValue()));
            shouldContinueWalk = SamplerSampleWriter.putLong(writerData, ip.rawValue());
        }
        return shouldContinueWalk;
    }
}

