/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.headers.LibC;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={UnmanagedMemorySupport.class})
class UnmanagedMemorySupportImpl
implements UnmanagedMemorySupport {
    UnmanagedMemorySupportImpl() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T malloc(UnsignedWord size) {
        return LibC.malloc(size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T calloc(UnsignedWord size) {
        return LibC.calloc(WordFactory.unsigned((int)1), size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T realloc(T ptr, UnsignedWord size) {
        return LibC.realloc(ptr, size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void free(PointerBase ptr) {
        LibC.free(ptr);
    }
}

