/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni.functions;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import com.oracle.svm.core.jdk.Target_java_nio_DirectByteBuffer;
import com.oracle.svm.core.jni.JNIObjectHandles;
import com.oracle.svm.core.jni.JNIThreadLocalPendingException;
import com.oracle.svm.core.jni.JNIThreadLocalPinnedObjects;
import com.oracle.svm.core.jni.JNIThreadOwnedMonitors;
import com.oracle.svm.core.jni.access.JNIAccessibleMethod;
import com.oracle.svm.core.jni.access.JNIAccessibleMethodDescriptor;
import com.oracle.svm.core.jni.access.JNINativeLinkage;
import com.oracle.svm.core.jni.access.JNIReflectionDictionary;
import com.oracle.svm.core.jni.functions.JNIFunctionTables;
import com.oracle.svm.core.jni.headers.JNIEnvironment;
import com.oracle.svm.core.jni.headers.JNIErrors;
import com.oracle.svm.core.jni.headers.JNIFieldId;
import com.oracle.svm.core.jni.headers.JNIJavaVM;
import com.oracle.svm.core.jni.headers.JNIJavaVMPointer;
import com.oracle.svm.core.jni.headers.JNIMethodId;
import com.oracle.svm.core.jni.headers.JNINativeMethod;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import com.oracle.svm.core.jni.headers.JNIObjectRefType;
import com.oracle.svm.core.jni.headers.JNIValue;
import com.oracle.svm.core.jni.headers.JNIVersion;
import com.oracle.svm.core.jni.headers.JNIVersionJDK19OrLater;
import com.oracle.svm.core.jni.headers.JNIVersionJDK20OrLater;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.monitor.MonitorInflationCause;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.thread.VirtualThreads;
import com.oracle.svm.core.util.Utf8;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CShortPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;
import sun.nio.ch.DirectBuffer;

public final class JNIFunctions {
    static final CGlobalData<CCharPointer> UNIMPLEMENTED_UNATTACHED_ERROR_MESSAGE = CGlobalDataFactory.createCString("An unimplemented JNI function was called in a way or at a time when no error reporting could be performed.");

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @Uninterruptible(reason="No need to enter the isolate and also no way to report errors if unable to.")
    static int GetVersion(JNIEnvironment env) {
        return JavaVersionUtil.JAVA_SPEC >= 20 ? JNIVersionJDK20OrLater.JNI_VERSION_20() : (JavaVersionUtil.JAVA_SPEC >= 19 ? JNIVersionJDK19OrLater.JNI_VERSION_19() : JNIVersion.JNI_VERSION_10());
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle NewLocalRef(JNIEnvironment env, JNIObjectHandle ref) {
        return JNIObjectHandles.newLocalRef(ref);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerVoid.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterFatalOnFailurePrologue.class)
    static void DeleteLocalRef(JNIEnvironment env, JNIObjectHandle localRef) {
        JNIObjectHandles.deleteLocalRef(localRef);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnJniErr.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnEDetached.class)
    static int EnsureLocalCapacity(JNIEnvironment env, int capacity) {
        if (capacity < 0) {
            return JNIErrors.JNI_ERR();
        }
        JNIObjectHandles.ensureLocalCapacity(capacity);
        return 0;
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnJniErr.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnEDetached.class)
    static int PushLocalFrame(JNIEnvironment env, int capacity) {
        if (capacity < 0) {
            return JNIErrors.JNI_ERR();
        }
        JNIObjectHandles.pushLocalFrame(capacity);
        return 0;
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle PopLocalFrame(JNIEnvironment env, JNIObjectHandle handle) {
        Object obj = JNIObjectHandles.getObject(handle);
        JNIObjectHandles.popLocalFrame();
        return JNIObjectHandles.createLocal(obj);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnFalse.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterFatalOnFailurePrologue.class)
    static boolean IsSameObject(JNIEnvironment env, JNIObjectHandle ref1, JNIObjectHandle ref2) {
        Object obj2;
        Object obj1 = JNIObjectHandles.getObject(ref1);
        return obj1 == (obj2 = JNIObjectHandles.getObject(ref2));
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnFalse.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterFatalOnFailurePrologue.class)
    static boolean IsInstanceOf(JNIEnvironment env, JNIObjectHandle obj, JNIObjectHandle clazz) {
        Object o = JNIObjectHandles.getObject(obj);
        if (o == null) {
            return true;
        }
        Class c = (Class)JNIObjectHandles.getObject(clazz);
        return c.isInstance(o);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle GetObjectClass(JNIEnvironment env, JNIObjectHandle handle) {
        Object obj = JNIObjectHandles.getObject(handle);
        Class<?> clazz = obj.getClass();
        return JNIObjectHandles.createLocal(clazz);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle GetSuperclass(JNIEnvironment env, JNIObjectHandle handle) {
        Class clazz = (Class)JNIObjectHandles.getObject(handle);
        return JNIObjectHandles.createLocal(clazz.getSuperclass());
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnFalse.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterFatalOnFailurePrologue.class)
    static boolean IsAssignableFrom(JNIEnvironment env, JNIObjectHandle handle1, JNIObjectHandle handle2) {
        Class clazz1 = (Class)JNIObjectHandles.getObject(handle1);
        Class clazz2 = (Class)JNIObjectHandles.getObject(handle2);
        return clazz2.isAssignableFrom(clazz1);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterFatalOnFailurePrologue.class)
    static JNIObjectHandle NewGlobalRef(JNIEnvironment env, JNIObjectHandle handle) {
        return JNIObjectHandles.newGlobalRef(handle);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerVoid.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterFatalOnFailurePrologue.class)
    static void DeleteGlobalRef(JNIEnvironment env, JNIObjectHandle globalRef) {
        JNIObjectHandles.deleteGlobalRef(globalRef);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle NewWeakGlobalRef(JNIEnvironment env, JNIObjectHandle handle) {
        return JNIObjectHandles.newWeakGlobalRef(handle);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerVoid.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterFatalOnFailurePrologue.class)
    static void DeleteWeakGlobalRef(JNIEnvironment env, JNIObjectHandle weak) {
        JNIObjectHandles.deleteWeakGlobalRef(weak);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterFatalOnFailurePrologue.class)
    static JNIObjectRefType GetObjectRefType(JNIEnvironment env, JNIObjectHandle handle) {
        try {
            return JNIObjectHandles.getHandleType(handle);
        }
        catch (Throwable t) {
            return JNIObjectRefType.Invalid;
        }
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle FindClass(JNIEnvironment env, CCharPointer cname) {
        CharSequence name = Utf8.wrapUtf8CString(cname);
        Class<?> clazz = JNIReflectionDictionary.singleton().getClassObjectByName(name);
        if (clazz == null) {
            throw new NoClassDefFoundError(name.toString());
        }
        DynamicHub.fromClass(clazz).ensureInitialized();
        return JNIObjectHandles.createLocal(clazz);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnJniErr.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnEDetached.class)
    static int RegisterNatives(JNIEnvironment env, JNIObjectHandle hclazz, JNINativeMethod methods, int nmethods) {
        Class clazz = (Class)JNIObjectHandles.getObject(hclazz);
        Pointer p = (Pointer)methods;
        for (int i = 0; i < nmethods; ++i) {
            JNINativeMethod entry = (JNINativeMethod)p;
            CharSequence name = Utf8.wrapUtf8CString(entry.name());
            CharSequence signature = Utf8.wrapUtf8CString(entry.signature());
            CFunctionPointer fnPtr = entry.fnPtr();
            String declaringClass = MetaUtil.toInternalName((String)clazz.getName());
            JNINativeLinkage linkage = JNIReflectionDictionary.singleton().getLinkage(declaringClass, name, signature);
            if (linkage != null) {
                linkage.setEntryPoint(fnPtr);
            }
            p = p.add(SizeOf.get(JNINativeMethod.class));
        }
        return JNIErrors.JNI_OK();
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnJniErr.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnEDetached.class)
    static int UnregisterNatives(JNIEnvironment env, JNIObjectHandle hclazz) {
        Class clazz = (Class)JNIObjectHandles.getObject(hclazz);
        String internalName = MetaUtil.toInternalName((String)clazz.getName());
        JNIReflectionDictionary.singleton().unsetEntryPoints(internalName);
        return JNIErrors.JNI_OK();
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullWord.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=CEntryPointOptions.ReturnNullPointer.class)
    static JNIMethodId GetMethodID(JNIEnvironment env, JNIObjectHandle hclazz, CCharPointer cname, CCharPointer csig) {
        return Support.getMethodID(hclazz, cname, csig, false);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullWord.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=CEntryPointOptions.ReturnNullPointer.class)
    static JNIMethodId GetStaticMethodID(JNIEnvironment env, JNIObjectHandle hclazz, CCharPointer cname, CCharPointer csig) {
        return Support.getMethodID(hclazz, cname, csig, true);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullWord.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=CEntryPointOptions.ReturnNullPointer.class)
    static JNIFieldId GetFieldID(JNIEnvironment env, JNIObjectHandle hclazz, CCharPointer cname, CCharPointer csig) {
        return Support.getFieldID(hclazz, cname, csig, false);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullWord.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=CEntryPointOptions.ReturnNullPointer.class)
    static JNIFieldId GetStaticFieldID(JNIEnvironment env, JNIObjectHandle hclazz, CCharPointer cname, CCharPointer csig) {
        return Support.getFieldID(hclazz, cname, csig, true);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle AllocObject(JNIEnvironment env, JNIObjectHandle classHandle) throws InstantiationException {
        Class clazz = (Class)JNIObjectHandles.getObject(classHandle);
        Object instance = Unsafe.getUnsafe().allocateInstance(clazz);
        return JNIObjectHandles.createLocal(instance);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle NewString(JNIEnvironment env, CShortPointer unicode, int len) {
        char[] chars = new char[len];
        for (int i = 0; i < chars.length; ++i) {
            int value = Short.toUnsignedInt(unicode.read(i));
            chars[i] = (char)value;
        }
        String str = new String(chars);
        return JNIObjectHandles.createLocal(str);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle NewStringUTF(JNIEnvironment env, CCharPointer bytes) {
        return JNIObjectHandles.createLocal(Utf8.utf8ToString(bytes));
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnMinusOne.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnMinusOne.class)
    static int GetStringLength(JNIEnvironment env, JNIObjectHandle hstr) {
        String str = (String)JNIObjectHandles.getObject(hstr);
        return str != null ? str.length() : 0;
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnMinusOne.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnMinusOne.class)
    static int GetStringUTFLength(JNIEnvironment env, JNIObjectHandle hstr) {
        String str = (String)JNIObjectHandles.getObject(hstr);
        return Utf8.utf8Length(str);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullWord.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=CEntryPointOptions.ReturnNullPointer.class)
    static CShortPointer GetStringChars(JNIEnvironment env, JNIObjectHandle hstr, CCharPointer isCopy) {
        return Support.getNulTerminatedStringCharsAndPin(hstr, isCopy);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerVoid.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterFatalOnFailurePrologue.class)
    static void ReleaseStringChars(JNIEnvironment env, JNIObjectHandle hstr, CShortPointer chars) {
        Support.unpinString(chars);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullWord.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=CEntryPointOptions.ReturnNullPointer.class)
    static CCharPointer GetStringUTFChars(JNIEnvironment env, JNIObjectHandle hstr, CCharPointer isCopy) {
        String str = (String)JNIObjectHandles.getObject(hstr);
        if (str == null) {
            return (CCharPointer)WordFactory.nullPointer();
        }
        if (isCopy.isNonNull()) {
            isCopy.write((byte)1);
        }
        byte[] utf = Utf8.stringToUtf8(str, true);
        return (CCharPointer)JNIThreadLocalPinnedObjects.pinArrayAndGetAddress(utf);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerVoid.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterFatalOnFailurePrologue.class)
    static void ReleaseStringUTFChars(JNIEnvironment env, JNIObjectHandle hstr, CCharPointer chars) {
        JNIThreadLocalPinnedObjects.unpinArrayByAddress((PointerBase)chars);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullWord.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=CEntryPointOptions.ReturnNullPointer.class)
    static CShortPointer GetStringCritical(JNIEnvironment env, JNIObjectHandle hstr, CCharPointer isCopy) {
        return Support.getNulTerminatedStringCharsAndPin(hstr, isCopy);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerVoid.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterFatalOnFailurePrologue.class)
    static void ReleaseStringCritical(JNIEnvironment env, JNIObjectHandle hstr, CShortPointer carray) {
        Support.unpinString(carray);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerVoid.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterFatalOnFailurePrologue.class)
    static void GetStringRegion(JNIEnvironment env, JNIObjectHandle hstr, int start, int len, CShortPointer buf) {
        String str = (String)JNIObjectHandles.getObject(hstr);
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (start + len > str.length()) {
            throw new StringIndexOutOfBoundsException(start + len);
        }
        if (len < 0) {
            throw new StringIndexOutOfBoundsException(len);
        }
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(start + i);
            buf.write(i, (short)c);
        }
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerVoid.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterFatalOnFailurePrologue.class)
    static void GetStringUTFRegion(JNIEnvironment env, JNIObjectHandle hstr, int start, int len, CCharPointer buf) {
        String str = (String)JNIObjectHandles.getObject(hstr);
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (start + len > str.length()) {
            throw new StringIndexOutOfBoundsException(start + len);
        }
        if (len < 0) {
            throw new StringIndexOutOfBoundsException(len);
        }
        int capacity = Utf8.maxUtf8ByteLength(len, true);
        ByteBuffer buffer = CTypeConversion.asByteBuffer((PointerBase)buf, (int)capacity);
        Utf8.substringToUtf8(buffer, str, start, start + len, true);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle NewDirectByteBuffer(JNIEnvironment env, WordPointer address, long capacity) {
        Target_java_nio_DirectByteBuffer bb = new Target_java_nio_DirectByteBuffer(address.rawValue(), (int)capacity);
        return JNIObjectHandles.createLocal(bb);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullWord.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=CEntryPointOptions.ReturnNullPointer.class)
    static WordPointer GetDirectBufferAddress(JNIEnvironment env, JNIObjectHandle handle) {
        Target_java_nio_Buffer buf = Support.directBufferFromJNIHandle(handle);
        return buf == null ? (WordPointer)WordFactory.nullPointer() : (WordPointer)WordFactory.pointer((long)buf.address);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnMinusOne.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnMinusOneLong.class)
    static long GetDirectBufferCapacity(JNIEnvironment env, JNIObjectHandle handle) {
        Target_java_nio_Buffer buf = Support.directBufferFromJNIHandle(handle);
        return buf == null ? -1L : (long)buf.capacity;
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle NewBooleanArray(JNIEnvironment env, int length) {
        if (length < 0) {
            return (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        return JNIObjectHandles.createLocal(new boolean[length]);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle NewByteArray(JNIEnvironment env, int length) {
        if (length < 0) {
            return (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        return JNIObjectHandles.createLocal(new byte[length]);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle NewCharArray(JNIEnvironment env, int length) {
        if (length < 0) {
            return (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        return JNIObjectHandles.createLocal(new char[length]);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle NewDoubleArray(JNIEnvironment env, int length) {
        if (length < 0) {
            return (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        return JNIObjectHandles.createLocal(new double[length]);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle NewFloatArray(JNIEnvironment env, int length) {
        if (length < 0) {
            return (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        return JNIObjectHandles.createLocal(new float[length]);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle NewIntArray(JNIEnvironment env, int length) {
        if (length < 0) {
            return (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        return JNIObjectHandles.createLocal(new int[length]);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle NewLongArray(JNIEnvironment env, int length) {
        if (length < 0) {
            return (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        return JNIObjectHandles.createLocal(new long[length]);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle NewShortArray(JNIEnvironment env, int length) {
        if (length < 0) {
            return (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        return JNIObjectHandles.createLocal(new short[length]);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle NewObjectArray(JNIEnvironment env, int length, JNIObjectHandle hElementClass, JNIObjectHandle hInitialElement) {
        if (length < 0) {
            return (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        Class elementClass = (Class)JNIObjectHandles.getObject(hElementClass);
        Object[] array = null;
        if (elementClass != null) {
            Object initialElement = JNIObjectHandles.getObject(hInitialElement);
            array = (Object[])Array.newInstance(elementClass, length);
            Arrays.fill(array, initialElement);
        }
        return JNIObjectHandles.createLocal(array);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle GetObjectArrayElement(JNIEnvironment env, JNIObjectHandle harray, int index) {
        Object[] array = (Object[])JNIObjectHandles.getObject(harray);
        Object value = array[index];
        return JNIObjectHandles.createLocal(value);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerVoid.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterFatalOnFailurePrologue.class)
    static void SetObjectArrayElement(JNIEnvironment env, JNIObjectHandle harray, int index, JNIObjectHandle hvalue) {
        Object[] array = (Object[])JNIObjectHandles.getObject(harray);
        Object value = JNIObjectHandles.getObject(hvalue);
        array[index] = value;
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullWord.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=CEntryPointOptions.ReturnNullPointer.class)
    static WordPointer GetPrimitiveArrayCritical(JNIEnvironment env, JNIObjectHandle harray, CCharPointer isCopy) {
        Object array = JNIObjectHandles.getObject(harray);
        if (array == null) {
            return (WordPointer)WordFactory.nullPointer();
        }
        if (isCopy.isNonNull()) {
            isCopy.write((byte)0);
        }
        return (WordPointer)JNIThreadLocalPinnedObjects.pinArrayAndGetAddress(array);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerVoid.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterFatalOnFailurePrologue.class)
    static void ReleasePrimitiveArrayCritical(JNIEnvironment env, JNIObjectHandle harray, WordPointer carray, int mode) {
        JNIThreadLocalPinnedObjects.unpinArrayByAddress((PointerBase)carray);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnMinusOne.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnMinusOne.class)
    static int GetArrayLength(JNIEnvironment env, JNIObjectHandle harray) {
        return ArrayLengthNode.arrayLength(JNIObjectHandles.getObject(harray));
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterFatalOnFailurePrologue.class)
    static boolean ExceptionCheck(JNIEnvironment env) {
        return JNIThreadLocalPendingException.get() != null;
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle ExceptionOccurred(JNIEnvironment env) {
        return JNIObjectHandles.createLocal(JNIThreadLocalPendingException.get());
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerVoid.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterFatalOnFailurePrologue.class)
    static void ExceptionClear(JNIEnvironment env) {
        JNIThreadLocalPendingException.clear();
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerVoid.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterFatalOnFailurePrologue.class)
    static void ExceptionDescribe(JNIEnvironment env) {
        Throwable t = JNIThreadLocalPendingException.get();
        JNIThreadLocalPendingException.clear();
        if (t != null && !(t instanceof ThreadDeath)) {
            System.err.println("Exception in thread \"" + Thread.currentThread().getName() + "\": " + t.getClass().getCanonicalName());
            try {
                t.printStackTrace();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.err.flush();
        }
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnZero.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnEDetached.class)
    static int Throw(JNIEnvironment env, JNIObjectHandle handle) throws Throwable {
        throw (Throwable)JNIObjectHandles.getObject(handle);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnZero.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnEDetached.class)
    static int ThrowNew(JNIEnvironment env, JNIObjectHandle clazzHandle, CCharPointer message) throws Throwable {
        Class clazz = (Class)JNIObjectHandles.getObject(clazzHandle);
        JNIMethodId ctor = Support.getMethodID(clazz, "<init>", "(Ljava/lang/String;)V", false);
        JNIObjectHandle messageHandle = JNIFunctions.NewStringUTF(env, message);
        NewObjectWithObjectArrayArgFunctionPointer newObjectA = (NewObjectWithObjectArrayArgFunctionPointer)((Object)env.getFunctions().getNewObjectA());
        JNIValue array = UnsafeStackValue.get(JNIValue.class);
        array.setObject(messageHandle);
        JNIObjectHandle exception = newObjectA.invoke(env, clazzHandle, ctor, array);
        throw (Throwable)JNIObjectHandles.getObject(exception);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerVoid.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterFatalOnFailurePrologue.class)
    @NeverInline(value="Access of caller frame.")
    static void FatalError(JNIEnvironment env, CCharPointer message) {
        CodePointer callerIP = KnownIntrinsics.readReturnAddress();
        Pointer callerSP = KnownIntrinsics.readCallerStackPointer();
        Support.fatalError(callerIP, callerSP, CTypeConversion.toJavaString((CCharPointer)message));
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnJniErr.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnEDetached.class)
    static int GetJavaVM(JNIEnvironment env, JNIJavaVMPointer vm) {
        vm.write(JNIFunctionTables.singleton().getGlobalJavaVM());
        return JNIErrors.JNI_OK();
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullWord.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=CEntryPointOptions.ReturnNullPointer.class)
    static JNIFieldId FromReflectedField(JNIEnvironment env, JNIObjectHandle fieldHandle) {
        JNIFieldId fieldId = (JNIFieldId)WordFactory.zero();
        Field obj = (Field)JNIObjectHandles.getObject(fieldHandle);
        if (obj != null) {
            boolean isStatic = Modifier.isStatic(obj.getModifiers());
            fieldId = JNIReflectionDictionary.singleton().getDeclaredFieldID(obj.getDeclaringClass(), obj.getName(), isStatic);
        }
        return fieldId;
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle ToReflectedField(JNIEnvironment env, JNIObjectHandle classHandle, JNIFieldId fieldId) {
        String name;
        Field field = null;
        Class clazz = (Class)JNIObjectHandles.getObject(classHandle);
        if (clazz != null && (name = JNIReflectionDictionary.singleton().getFieldNameByID(clazz, fieldId)) != null) {
            try {
                field = clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return JNIObjectHandles.createLocal(field);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullWord.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=CEntryPointOptions.ReturnNullPointer.class)
    static JNIMethodId FromReflectedMethod(JNIEnvironment env, JNIObjectHandle methodHandle) {
        JNIMethodId methodId = (JNIMethodId)WordFactory.nullPointer();
        Executable method = (Executable)JNIObjectHandles.getObject(methodHandle);
        if (method != null) {
            boolean isStatic = Modifier.isStatic(method.getModifiers());
            JNIAccessibleMethodDescriptor descriptor = JNIAccessibleMethodDescriptor.of(method);
            methodId = JNIReflectionDictionary.singleton().getDeclaredMethodID(method.getDeclaringClass(), descriptor, isStatic);
        }
        return methodId;
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=CEntryPointOptions.ReturnNullPointer.class)
    static JNIObjectHandle ToReflectedMethod(JNIEnvironment env, JNIObjectHandle classHandle, JNIMethodId methodId, boolean isStatic) {
        Executable result;
        block4: {
            result = null;
            JNIAccessibleMethod jniMethod = JNIReflectionDictionary.getMethodByID(methodId);
            JNIAccessibleMethodDescriptor descriptor = JNIReflectionDictionary.getMethodDescriptor(jniMethod);
            if (descriptor == null) break block4;
            Class<?> clazz = jniMethod.getDeclaringClass().getClassObject();
            if (descriptor.isConstructor()) {
                for (Constructor<?> ctor : clazz.getDeclaredConstructors()) {
                    if (!descriptor.equals(JNIAccessibleMethodDescriptor.of(ctor))) continue;
                    result = ctor;
                    break;
                }
            } else {
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!descriptor.getName().equals(method.getName()) || !descriptor.equals(JNIAccessibleMethodDescriptor.of(method))) continue;
                    result = method;
                    break;
                }
            }
        }
        return JNIObjectHandles.createLocal(result);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnJniErr.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnEDetached.class)
    static int MonitorEnter(JNIEnvironment env, JNIObjectHandle handle) {
        Object obj = JNIObjectHandles.getObject(handle);
        if (obj == null) {
            throw new NullPointerException();
        }
        boolean pinned = false;
        if (VirtualThreads.isSupported() && JavaThreads.isCurrentThreadVirtual()) {
            try {
                VirtualThreads.singleton().pinCurrent();
            }
            catch (IllegalStateException e) {
                throw new IllegalMonitorStateException();
            }
            pinned = true;
        }
        boolean acquired = false;
        try {
            MonitorSupport.singleton().monitorEnter(obj, MonitorInflationCause.JNI_ENTER);
            assert (Thread.holdsLock(obj));
            acquired = true;
            JNIThreadOwnedMonitors.entered(obj);
            return JNIErrors.JNI_OK();
        }
        catch (Throwable t) {
            try {
                if (acquired) {
                    MonitorSupport.singleton().monitorExit(obj, MonitorInflationCause.VM_INTERNAL);
                }
                if (pinned) {
                    VirtualThreads.singleton().unpinCurrent();
                }
            }
            catch (Throwable u) {
                throw VMError.shouldNotReachHere(u);
            }
            throw t;
        }
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnJniErr.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnEDetached.class)
    static int MonitorExit(JNIEnvironment env, JNIObjectHandle handle) {
        Object obj = JNIObjectHandles.getObject(handle);
        if (obj == null) {
            throw new NullPointerException();
        }
        if (!Thread.holdsLock(obj)) {
            throw new IllegalMonitorStateException();
        }
        MonitorSupport.singleton().monitorExit(obj, MonitorInflationCause.JNI_EXIT);
        JNIThreadOwnedMonitors.exited(obj);
        if (VirtualThreads.isSupported() && JavaThreads.isCurrentThreadVirtual()) {
            try {
                VirtualThreads.singleton().unpinCurrent();
            }
            catch (IllegalStateException e) {
                throw new IllegalMonitorStateException();
            }
        }
        return JNIErrors.JNI_OK();
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle GetModule(JNIEnvironment env, JNIObjectHandle handle) {
        Object obj = JNIObjectHandles.getObject(handle);
        if (obj == null) {
            throw new NullPointerException();
        }
        if (!(obj instanceof Class)) {
            throw new IllegalArgumentException();
        }
        Module module = ((Class)obj).getModule();
        return JNIObjectHandles.createLocal(module);
    }

    @CEntryPoint(exceptionHandler=Support.JNIExceptionHandlerReturnNullHandle.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIEnvEnterPrologue.class, prologueBailout=Support.ReturnNullHandle.class)
    static JNIObjectHandle DefineClass(JNIEnvironment env, CCharPointer cname, JNIObjectHandle loader, CCharPointer buf, int bufLen) {
        if (buf.isNull() || bufLen < 0) {
            throw new ClassFormatError();
        }
        String name = Utf8.utf8ToString(cname);
        if (name != null) {
            name = name.replace('/', '.');
        }
        ClassLoader classLoader = (ClassLoader)JNIObjectHandles.getObject(loader);
        byte[] data = new byte[bufLen];
        CTypeConversion.asByteBuffer((PointerBase)buf, (int)bufLen).get(data);
        Class<?> clazz = PredefinedClassesSupport.loadClass(classLoader, name, data, 0, data.length, null);
        return JNIObjectHandles.createLocal(clazz);
    }

    public static class Support {
        static final CGlobalData<CCharPointer> JNIENV_ENTER_FAIL_FATALLY_MESSAGE = CGlobalDataFactory.createCString("A JNI call failed to enter the isolate via its JNI environment argument. The environment might be invalid or no longer exists.");

        static JNIMethodId getMethodID(JNIObjectHandle hclazz, CCharPointer cname, CCharPointer csig, boolean isStatic) {
            Class clazz = (Class)JNIObjectHandles.getObject(hclazz);
            DynamicHub.fromClass(clazz).ensureInitialized();
            CharSequence name = Utf8.wrapUtf8CString(cname);
            CharSequence signature = Utf8.wrapUtf8CString(csig);
            return Support.getMethodID(clazz, name, signature, isStatic);
        }

        private static JNIMethodId getMethodID(Class<?> clazz, CharSequence name, CharSequence signature, boolean isStatic) {
            JNIMethodId methodID = JNIReflectionDictionary.singleton().getMethodID(clazz, name, signature, isStatic);
            if (methodID.isNull()) {
                String message = clazz.getName() + "." + String.valueOf(name) + String.valueOf(signature);
                JNIMethodId candidate = JNIReflectionDictionary.singleton().getMethodID(clazz, name, signature, !isStatic);
                if (candidate.isNonNull()) {
                    message = isStatic ? message + " (found matching non-static method that would be returned by GetMethodID)" : message + " (found matching static method that would be returned by GetStaticMethodID)";
                }
                throw new NoSuchMethodError(message);
            }
            return methodID;
        }

        static JNIFieldId getFieldID(JNIObjectHandle hclazz, CCharPointer cname, CCharPointer csig, boolean isStatic) {
            Class clazz = (Class)JNIObjectHandles.getObject(hclazz);
            DynamicHub.fromClass(clazz).ensureInitialized();
            CharSequence name = Utf8.wrapUtf8CString(cname);
            JNIFieldId fieldID = JNIReflectionDictionary.singleton().getFieldID(clazz, name, isStatic);
            if (fieldID.isNull()) {
                throw new NoSuchFieldError(clazz.getName() + "." + String.valueOf(name));
            }
            return fieldID;
        }

        static CShortPointer getNulTerminatedStringCharsAndPin(JNIObjectHandle hstr, CCharPointer isCopy) {
            String str = (String)JNIObjectHandles.getObject(hstr);
            if (str == null) {
                return (CShortPointer)WordFactory.nullPointer();
            }
            if (isCopy.isNonNull()) {
                isCopy.write((byte)1);
            }
            char[] chars = new char[str.length() + 1];
            str.getChars(0, str.length(), chars, 0);
            return (CShortPointer)JNIThreadLocalPinnedObjects.pinArrayAndGetAddress(chars);
        }

        static void unpinString(CShortPointer cstr) {
            JNIThreadLocalPinnedObjects.unpinArrayByAddress((PointerBase)cstr);
        }

        @Uninterruptible(reason="exception handler")
        static void handleException(Throwable t) {
            JNIThreadLocalPendingException.set(t);
        }

        @Uninterruptible(reason="Prevent safepoints until everything is set up for the fatal error printing.", calleeMustBe=false)
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in fatal error handling.")
        static void fatalError(CodePointer callerIP, Pointer callerSP, String message) {
            VMThreads.SafepointBehavior.preventSafepoints();
            StackOverflowCheck.singleton().disableStackOverflowChecksForFatalError();
            LogHandler logHandler = (LogHandler)ImageSingletons.lookup(LogHandler.class);
            Log log = Log.enterFatalContext(logHandler, callerIP, message, null);
            if (log != null) {
                try {
                    log.string("Fatal error reported via JNI: ").string(message).newline();
                    SubstrateDiagnostics.printFatalError(log, callerSP, callerIP);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            logHandler.fatalError();
        }

        @SuppressFBWarnings(value={"BC_IMPOSSIBLE_INSTANCEOF"}, justification="FindBugs does not understand substitution classes")
        static Target_java_nio_Buffer directBufferFromJNIHandle(JNIObjectHandle handle) {
            Object obj = JNIObjectHandles.getObject(handle);
            if (obj instanceof Target_java_nio_Buffer && obj instanceof DirectBuffer) {
                return (Target_java_nio_Buffer)obj;
            }
            return null;
        }

        static class JNIExceptionHandlerDetachAndReturnJniErr
        implements CEntryPoint.ExceptionHandler {
            JNIExceptionHandlerDetachAndReturnJniErr() {
            }

            @Uninterruptible(reason="exception handler")
            static int handle(Throwable t) {
                int error = t instanceof OutOfMemoryError ? JNIErrors.JNI_ENOMEM() : JNIErrors.JNI_ERR();
                CEntryPointActions.leaveDetachThread();
                return error;
            }
        }

        static class JNIExceptionHandlerReturnJniErr
        implements CEntryPoint.ExceptionHandler {
            JNIExceptionHandlerReturnJniErr() {
            }

            @Uninterruptible(reason="exception handler")
            static int handle(Throwable t) {
                Support.handleException(t);
                return JNIErrors.JNI_ERR();
            }
        }

        static class JNIExceptionHandlerReturnZero
        implements CEntryPoint.ExceptionHandler {
            JNIExceptionHandlerReturnZero() {
            }

            @Uninterruptible(reason="exception handler")
            static int handle(Throwable t) {
                Support.handleException(t);
                return 0;
            }
        }

        static class JNIExceptionHandlerReturnMinusOne
        implements CEntryPoint.ExceptionHandler {
            JNIExceptionHandlerReturnMinusOne() {
            }

            @Uninterruptible(reason="exception handler")
            static int handle(Throwable t) {
                Support.handleException(t);
                return -1;
            }
        }

        static class JNIExceptionHandlerReturnFalse
        implements CEntryPoint.ExceptionHandler {
            JNIExceptionHandlerReturnFalse() {
            }

            @Uninterruptible(reason="exception handler")
            static boolean handle(Throwable t) {
                Support.handleException(t);
                return false;
            }
        }

        static class JNIExceptionHandlerReturnNullWord
        implements CEntryPoint.ExceptionHandler {
            JNIExceptionHandlerReturnNullWord() {
            }

            @Uninterruptible(reason="exception handler")
            static WordBase handle(Throwable t) {
                Support.handleException(t);
                return WordFactory.nullPointer();
            }
        }

        static class JNIExceptionHandlerReturnNullHandle
        implements CEntryPoint.ExceptionHandler {
            JNIExceptionHandlerReturnNullHandle() {
            }

            @Uninterruptible(reason="exception handler")
            static JNIObjectHandle handle(Throwable t) {
                Support.handleException(t);
                return (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }

        public static class JNIExceptionHandlerVoid
        implements CEntryPoint.ExceptionHandler {
            @Uninterruptible(reason="exception handler")
            static void handle(Throwable t) {
                Support.handleException(t);
            }
        }

        static class JNIJavaVMEnterAttachThreadManualJavaThreadPrologue
        implements CEntryPointOptions.Prologue {
            JNIJavaVMEnterAttachThreadManualJavaThreadPrologue() {
            }

            @Uninterruptible(reason="prologue")
            static int enter(JNIJavaVM vm) {
                if (CEntryPointActions.enterAttachThread(vm.getFunctions().getIsolate(), false, false) != 0) {
                    return JNIErrors.JNI_ERR();
                }
                return 0;
            }
        }

        static class JNIJavaVMEnterAttachThreadEnsureJavaThreadPrologue
        implements CEntryPointOptions.Prologue {
            JNIJavaVMEnterAttachThreadEnsureJavaThreadPrologue() {
            }

            @Uninterruptible(reason="prologue")
            static int enter(JNIJavaVM vm) {
                if (CEntryPointActions.enterAttachThread(vm.getFunctions().getIsolate(), false, true) != 0) {
                    return JNIErrors.JNI_ERR();
                }
                return 0;
            }
        }

        public static class JNIEnvEnterFatalOnFailurePrologue
        implements CEntryPointOptions.Prologue {
            @Uninterruptible(reason="prologue")
            public static void enter(JNIEnvironment env) {
                int error = CEntryPointActions.enter((IsolateThread)env);
                if (error != 0) {
                    CEntryPointActions.failFatally(error, JNIENV_ENTER_FAIL_FATALLY_MESSAGE.get());
                }
            }
        }

        static class ReturnMinusOneLong
        implements CEntryPointOptions.PrologueBailout {
            ReturnMinusOneLong() {
            }

            @Uninterruptible(reason="prologue")
            public static long bailout(int prologueResult) {
                return -1L;
            }
        }

        static class ReturnMinusOne
        implements CEntryPointOptions.PrologueBailout {
            ReturnMinusOne() {
            }

            @Uninterruptible(reason="prologue")
            public static int bailout(int prologueResult) {
                return -1;
            }
        }

        static class ReturnEDetached
        implements CEntryPointOptions.PrologueBailout {
            ReturnEDetached() {
            }

            @Uninterruptible(reason="prologue")
            public static int bailout(int prologueResult) {
                return JNIErrors.JNI_EDETACHED();
            }
        }

        static class ReturnNullHandle
        implements CEntryPointOptions.PrologueBailout {
            ReturnNullHandle() {
            }

            @Uninterruptible(reason="prologue")
            public static JNIObjectHandle bailout(int prologueResult) {
                return (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }

        static class JNIEnvEnterPrologue
        implements CEntryPointOptions.Prologue {
            JNIEnvEnterPrologue() {
            }

            @Uninterruptible(reason="prologue")
            public static int enter(JNIEnvironment env) {
                return CEntryPointActions.enter((IsolateThread)env);
            }
        }
    }

    @TargetClass(value=Buffer.class)
    static final class Target_java_nio_Buffer {
        @Alias
        int capacity;
        @Alias
        long address;

        Target_java_nio_Buffer() {
        }
    }

    static interface NewObjectWithObjectArrayArgFunctionPointer
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JNIObjectHandle invoke(JNIEnvironment var1, JNIObjectHandle var2, JNIMethodId var3, JNIValue var4);
    }

    public static class UnimplementedWithJavaVMArgument {
        @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
        @CEntryPointOptions(prologue=JNIJavaVMUnimplementedPrologue.class)
        static int unimplemented(JNIJavaVM vm) {
            throw VMError.shouldNotReachHere("An unimplemented JNI function was called. Please refer to the stack trace.");
        }
    }

    static class JNIJavaVMUnimplementedPrologue
    implements CEntryPointOptions.Prologue {
        JNIJavaVMUnimplementedPrologue() {
        }

        @Uninterruptible(reason="prologue")
        static void enter(JNIJavaVM vm) {
            int error = CEntryPointActions.enterAttachThread(vm.getFunctions().getIsolate(), false, true);
            if (error != 0) {
                CEntryPointActions.failFatally(error, UNIMPLEMENTED_UNATTACHED_ERROR_MESSAGE.get());
            }
        }
    }

    public static class UnimplementedWithJNIEnvArgument {
        @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
        @CEntryPointOptions(prologue=JNIEnvUnimplementedPrologue.class)
        static int unimplemented(JNIEnvironment env) {
            throw VMError.shouldNotReachHere("An unimplemented JNI function was called. Please refer to the stack trace.");
        }
    }

    static class JNIEnvUnimplementedPrologue
    implements CEntryPointOptions.Prologue {
        JNIEnvUnimplementedPrologue() {
        }

        @Uninterruptible(reason="prologue")
        static void enter(JNIEnvironment env) {
            int error = CEntryPointActions.enter((IsolateThread)env);
            if (error != 0) {
                CEntryPointActions.failFatally(error, UNIMPLEMENTED_UNATTACHED_ERROR_MESSAGE.get());
            }
        }
    }
}

