/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.events;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.StackValue;

public class JavaMonitorEnterEvent {
    public static void emit(Object obj, long previousOwnerTid, long startTicks) {
        if (HasJfrSupport.get()) {
            JavaMonitorEnterEvent.emit0(obj, previousOwnerTid, startTicks);
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    public static void emit0(Object obj, long previousOwnerTid, long startTicks) {
        if (JfrEvent.JavaMonitorEnter.shouldEmit()) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.JavaMonitorEnter);
            JfrNativeEventWriter.putLong(data, startTicks);
            JfrNativeEventWriter.putLong(data, JfrTicks.elapsedTicks() - startTicks);
            JfrNativeEventWriter.putEventThread(data);
            JfrNativeEventWriter.putLong(data, SubstrateJVM.get().getStackTraceId(JfrEvent.JavaMonitorEnter, 0));
            JfrNativeEventWriter.putClass(data, obj.getClass());
            JfrNativeEventWriter.putLong(data, previousOwnerTid);
            JfrNativeEventWriter.putLong(data, Word.objectToUntrackedPointer((Object)obj).rawValue());
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }
}

