/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.util.VMError;
import java.util.HashMap;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.TypeLibrary;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.options.OptionsParser;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class JfrMetadataTypeLibrary {
    private static final HashMap<String, Type> types = new HashMap();

    private static synchronized HashMap<String, Type> getTypes() {
        if (types.isEmpty()) {
            for (Type type : TypeLibrary.getInstance().getTypes()) {
                assert (!types.containsKey(type.getName()));
                types.put(type.getName(), type);
            }
        }
        return types;
    }

    public static int getPlatformEventCount() {
        long maxEventId = 0L;
        for (Type type : JfrMetadataTypeLibrary.getTypes().values()) {
            if (!(type instanceof PlatformEventType)) continue;
            maxEventId = Math.max(maxEventId, type.getId());
        }
        return NumUtil.safeToInt((long)(maxEventId + 1L));
    }

    public static long lookupPlatformEvent(String name) {
        Type type = JfrMetadataTypeLibrary.getTypes().get(name);
        if (type instanceof PlatformEventType) {
            return type.getId();
        }
        return JfrMetadataTypeLibrary.notFound(name);
    }

    public static long lookupType(String name) {
        Type type = JfrMetadataTypeLibrary.getTypes().get(name);
        if (type != null) {
            return type.getId();
        }
        return JfrMetadataTypeLibrary.notFound(name);
    }

    private static long notFound(String name) {
        String exceptionMessage = "Event/Type " + name + " was not found!";
        Type mostSimilar = JfrMetadataTypeLibrary.getMostSimilar(name);
        if (mostSimilar != null) {
            exceptionMessage = exceptionMessage + " The most similar event/type is '" + mostSimilar.getName() + "' (" + String.valueOf(mostSimilar.getClass()) + ").";
        }
        exceptionMessage = exceptionMessage + " Take a look at 'metadata.xml' to see all available events.";
        throw VMError.shouldNotReachHere(exceptionMessage);
    }

    private static Type getMostSimilar(String missingTypeName) {
        float threshold = 0.7f;
        Type mostSimilar = null;
        for (Type type : JfrMetadataTypeLibrary.getTypes().values()) {
            float similarity = OptionsParser.stringSimilarity((String)type.getName(), (String)missingTypeName);
            if (!(similarity > threshold)) continue;
            threshold = similarity;
            mostSimilar = type;
        }
        return mostSimilar;
    }
}

