/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.jfr.JfrChunkWriter;
import com.oracle.svm.core.jfr.JfrSerializer;
import com.oracle.svm.core.jfr.JfrType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class JfrGCCauseSerializer
implements JfrSerializer {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrGCCauseSerializer() {
    }

    @Override
    public void write(JfrChunkWriter writer) {
        GCCause[] causes = GCCause.getGCCauses();
        int nonNullItems = 0;
        for (int index = 0; index < causes.length; ++index) {
            if (causes[index] == null) continue;
            ++nonNullItems;
        }
        assert (nonNullItems > 0);
        writer.writeCompressedLong(JfrType.GCCause.getId());
        writer.writeCompressedLong(nonNullItems);
        for (GCCause cause : causes) {
            if (cause == null) continue;
            writer.writeCompressedLong(cause.getId());
            writer.writeString(cause.getName());
        }
    }
}

