/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.management;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.management.JmxServerIncluded;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import jdk.internal.agent.Agent;

@TargetClass(value=Agent.class)
final class Target_jdk_internal_agent_Agent {
    Target_jdk_internal_agent_Agent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    @TargetElement(onlyWith={JmxServerIncluded.class})
    public static void readConfiguration(String fname, Properties p) {
        if (fname == null) {
            return;
        }
        File configFile = new File(fname);
        if (!configFile.exists()) {
            Agent.error("agent.err.configfile.notfound", fname);
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(configFile);
            p.load(in);
        }
        catch (FileNotFoundException e) {
            Agent.error("agent.err.configfile.failed", e.getMessage());
        }
        catch (IOException e) {
            Agent.error("agent.err.configfile.failed", e.getMessage());
        }
        catch (SecurityException e) {
            Agent.error("agent.err.configfile.access.denied", fname);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    Agent.error("agent.err.configfile.closed.failed", fname);
                }
            }
        }
    }
}

