/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.VarHandleInfo;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import jdk.internal.misc.Unsafe;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class VarHandleFeature
implements InternalFeature {
    static final String OBJECT_SUFFIX = JavaVersionUtil.JAVA_SPEC <= 11 ? "Objects" : "References";
    private final Map<Class<?>, VarHandleInfo> infos = new HashMap();
    private final ConcurrentMap<Object, Boolean> processedVarHandles = new ConcurrentHashMap<Object, Boolean>();
    private Consumer<Field> markAsUnsafeAccessed;

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        try {
            for (String typeName : new String[]{"Booleans", "Bytes", "Chars", "Doubles", "Floats", "Ints", "Longs", "Shorts", OBJECT_SUFFIX}) {
                this.buildInfo(false, "receiverType", Class.forName("java.lang.invoke.VarHandle" + typeName + "$FieldInstanceReadOnly"), Class.forName("java.lang.invoke.VarHandle" + typeName + "$FieldInstanceReadWrite"));
                this.buildInfo(true, "base", Class.forName("java.lang.invoke.VarHandle" + typeName + "$FieldStaticReadOnly"), Class.forName("java.lang.invoke.VarHandle" + typeName + "$FieldStaticReadWrite"));
            }
        }
        catch (ClassNotFoundException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private void buildInfo(boolean isStatic, String typeFieldName, Class<?> readOnlyClass, Class<?> readWriteClass) {
        VarHandleInfo info = new VarHandleInfo(isStatic, ReflectionUtil.lookupField(readOnlyClass, (String)"fieldOffset"), ReflectionUtil.lookupField(readOnlyClass, (String)typeFieldName));
        this.infos.put(readOnlyClass, info);
        this.infos.put(readWriteClass, info);
    }

    Field findVarHandleField(Object varHandle) {
        try {
            Class type;
            VarHandleInfo info = this.infos.get(varHandle.getClass());
            long originalFieldOffset = info.fieldOffsetField.getLong(varHandle);
            for (Class cur = type = (Class)info.typeField.get(varHandle); cur != null; cur = cur.getSuperclass()) {
                for (Field field : cur.getDeclaredFields()) {
                    long fieldOffset;
                    if (Modifier.isStatic(field.getModifiers()) != info.isStatic) continue;
                    long l = fieldOffset = info.isStatic ? Unsafe.getUnsafe().staticFieldOffset(field) : Unsafe.getUnsafe().objectFieldOffset(field);
                    if (fieldOffset != originalFieldOffset) continue;
                    return field;
                }
                if (info.isStatic) break;
            }
            throw VMError.shouldNotReachHere("Could not find field referenced in VarHandle: " + String.valueOf(type) + ", offset = " + originalFieldOffset + ", isStatic = " + info.isStatic);
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        access.registerObjectReplacer(this::processVarHandle);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.markAsUnsafeAccessed = arg_0 -> ((Feature.BeforeAnalysisAccess)access).registerAsUnsafeAccessed(arg_0);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.markAsUnsafeAccessed = null;
    }

    private Object processVarHandle(Object obj) {
        VarHandleInfo info = this.infos.get(obj.getClass());
        if (info != null && this.processedVarHandles.putIfAbsent(obj, true) == null) {
            VMError.guarantee(this.markAsUnsafeAccessed != null, "New VarHandle found after static analysis");
            Field field = this.findVarHandleField(obj);
            this.markAsUnsafeAccessed.accept(field);
        }
        return obj;
    }
}

