/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.thread.JavaThreads;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;

@TargetClass(value=Throwable.class)
@Platforms(value={InternalPlatform.NATIVE_ONLY.class})
final class Target_java_lang_Throwable {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private Object backtrace;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    StackTraceElement[] stackTrace;
    @Alias
    String detailMessage;

    Target_java_lang_Throwable() {
    }

    @Substitute
    @NeverInline(value="Starting a stack walk in the caller frame")
    private Object fillInStackTrace() {
        this.stackTrace = JavaThreads.getStackTrace(true, Thread.currentThread());
        return this;
    }

    @Substitute
    private StackTraceElement[] getOurStackTrace() {
        if (this.stackTrace != null) {
            return this.stackTrace;
        }
        return new StackTraceElement[0];
    }
}

