/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.stackvalue;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.graal.stackvalue.LoweredStackValueNode;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.RestrictHeapAccessCallees;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.thread.JavaThreads;
import java.util.Map;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordBase;

final class StackValueSnippets
extends SubstrateTemplates
implements Snippets {
    private static final String EXCEPTION_MESSAGE = "StackValue must not be used in a virtual thread unless the method is annotated @" + Uninterruptible.class.getSimpleName() + ".";
    private static final IllegalThreadStateException CACHED_EXCEPTION = new IllegalThreadStateException(EXCEPTION_MESSAGE + " [no exception stack trace available because exception is thrown from code that must be allocation free]");
    static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_EXCEPTION = SnippetRuntime.findForeignCall(StackValueSnippets.class, "throwCachedException", true, new LocationIdentity[0]);
    static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_EXCEPTION = SnippetRuntime.findForeignCall(StackValueSnippets.class, "throwNewException", true, new LocationIdentity[0]);
    static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{THROW_CACHED_EXCEPTION, THROW_NEW_EXCEPTION};
    private final SnippetTemplate.SnippetInfo stackValueSnippet;

    @Snippet
    private static WordBase stackValueSnippet(@Snippet.ConstantParameter int sizeInBytes, @Snippet.ConstantParameter int alignmentInBytes, @Snippet.ConstantParameter StackValueNode.StackSlotIdentity slotIdentifier, @Snippet.ConstantParameter boolean disallowVirtualThread, @Snippet.ConstantParameter boolean mustNotAllocate) {
        if (disallowVirtualThread && BranchProbabilityNode.probability((double)1.0000000000287557E-6, (boolean)JavaThreads.isCurrentThreadVirtual())) {
            if (mustNotAllocate) {
                StackValueSnippets.callSlowPath(THROW_CACHED_EXCEPTION);
            } else {
                StackValueSnippets.callSlowPath(THROW_NEW_EXCEPTION);
            }
        }
        return LoweredStackValueNode.loweredStackValue(sizeInBytes, alignmentInBytes, slotIdentifier);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callSlowPath(@Node.ConstantNodeParameter ForeignCallDescriptor var0);

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwCachedException() {
        throw CACHED_EXCEPTION;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwNewException() {
        IllegalThreadStateException error = Heap.getHeap().isAllocationDisallowed() ? CACHED_EXCEPTION : new IllegalThreadStateException(EXCEPTION_MESSAGE);
        throw error;
    }

    StackValueSnippets(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, providers);
        this.stackValueSnippet = this.snippet(providers, StackValueSnippets.class, "stackValueSnippet", new LocationIdentity[0]);
        lowerings.put(StackValueNode.class, new StackValueVirtualThreadCheckLowering());
    }

    final class StackValueVirtualThreadCheckLowering
    implements NodeLoweringProvider<StackValueNode> {
        StackValueVirtualThreadCheckLowering() {
        }

        @Override
        public void lower(StackValueNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            GraalError.guarantee((tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER ? 1 : 0) != 0, (String)"Must lower before mid-tier StackValueRecursionDepthPhase");
            boolean mustNotAllocate = ((RestrictHeapAccessCallees)ImageSingletons.lookup(RestrictHeapAccessCallees.class)).mustNotAllocate(graph.method());
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(StackValueSnippets.this.stackValueSnippet, graph.getGuardsStage(), tool.getLoweringStage());
            args.addConst("sizeInBytes", (Object)node.sizeInBytes);
            args.addConst("alignmentInBytes", (Object)node.alignmentInBytes);
            args.addConst("slotIdentifier", (Object)node.slotIdentity);
            args.addConst("disallowVirtualThread", (Object)node.checkVirtualThread);
            args.addConst("mustNotAllocate", (Object)mustNotAllocate);
            StackValueSnippets.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

