/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.meta;

import com.oracle.svm.core.SubstrateOptions;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class KnownOffsets {
    private int vtableBaseOffset;
    private int vtableEntrySize;
    private int typeIDSlotsOffset;
    private int componentHubOffset;
    private int javaFrameAnchorLastSPOffset;
    private int javaFrameAnchorLastIPOffset;
    private int vmThreadStatusOffset;
    private int imageCodeInfoCodeStartOffset;

    @Fold
    public static KnownOffsets singleton() {
        return (KnownOffsets)ImageSingletons.lookup(KnownOffsets.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setLazyState(int vtableBaseOffset, int vtableEntrySize, int typeIDSlotsOffset, int componentHubOffset, int javaFrameAnchorLastSPOffset, int javaFrameAnchorLastIPOffset, int vmThreadStatusOffset, int imageCodeInfoCodeStartOffset) {
        assert (!this.isFullyInitialized());
        this.vtableBaseOffset = vtableBaseOffset;
        this.vtableEntrySize = vtableEntrySize;
        this.typeIDSlotsOffset = typeIDSlotsOffset;
        this.componentHubOffset = componentHubOffset;
        this.javaFrameAnchorLastSPOffset = javaFrameAnchorLastSPOffset;
        this.javaFrameAnchorLastIPOffset = javaFrameAnchorLastIPOffset;
        this.vmThreadStatusOffset = vmThreadStatusOffset;
        this.imageCodeInfoCodeStartOffset = imageCodeInfoCodeStartOffset;
        assert (this.isFullyInitialized());
    }

    private boolean isFullyInitialized() {
        return this.vtableEntrySize > 0;
    }

    public int getVTableOffset(int vTableIndex) {
        assert (this.isFullyInitialized());
        return this.vtableBaseOffset + vTableIndex * this.vtableEntrySize;
    }

    public int getTypeIDSlotsOffset() {
        assert (this.isFullyInitialized());
        return this.typeIDSlotsOffset;
    }

    public int getComponentHubOffset() {
        assert (this.isFullyInitialized());
        return this.componentHubOffset;
    }

    public int getJavaFrameAnchorLastSPOffset() {
        assert (this.isFullyInitialized());
        return this.javaFrameAnchorLastSPOffset;
    }

    public int getJavaFrameAnchorLastIPOffset() {
        assert (this.isFullyInitialized());
        return this.javaFrameAnchorLastIPOffset;
    }

    public int getVMThreadStatusOffset() {
        assert (this.isFullyInitialized());
        assert (SubstrateOptions.MultiThreaded.getValue().booleanValue() && this.vmThreadStatusOffset != -1);
        return this.vmThreadStatusOffset;
    }

    public int getImageCodeInfoCodeStartOffset() {
        assert (this.isFullyInitialized());
        return this.imageCodeInfoCodeStartOffset;
    }
}

