/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.classinitialization;

import com.oracle.svm.core.classinitialization.ClassInitializationInfo;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.graal.nodes.ForeignCallWithExceptionNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.snippets.SnippetRuntime;
import java.util.Map;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.SnippetAnchorNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public final class EnsureClassInitializedSnippets
extends SubstrateTemplates
implements Snippets {
    private static final SnippetRuntime.SubstrateForeignCallDescriptor INITIALIZE = SnippetRuntime.findForeignCall(ClassInitializationInfo.class, "initialize", false, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{INITIALIZE};
    private final SnippetTemplate.SnippetInfo ensureClassIsInitialized;

    @Snippet
    private static void ensureClassIsInitializedSnippet(@Snippet.NonNullParameter DynamicHub hub) {
        ClassInitializationInfo info = hub.getClassInitializationInfo();
        ClassInitializationInfo infoNonNull = (ClassInitializationInfo)PiNode.piCastNonNull((Object)info, (GuardingNode)SnippetAnchorNode.anchor());
        if (BranchProbabilityNode.probability((double)1.0000000000287557E-6, (!infoNonNull.isInitialized() ? 1 : 0) != 0)) {
            EnsureClassInitializedSnippets.callInitialize(INITIALIZE, infoNonNull, DynamicHub.toClass(hub));
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallWithExceptionNode.class)
    private static native void callInitialize(@Node.ConstantNodeParameter ForeignCallDescriptor var0, ClassInitializationInfo var1, Class<?> var2);

    public static void registerLowerings(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new EnsureClassInitializedSnippets(options, providers, lowerings);
    }

    private EnsureClassInitializedSnippets(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, providers);
        this.ensureClassIsInitialized = this.snippet(providers, EnsureClassInitializedSnippets.class, "ensureClassIsInitializedSnippet", new LocationIdentity[]{LocationIdentity.any()});
        lowerings.put(EnsureClassInitializedNode.class, new EnsureClassInitializedNodeLowering());
    }

    class EnsureClassInitializedNodeLowering
    implements NodeLoweringProvider<EnsureClassInitializedNode> {
        EnsureClassInitializedNodeLowering() {
        }

        @Override
        public void lower(EnsureClassInitializedNode node, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(EnsureClassInitializedSnippets.this.ensureClassIsInitialized, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("hub", (Object)node.getHub());
            EnsureClassInitializedSnippets.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

