/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.code.StubCallingConvention;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Method;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

public final class InvalidMethodPointerHandler {
    public static final Method INVALID_VTABLE_ENTRY_HANDLER_METHOD = ReflectionUtil.lookupMethod(InvalidMethodPointerHandler.class, (String)"invalidVTableEntryHandler", (Class[])new Class[0]);
    public static final String INVALID_VTABLE_ENTRY_MSG = "Fatal error: Virtual method call used an illegal vtable entry that was seen as unused by the static analysis";
    public static final Method METHOD_POINTER_NOT_COMPILED_HANDLER_METHOD = ReflectionUtil.lookupMethod(InvalidMethodPointerHandler.class, (String)"methodPointerNotCompiledHandler", (Class[])new Class[0]);
    public static final String METHOD_POINTER_NOT_COMPILED_MSG = "Fatal error: Method pointer invoked on a method that was not compiled because it was not seen as invoked by the static analysis nor was it directly registered for compilation";

    @StubCallingConvention
    @NeverInline(value="We need a separate frame that stores all registers")
    private static void invalidVTableEntryHandler() {
        Pointer callerSP = KnownIntrinsics.readCallerStackPointer();
        CodePointer callerIP = KnownIntrinsics.readReturnAddress();
        InvalidMethodPointerHandler.failFatally(callerSP, callerIP, INVALID_VTABLE_ENTRY_MSG);
    }

    @StubCallingConvention
    @NeverInline(value="We need a separate frame that stores all registers")
    private static void methodPointerNotCompiledHandler() {
        Pointer callerSP = KnownIntrinsics.readCallerStackPointer();
        CodePointer callerIP = KnownIntrinsics.readReturnAddress();
        InvalidMethodPointerHandler.failFatally(callerSP, callerIP, METHOD_POINTER_NOT_COMPILED_MSG);
    }

    @Uninterruptible(reason="Prevent safepoints until everything is set up for printing the fatal error.", calleeMustBe=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in fatal error handling.")
    private static void failFatally(Pointer callerSP, CodePointer callerIP, String message) {
        VMThreads.SafepointBehavior.preventSafepoints();
        StackOverflowCheck.singleton().disableStackOverflowChecksForFatalError();
        LogHandler logHandler = (LogHandler)ImageSingletons.lookup(LogHandler.class);
        Log log = Log.enterFatalContext(logHandler, callerIP, message, null);
        if (log != null) {
            SubstrateDiagnostics.printFatalError(log, callerSP, callerIP, (RegisterDumper.Context)WordFactory.nullPointer(), true);
            log.string(message).newline();
        }
        logHandler.fatalError();
    }
}

