/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.insight.heap.instrument;

import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.function.Consumer;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;
import org.graalvm.options.OptionType;
import org.graalvm.options.OptionValues;
import org.graalvm.tools.insight.Insight;
import org.graalvm.tools.insight.heap.instrument.CacheReplacement;
import org.graalvm.tools.insight.heap.instrument.HeapDumpInstrumentOptionDescriptors;
import org.graalvm.tools.insight.heap.instrument.HeapObject;

@TruffleInstrument.Registration(id="heap", name="Heap Dump", internal=false, services={Insight.SymbolProvider.class, Consumer.class})
public final class HeapDumpInstrument
extends TruffleInstrument {
    static final OptionType<CacheReplacement> cacheReplacementType = new OptionType("flush|lru", replacement -> {
        switch (replacement.toLowerCase()) {
            case "lru": {
                return CacheReplacement.LRU;
            }
            case "flush": {
                return CacheReplacement.FLUSH;
            }
        }
        throw new IllegalArgumentException("Unknown cache replacement type: " + replacement);
    });
    @Option(stability=OptionStability.STABLE, name="dump", help="Output file to write the heap dump to", usageSyntax="<file name>", category=OptionCategory.EXPERT)
    static final OptionKey<String> DUMP = new OptionKey((Object)"");
    @Option(stability=OptionStability.STABLE, help="Size of memory cache (>0:number of cached dump events, 0: no cache, <0: infinite cache) (default: 0)", usageSyntax="<int>", category=OptionCategory.EXPERT)
    static final OptionKey<Integer> cacheSize = new OptionKey((Object)0);
    @Option(stability=OptionStability.STABLE, help="Replacement policy when the cache is full (flush: flush to file, no data are lost, lru: drop the oldest event, old data are lost)  (default: flush)", usageSyntax="flush|lru", category=OptionCategory.EXPERT)
    static final OptionKey<CacheReplacement> cacheReplacement = new OptionKey((Object)CacheReplacement.FLUSH, cacheReplacementType);
    @Option(stability=OptionStability.EXPERIMENTAL, help="Expose heap.cache array (default: false)", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> exposeCache = new OptionKey((Object)false);

    protected void onCreate(TruffleInstrument.Env env) {
        OptionValues options = env.getOptions();
        String path = DUMP.hasBeenSet(options) ? (String)options.get(DUMP) : null;
        HeapObject obj = new HeapObject(env, path, (Integer)options.get(cacheSize), (CacheReplacement)((Object)options.get(cacheReplacement)), (Boolean)options.get(exposeCache));
        env.registerService((Object)HeapDumpInstrument.maybeProxy(Insight.SymbolProvider.class, obj));
        env.registerService((Object)HeapDumpInstrument.maybeProxy(Consumer.class, obj));
    }

    protected OptionDescriptors getOptionDescriptors() {
        return new HeapDumpInstrumentOptionDescriptors();
    }

    static <Interface> Interface maybeProxy(Class<Interface> type, Interface delegate) {
        if (TruffleOptions.AOT) {
            return delegate;
        }
        return HeapDumpInstrument.proxy(type, delegate);
    }

    private static <Interface> Interface proxy(Class<Interface> type, Interface delegate) {
        InvocationHandler handler = (proxy, method, args) -> {
            try {
                return method.invoke(delegate, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getCause();
            }
        };
        return type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, handler));
    }
}

