/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.insight.heap;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;

public final class HeapDump {
    private static final String MAGIC = "JAVA PROFILE 1.0.1";
    private static final int TAG_STRING = 1;
    private static final int TAG_LOAD_CLASS = 2;
    private static final int TAG_STACK_FRAME = 4;
    private static final int TAG_STACK_TRACE = 5;
    private static final int TAG_HEAP_DUMP = 12;
    private static final int HEAP_ROOT_JAVA_FRAME = 3;
    private static final int HEAP_ROOT_THREAD_OBJECT = 8;
    private static final int HEAP_CLASS_DUMP = 32;
    private static final int HEAP_INSTANCE_DUMP = 33;
    private static final int HEAP_OBJECT_ARRAY_DUMP = 34;
    private static final int HEAP_PRIMITIVE_ARRAY_DUMP = 35;
    private static final int TYPE_OBJECT = 2;
    private static final int TYPE_BOOLEAN = 4;
    private static final int TYPE_CHAR = 5;
    private static final int TYPE_FLOAT = 6;
    private static final int TYPE_DOUBLE = 7;
    private static final int TYPE_BYTE = 8;
    private static final int TYPE_SHORT = 9;
    private static final int TYPE_INT = 10;
    private static final int TYPE_LONG = 11;
    private final DataOutputStream heap;
    private final Builder builder;
    private final Map<String, ObjectInstance> heapStrings = new HashMap<String, ObjectInstance>();
    private final Map<Class<?>, ClassInstance> primitiveClasses = new HashMap();
    private final Map<Object, ObjectInstance> primitives = new HashMap<Object, ObjectInstance>();
    private final ClassInstance typeObject;
    private final ClassInstance typeString;
    private final ClassInstance typeThread;
    private ClassInstance typeObjectArray;

    HeapDump() {
        this.builder = null;
        this.heap = null;
        this.typeObject = null;
        this.typeString = null;
        this.typeThread = null;
    }

    HeapDump(OutputStream out, Builder builder) {
        this.builder = builder;
        this.heap = new DataOutputStream(out);
        this.typeObject = new ClassBuilder("java.lang.Object", 0).dumpClass();
        this.newClass("char[]").dumpClass();
        this.typeString = this.newClass("java.lang.String").field("value", char[].class).field("hash", Integer.TYPE).dumpClass();
        this.typeThread = this.newClass("java.lang.Thread").field("daemon", Boolean.TYPE).field("name", String.class).field("priority", Integer.TYPE).dumpClass();
        this.typeObjectArray = this.newClass("[Ljava/lang/Object;").dumpClass();
    }

    public static Builder newHeapBuilder(OutputStream os) throws IOException {
        HeapDump dummyWrapper;
        HeapDump heapDump = dummyWrapper = new HeapDump();
        Objects.requireNonNull(heapDump);
        return heapDump.new Builder(Identifiers.FOUR, os);
    }

    public ClassBuilder newClass(String name) throws UncheckedIOException {
        return new ClassBuilder(name, this.typeObject.id(this));
    }

    public ThreadBuilder newThread(String name) {
        return new ThreadBuilder(name);
    }

    public InstanceBuilder newInstance(ClassInstance clazz) {
        try {
            return new InstanceBuilder(clazz, this.builder.objectCounter.next());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public ArrayBuilder newArray(int len) {
        try {
            return new ArrayBuilder(this.typeObjectArray, len, this.builder.objectCounter.next());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    void flush() throws IOException {
        this.heap.flush();
    }

    public ObjectInstance dumpString(String text) throws UncheckedIOException {
        try {
            return this.dumpStringImpl(text);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private ObjectInstance dumpStringImpl(String text) throws IOException {
        if (text == null) {
            return new ObjectInstance(0);
        }
        ObjectInstance id = this.heapStrings.get(text);
        if (id != null) {
            return id;
        }
        int instanceId = this.builder.objectCounter.next();
        this.heap.writeByte(35);
        this.builder.ids.writeID(this.heap, instanceId);
        this.builder.writeDefaultStackTraceSerialNumber(this.heap);
        this.heap.writeInt(text.length());
        this.heap.writeByte(5);
        for (char ch : text.toCharArray()) {
            this.heap.writeChar(ch);
        }
        ObjectInstance stringId = this.newInstance(this.typeString).putImpl("value", instanceId).putInt("hash", text.hashCode()).dumpInstance();
        this.heapStrings.put(text, stringId);
        return stringId;
    }

    public ObjectInstance dumpPrimitive(Object obj) throws UncheckedIOException {
        ObjectInstance id = this.primitives.get(obj);
        if (id != null) {
            return id;
        }
        Class<?> clazz = obj.getClass();
        ClassInstance wrapperClass = this.primitiveClasses.get(clazz);
        if (wrapperClass == null) {
            Class<?> primitiveType = HeapDump.findPrimitiveType(clazz);
            wrapperClass = this.newClass(clazz.getName()).field("value", primitiveType).dumpClass();
            this.primitiveClasses.put(clazz, wrapperClass);
        }
        ObjectInstance instanceId = this.newInstance(wrapperClass).putImpl("value", obj).dumpInstance();
        this.primitives.put(obj, instanceId);
        return instanceId;
    }

    private static int[] switchOnType(Class<?> type, Identifiers ids) throws IllegalStateException {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return new int[]{4, 1};
            }
            if (type == Character.TYPE) {
                return new int[]{5, 2};
            }
            if (type == Float.TYPE) {
                return new int[]{6, 4};
            }
            if (type == Double.TYPE) {
                return new int[]{7, 8};
            }
            if (type == Byte.TYPE) {
                return new int[]{8, 1};
            }
            if (type == Short.TYPE) {
                return new int[]{9, 2};
            }
            if (type == Integer.TYPE) {
                return new int[]{10, 4};
            }
            if (type == Long.TYPE) {
                return new int[]{11, 8};
            }
            throw new IllegalStateException("Unsupported primitive type: " + String.valueOf(type));
        }
        return new int[]{2, ids.sizeOf()};
    }

    private static Class<?> findPrimitiveType(Class<? extends Object> clazz) throws IllegalStateException {
        assert (clazz.getName().startsWith("java.lang."));
        Class<Comparable<Boolean>> primitiveType = switch (clazz.getName()) {
            case "java.lang.Boolean" -> Boolean.TYPE;
            case "java.lang.Byte" -> Byte.TYPE;
            case "java.lang.Short" -> Short.TYPE;
            case "java.lang.Integer" -> Integer.TYPE;
            case "java.lang.Long" -> Long.TYPE;
            case "java.lang.Float" -> Float.TYPE;
            case "java.lang.Double" -> Double.TYPE;
            case "java.lang.Character" -> Character.TYPE;
            default -> throw new IllegalStateException(clazz.getName());
        };
        assert (primitiveType.isPrimitive());
        return primitiveType;
    }

    public final class Builder
    implements Closeable {
        final Identifiers ids;
        private final Map<String, Integer> wholeStrings = new HashMap<String, Integer>();
        private final DataOutputStream whole;
        private int defaultStackTrace;
        private Long timeBase;
        final Counter objectCounter = new Counter("object");
        private final Counter stackFrameCounter = new Counter("stackFrame");
        private final Counter stackTraceCounter = new Counter("stackTrace");
        private final Counter classCounter = new Counter("class");
        private final Counter threadCounter = new Counter("thread");

        private Builder(Identifiers ids, OutputStream os) {
            this.whole = new DataOutputStream(os);
            this.ids = ids;
        }

        private void dumpPrologue(Identifiers ids1, long millis) throws IOException {
            this.whole.write(HeapDump.MAGIC.getBytes());
            this.whole.write(0);
            this.whole.writeInt(ids1.sizeOf());
            this.whole.writeLong(millis);
            this.defaultStackTrace = this.writeStackTrace(0, new int[0]);
        }

        public void dumpHeap(Consumer<HeapDump> generator) throws IOException {
            this.dumpHeap(System.currentTimeMillis(), generator);
        }

        public void dumpHeap(long timeStamp, Consumer<HeapDump> generator) throws IOException {
            if (this.timeBase == null) {
                this.timeBase = timeStamp;
                this.dumpPrologue(this.ids, this.timeBase);
            }
            ByteArrayOutputStream rawHeap = new ByteArrayOutputStream();
            HeapDump seg = new HeapDump(rawHeap, this);
            try {
                generator.accept(seg);
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
            seg.flush();
            if (rawHeap.size() > 0) {
                this.whole.writeByte(12);
                long diffMillis = Math.max(0L, timeStamp - this.timeBase);
                long diffMicroseconds = Math.min(diffMillis * 1000L, Integer.MAX_VALUE);
                this.whole.writeInt((int)diffMicroseconds);
                byte[] bytes = rawHeap.toByteArray();
                this.whole.writeInt(bytes.length);
                this.whole.write(bytes);
                this.whole.flush();
            }
        }

        @Override
        public void close() throws IOException {
            this.whole.close();
        }

        void writeDefaultStackTraceSerialNumber(DataOutputStream os) throws IOException {
            os.writeInt(this.defaultStackTrace);
        }

        int writeStackFrame(HeapDump thiz, ClassInstance clazz, String rootName, String sourceFile, int lineNumber) throws IOException {
            int id = this.stackFrameCounter.next();
            int rootNameId = this.writeString(rootName);
            int signatureId = this.writeString("");
            int sourceFileId = this.writeString(sourceFile);
            this.whole.writeByte(4);
            this.whole.writeInt(0);
            this.whole.writeInt(8 + this.ids.sizeOf() * 4);
            this.ids.writeID(this.whole, id);
            this.ids.writeID(this.whole, rootNameId);
            this.ids.writeID(this.whole, signatureId);
            this.ids.writeID(this.whole, sourceFileId);
            this.whole.writeInt(clazz.serialId(thiz));
            this.whole.writeInt(lineNumber);
            return id;
        }

        int writeStackTrace(int threadSerialId, int ... frames) throws IOException {
            int id = this.stackTraceCounter.next();
            this.whole.writeByte(5);
            this.whole.writeInt(0);
            this.whole.writeInt(12 + this.ids.sizeOf() * frames.length);
            this.whole.writeInt(id);
            this.whole.writeInt(threadSerialId);
            this.whole.writeInt(frames.length);
            for (int fId : frames) {
                this.ids.writeID(this.whole, fId);
            }
            return id;
        }

        int writeLoadClass(String className, int classSerial) throws IOException {
            int classId = this.objectCounter.next();
            int classNameId = this.writeString(className);
            this.whole.writeByte(2);
            this.whole.writeInt(0);
            this.whole.writeInt(8 + this.ids.sizeOf() * 2);
            this.whole.writeInt(classSerial);
            this.ids.writeID(this.whole, classId);
            this.writeDefaultStackTraceSerialNumber(this.whole);
            this.ids.writeID(this.whole, classNameId);
            return classId;
        }

        int writeString(String text) throws IOException {
            if (text == null) {
                return 0;
            }
            Integer prevId = this.wholeStrings.get(text);
            if (prevId != null) {
                return prevId;
            }
            int stringId = this.objectCounter.next();
            this.whole.writeByte(1);
            this.whole.writeInt(0);
            byte[] utf8 = text.getBytes(StandardCharsets.UTF_8);
            this.whole.writeInt(this.ids.sizeOf() + utf8.length);
            this.ids.writeID(this.whole, stringId);
            this.whole.write(utf8);
            this.wholeStrings.put(text, stringId);
            return stringId;
        }
    }

    public final class ClassInstance {
        private final int serialId;
        private final int id;
        private final int fieldBytes;
        private final TreeMap<String, Class<?>> fieldNamesAndTypes;

        private ClassInstance(int serialId, int id, TreeMap<String, Class<?>> fieldNamesAndTypes, int fieldBytes) {
            this.serialId = serialId;
            this.id = id;
            this.fieldBytes = fieldBytes;
            this.fieldNamesAndTypes = fieldNamesAndTypes;
        }

        public NavigableSet<String> names() {
            return Collections.unmodifiableNavigableSet(this.fieldNamesAndTypes.navigableKeySet());
        }

        int id(HeapDump requestor) {
            if (requestor != HeapDump.this) {
                throw new IllegalStateException();
            }
            return this.id;
        }

        int serialId(HeapDump requestor) {
            if (requestor != HeapDump.this) {
                throw new IllegalStateException();
            }
            return this.serialId;
        }
    }

    public final class ClassBuilder {
        private final String className;
        private final int superId;
        private TreeMap<String, Class<?>> fieldNamesAndTypes = new TreeMap();

        private ClassBuilder(String name, int superId) {
            this.className = name;
            this.superId = superId;
        }

        public ClassBuilder field(String name, Class<?> type) {
            if (type.isPrimitive()) {
                this.fieldNamesAndTypes.put(name, type);
            } else {
                this.fieldNamesAndTypes.put(name, Object.class);
            }
            return this;
        }

        public ClassBuilder field(String name, ClassInstance type) {
            this.fieldNamesAndTypes.put(name, Object.class);
            return this;
        }

        public ClassInstance dumpClass() throws UncheckedIOException {
            try {
                return this.dumpClassImpl();
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        private ClassInstance dumpClassImpl() throws IOException {
            int classSerialId = HeapDump.this.builder.classCounter.next();
            int classId = HeapDump.this.builder.writeLoadClass(this.className, classSerialId);
            HeapDump.this.heap.writeByte(32);
            HeapDump.this.builder.ids.writeID(HeapDump.this.heap, classId);
            HeapDump.this.builder.writeDefaultStackTraceSerialNumber(HeapDump.this.heap);
            HeapDump.this.builder.ids.writeID(HeapDump.this.heap, this.superId);
            HeapDump.this.builder.ids.writeID(HeapDump.this.heap, 0L);
            HeapDump.this.builder.ids.writeID(HeapDump.this.heap, 0L);
            HeapDump.this.builder.ids.writeID(HeapDump.this.heap, 0L);
            HeapDump.this.builder.ids.writeID(HeapDump.this.heap, 0L);
            HeapDump.this.builder.ids.writeID(HeapDump.this.heap, 0L);
            int instanceSize = 0;
            for (Map.Entry<String, Class<?>> entry : this.fieldNamesAndTypes.entrySet()) {
                Class<?> type = entry.getValue();
                instanceSize += HeapDump.switchOnType(type, HeapDump.this.builder.ids)[1];
            }
            HeapDump.this.heap.writeInt(instanceSize);
            HeapDump.this.heap.writeShort(0);
            HeapDump.this.heap.writeShort(0);
            HeapDump.this.heap.writeShort(this.fieldNamesAndTypes.size());
            for (Map.Entry<String, Class<?>> entry : this.fieldNamesAndTypes.entrySet()) {
                int nId = HeapDump.this.builder.writeString(entry.getKey());
                HeapDump.this.heap.writeInt(nId);
                Class<?> type = entry.getValue();
                HeapDump.this.heap.writeByte(HeapDump.switchOnType(type, HeapDump.this.builder.ids)[0]);
            }
            ClassInstance inst = new ClassInstance(classSerialId, classId, this.fieldNamesAndTypes, instanceSize);
            this.fieldNamesAndTypes = new TreeMap();
            return inst;
        }
    }

    private static final class Identifiers
    extends Enum<Identifiers> {
        public static final /* enum */ Identifiers FOUR = new Identifiers();
        public static final /* enum */ Identifiers EIGHT = new Identifiers();
        private static final /* synthetic */ Identifiers[] $VALUES;

        public static Identifiers[] values() {
            return (Identifiers[])$VALUES.clone();
        }

        public static Identifiers valueOf(String name) {
            return Enum.valueOf(Identifiers.class, name);
        }

        int sizeOf() {
            return this == FOUR ? 4 : 8;
        }

        void writeID(DataOutputStream os, long id) throws IOException {
            if (this == FOUR) {
                int intId = (int)id;
                assert ((long)intId == id);
                os.writeInt(intId);
            } else {
                os.writeLong(id);
            }
        }

        private static /* synthetic */ Identifiers[] $values() {
            return new Identifiers[]{FOUR, EIGHT};
        }

        static {
            $VALUES = Identifiers.$values();
        }
    }

    public final class ThreadBuilder {
        private final List<Object[]> stacks = new ArrayList<Object[]>();
        private final String name;

        private ThreadBuilder(String name) {
            this.name = name;
        }

        public ThreadBuilder addStackFrame(ClassInstance clazz, String methodName, String sourceFile, int lineNumber, ObjectInstance ... locals) {
            this.stacks.add(new Object[]{methodName, sourceFile, lineNumber, locals, clazz});
            return this;
        }

        public ObjectInstance dumpThread() throws UncheckedIOException {
            try {
                return this.dumpThreadImpl();
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        private ObjectInstance dumpThreadImpl() throws IOException {
            ObjectInstance nameId = HeapDump.this.dumpString(this.name);
            int threadSerialId = HeapDump.this.builder.threadCounter.next();
            ObjectInstance threadId = HeapDump.this.newInstance(HeapDump.this.typeThread).putBoolean("daemon", false).put("name", nameId).putInt("priority", 0).dumpInstance();
            int[] frameIds = new int[this.stacks.size()];
            int cnt = 0;
            for (Object[] frame : this.stacks) {
                ClassInstance language = (ClassInstance)frame[4];
                String rootName = (String)frame[0];
                String sourceFile = (String)frame[1];
                int lineNumber = (Integer)frame[2];
                frameIds[cnt++] = HeapDump.this.builder.writeStackFrame(HeapDump.this, language, rootName, sourceFile, lineNumber);
            }
            int stackTraceId = HeapDump.this.builder.writeStackTrace(threadSerialId, frameIds);
            HeapDump.this.heap.writeByte(8);
            HeapDump.this.builder.ids.writeID(HeapDump.this.heap, threadId.id(HeapDump.this));
            HeapDump.this.heap.writeInt(threadSerialId);
            HeapDump.this.heap.writeInt(stackTraceId);
            cnt = 0;
            for (Object[] frame : this.stacks) {
                ObjectInstance[] localObjects = (ObjectInstance[])frame[3];
                for (int i = 0; i < localObjects.length; ++i) {
                    int objId = localObjects[i].id(HeapDump.this);
                    HeapDump.this.heap.writeByte(3);
                    HeapDump.this.builder.ids.writeID(HeapDump.this.heap, objId);
                    HeapDump.this.heap.writeInt(threadSerialId);
                    HeapDump.this.heap.writeInt(cnt);
                }
                ++cnt;
            }
            return threadId;
        }
    }

    public final class InstanceBuilder {
        private final ClassInstance clazz;
        private final ObjectInstance instanceId;
        private final List<Object> namesAndValues = new ArrayList<Object>();

        private InstanceBuilder(ClassInstance clazz, int instanceId) {
            this.clazz = clazz;
            this.instanceId = new ObjectInstance(instanceId);
        }

        public InstanceBuilder put(String name, ObjectInstance value) {
            this.assertType(name, value.getClass());
            return this.putImpl(name, value.id(HeapDump.this));
        }

        public InstanceBuilder putByte(String name, byte value) {
            this.assertType(name, Byte.TYPE);
            return this.putImpl(name, value);
        }

        public InstanceBuilder putShort(String name, short value) {
            this.assertType(name, Short.TYPE);
            return this.putImpl(name, value);
        }

        public InstanceBuilder putInt(String name, int value) {
            this.assertType(name, Integer.TYPE);
            return this.putImpl(name, value);
        }

        public InstanceBuilder putLong(String name, long value) {
            this.assertType(name, Long.TYPE);
            return this.putImpl(name, value);
        }

        public InstanceBuilder putFloat(String name, float value) {
            this.assertType(name, Float.TYPE);
            return this.putImpl(name, Float.valueOf(value));
        }

        public InstanceBuilder putDouble(String name, double value) {
            this.assertType(name, Double.TYPE);
            return this.putImpl(name, value);
        }

        public InstanceBuilder putBoolean(String name, boolean value) {
            this.assertType(name, Boolean.TYPE);
            return this.putImpl(name, value);
        }

        public InstanceBuilder putChar(String name, char value) {
            this.assertType(name, Character.TYPE);
            return this.putImpl(name, Character.valueOf(value));
        }

        private void assertType(String name, Class<?> valueType) throws IllegalArgumentException {
            Class<?> type = this.clazz.fieldNamesAndTypes.get(name);
            if (type == null) {
                throw new IllegalArgumentException("Unknown field '" + name + "'");
            }
            if (!type.isAssignableFrom(valueType)) {
                throw new IllegalArgumentException("Wrong type for field '" + name + "'");
            }
        }

        InstanceBuilder putImpl(String name, Object value) {
            this.namesAndValues.add(name);
            this.namesAndValues.add(value);
            return this;
        }

        public ObjectInstance dumpInstance() throws UncheckedIOException {
            try {
                this.dumpInstance(HeapDump.this, this.namesAndValues.toArray());
                return this.instanceId;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        public ObjectInstance id() {
            return this.instanceId;
        }

        private void dumpInstance(HeapDump thiz, Object ... stringValueSeq) throws IOException {
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (int i = 0; i < stringValueSeq.length; i += 2) {
                values.put((String)stringValueSeq[i], stringValueSeq[i + 1]);
            }
            HeapDump.this.heap.writeByte(33);
            HeapDump.this.builder.ids.writeID(HeapDump.this.heap, this.instanceId.id(thiz));
            HeapDump.this.builder.writeDefaultStackTraceSerialNumber(HeapDump.this.heap);
            HeapDump.this.builder.ids.writeID(HeapDump.this.heap, this.clazz.id(thiz));
            HeapDump.this.heap.writeInt(this.clazz.fieldBytes);
            for (Map.Entry<String, Class<?>> entry : this.clazz.fieldNamesAndTypes.entrySet()) {
                Class<?> type = entry.getValue();
                Object ref = values.get(entry.getKey());
                if (type == Boolean.TYPE || type == Byte.TYPE) {
                    byte n = ref instanceof Number ? ((Number)ref).byteValue() : (ref instanceof Boolean ? ((Boolean)ref != false ? (byte)1 : 0) : (byte)0);
                    HeapDump.this.heap.writeByte(n);
                    continue;
                }
                if (entry.getValue() == Integer.TYPE) {
                    HeapDump.this.heap.writeInt(ref == null ? 0 : ((Number)ref).intValue());
                    continue;
                }
                if (entry.getValue() == Short.TYPE) {
                    HeapDump.this.heap.writeShort(ref == null ? 0 : (int)((Number)ref).shortValue());
                    continue;
                }
                if (entry.getValue() == Long.TYPE) {
                    HeapDump.this.heap.writeLong(ref == null ? 0L : ((Number)ref).longValue());
                    continue;
                }
                if (entry.getValue() == Float.TYPE) {
                    HeapDump.this.heap.writeFloat(ref == null ? 0.0f : ((Number)ref).floatValue());
                    continue;
                }
                if (entry.getValue() == Double.TYPE) {
                    HeapDump.this.heap.writeDouble(ref == null ? 0.0 : ((Number)ref).doubleValue());
                    continue;
                }
                if (entry.getValue() == Character.TYPE) {
                    HeapDump.this.heap.writeChar(ref == null ? 0 : (int)((Character)ref).charValue());
                    continue;
                }
                HeapDump.this.builder.ids.writeID(HeapDump.this.heap, ref == null ? 0L : (long)((Number)ref).intValue());
            }
        }
    }

    private static final class Counter {
        private final String name;
        private int value;

        Counter(String name) {
            this.name = name;
        }

        int next() throws IOException {
            if (this.value == Integer.MAX_VALUE) {
                throw new IOException("Overflow of " + this.name + "counter");
            }
            return ++this.value;
        }
    }

    public final class ArrayBuilder {
        private final ClassInstance clazz;
        private final ObjectInstance instanceId;
        private final List<ObjectInstance> elements;

        private ArrayBuilder(ClassInstance clazz, int length, int instanceId) {
            this.clazz = clazz;
            this.elements = Arrays.asList(new ObjectInstance[length]);
            this.instanceId = new ObjectInstance(instanceId);
        }

        public ArrayBuilder put(int index, ObjectInstance value) {
            this.elements.set(index, value);
            return this;
        }

        public ObjectInstance dumpInstance() throws UncheckedIOException {
            try {
                this.dumpArray(HeapDump.this);
                return this.instanceId;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        public ObjectInstance id() {
            return this.instanceId;
        }

        private void dumpArray(HeapDump thiz) throws IOException {
            HeapDump.this.heap.writeByte(34);
            HeapDump.this.builder.ids.writeID(HeapDump.this.heap, this.instanceId.id(thiz));
            HeapDump.this.builder.writeDefaultStackTraceSerialNumber(HeapDump.this.heap);
            HeapDump.this.heap.writeInt(this.elements.size());
            HeapDump.this.builder.ids.writeID(HeapDump.this.heap, this.clazz.id(thiz));
            for (ObjectInstance ref : this.elements) {
                HeapDump.this.builder.ids.writeID(HeapDump.this.heap, ref == null ? 0L : (long)ref.id(thiz));
            }
        }
    }

    public final class ObjectInstance {
        private final int id;

        ObjectInstance(int id) {
            this.id = id;
        }

        public int hashCode() {
            int hash = 3;
            hash = 79 * hash + this.id;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ObjectInstance other = (ObjectInstance)obj;
            return this.id == other.id;
        }

        int id(HeapDump requestor) {
            if (requestor != HeapDump.this) {
                throw new IllegalStateException();
            }
            return this.id;
        }
    }
}

