/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.org.jline;

import com.oracle.svm.core.jdk.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;

public final class JLine3Feature
implements Feature {
    public static final String TERMINAL_BUILDER = "org.graalvm.shadowed.org.jline.terminal.TerminalBuilder";
    private static final String JLINE_UTILS_RESOURCE_PATH = "org/graalvm/shadowed/org/jline/utils/";
    private static final List<String> JLINE_UTILS_RESOURCES = Arrays.asList("capabilities.txt", "colors.txt", "ansi.caps", "dumb.caps", "dumb-color.caps", "screen.caps", "screen-256color.caps", "windows.caps", "windows-256color.caps", "windows-conemu.caps", "windows-vtp.caps", "xterm.caps", "xterm-256color.caps");
    private static final String JLINE_BUILTINS_RESOURCE_PATH = "org/graalvm/shadowed/org/jline/builtins/";
    private static final List<String> JLINE_BUILTINS_RESOURCES = Arrays.asList("less-help.txt", "nano-browser-help.txt", "nano-goto-help.txt", "nano-main-help.txt", "nano-read-help.txt", "nano-replace-help.txt", "nano-search-help.txt", "nano-search-replace-help.txt", "nano-write-help.txt");
    private static final List<String> RUNTIME_INIT_CLASS_NAMES = Arrays.asList("org.graalvm.shadowed.org.jline.utils.AttributedCharSequence", "org.graalvm.shadowed.org.jline.utils.OSUtils");

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return access.findClassByName(TERMINAL_BUILDER) != null;
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        RUNTIME_INIT_CLASS_NAMES.stream().map(arg_0 -> ((Feature.DuringSetupAccess)access).findClassByName(arg_0)).filter(Objects::nonNull).forEach(xva$0 -> RuntimeClassInitialization.initializeAtRunTime((Class[])new Class[]{xva$0}));
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Stream.concat(JLINE_UTILS_RESOURCES.stream().map(x -> JLINE_UTILS_RESOURCE_PATH + x), JLINE_BUILTINS_RESOURCES.stream().map(x -> JLINE_BUILTINS_RESOURCE_PATH + x)).forEach(JLine3Feature::registerResource);
    }

    private static void registerResource(String resourcePath) {
        try (InputStream resourceAsStream = ClassLoader.getSystemResourceAsStream(resourcePath);){
            Resources.registerResource((String)resourcePath, (InputStream)resourceAsStream);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

