/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import com.oracle.svm.configure.config.ConfigurationMemberInfo;
import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.configure.trace.AbstractProcessor;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.LazyValueUtils;
import java.util.List;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.phases.common.LazyValue;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

class JniProcessor
extends AbstractProcessor {
    private final AccessAdvisor advisor;

    JniProcessor(AccessAdvisor advisor) {
        this.advisor = advisor;
    }

    @Override
    void processEntry(EconomicMap<String, ?> entry, ConfigurationSet configurationSet) {
        ConfigurationCondition condition = ConfigurationCondition.alwaysTrue();
        boolean invalidResult = Boolean.FALSE.equals(entry.get((Object)"result"));
        if (invalidResult) {
            return;
        }
        String function = (String)entry.get((Object)"function");
        String callerClass = (String)entry.get((Object)"caller_class");
        List args = (List)entry.get((Object)"args");
        LazyValue<String> callerClassLazyValue = LazyValueUtils.lazyValue(callerClass);
        if (function.equals("FindClass") || function.equals("DefineClass")) {
            String lookupName = (String)JniProcessor.singleElement(args);
            Object internalName = lookupName.charAt(0) != '[' ? "L" + lookupName + ";" : lookupName;
            String forNameString = MetaUtil.internalNameToJava((String)internalName, (boolean)true, (boolean)true);
            if (!this.advisor.shouldIgnore(LazyValueUtils.lazyValue(forNameString), callerClassLazyValue)) {
                if (function.equals("FindClass")) {
                    configurationSet.getJniConfiguration().getOrCreateType(condition, forNameString);
                } else if (!AccessAdvisor.PROXY_CLASS_NAME_PATTERN.matcher(lookupName).matches()) {
                    JniProcessor.logWarning("Unsupported JNI function DefineClass used to load class " + forNameString);
                }
            }
            return;
        }
        String clazz = (String)entry.get((Object)"class");
        if (this.advisor.shouldIgnore(LazyValueUtils.lazyValue(clazz), callerClassLazyValue)) {
            return;
        }
        String declaringClass = (String)entry.get((Object)"declaring_class");
        String declaringClassOrClazz = declaringClass != null ? declaringClass : clazz;
        ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration = declaringClass != null ? ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED : ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT;
        TypeConfiguration config = configurationSet.getJniConfiguration();
        switch (function) {
            case "GetStaticMethodID": 
            case "GetMethodID": {
                JniProcessor.expectSize(args, 2);
                String name = (String)args.get(0);
                String signature = (String)args.get(1);
                if (this.advisor.shouldIgnoreJniMethodLookup(LazyValueUtils.lazyValue(clazz), LazyValueUtils.lazyValue(name), LazyValueUtils.lazyValue(signature), callerClassLazyValue)) break;
                config.getOrCreateType(condition, declaringClassOrClazz).addMethod(name, signature, declaration);
                if (declaringClassOrClazz.equals(clazz)) break;
                config.getOrCreateType(condition, clazz);
                break;
            }
            case "GetFieldID": 
            case "GetStaticFieldID": {
                JniProcessor.expectSize(args, 2);
                String name = (String)args.get(0);
                config.getOrCreateType(condition, declaringClassOrClazz).addField(name, declaration, false);
                if (declaringClassOrClazz.equals(clazz)) break;
                config.getOrCreateType(condition, clazz);
                break;
            }
            case "ThrowNew": {
                JniProcessor.expectSize(args, 1);
                String name = "<init>";
                String signature = "(Ljava/lang/String;)V";
                if (this.advisor.shouldIgnoreJniMethodLookup(LazyValueUtils.lazyValue(clazz), LazyValueUtils.lazyValue(name), LazyValueUtils.lazyValue(signature), callerClassLazyValue)) break;
                config.getOrCreateType(condition, declaringClassOrClazz).addMethod(name, signature, declaration);
                assert (declaringClassOrClazz.equals(clazz)) : "Constructor can only be accessed via declaring class";
                break;
            }
            case "ToReflectedField": {
                config = configurationSet.getReflectionConfiguration();
            }
            case "FromReflectedField": {
                JniProcessor.expectSize(args, 1);
                String name = (String)args.get(0);
                config.getOrCreateType(condition, declaringClassOrClazz).addField(name, declaration, false);
                break;
            }
            case "ToReflectedMethod": {
                config = configurationSet.getReflectionConfiguration();
            }
            case "FromReflectedMethod": {
                JniProcessor.expectSize(args, 2);
                String name = (String)args.get(0);
                String signature = (String)args.get(1);
                config.getOrCreateType(condition, declaringClassOrClazz).addMethod(name, signature, declaration);
                break;
            }
            case "NewObjectArray": {
                JniProcessor.expectSize(args, 0);
                config.getOrCreateType(condition, clazz);
            }
        }
    }
}

