/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.config.PredefinedClassesConfiguration;
import com.oracle.svm.configure.config.ProxyConfiguration;
import com.oracle.svm.configure.config.ResourceConfiguration;
import com.oracle.svm.configure.config.SerializationConfiguration;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationParser;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class ConfigurationFileCollection {
    public static final Function<IOException, Exception> FAIL_ON_EXCEPTION = e -> e;
    private final Set<URI> jniConfigPaths = new LinkedHashSet<URI>();
    private final Set<URI> reflectConfigPaths = new LinkedHashSet<URI>();
    private final Set<URI> proxyConfigPaths = new LinkedHashSet<URI>();
    private final Set<URI> resourceConfigPaths = new LinkedHashSet<URI>();
    private final Set<URI> serializationConfigPaths = new LinkedHashSet<URI>();
    private final Set<URI> predefinedClassesConfigPaths = new LinkedHashSet<URI>();
    private Set<URI> lockFilePaths;

    public void addDirectory(Path path) {
        this.jniConfigPaths.add(path.resolve(ConfigurationFile.JNI.getFileName()).toUri());
        this.reflectConfigPaths.add(path.resolve(ConfigurationFile.REFLECTION.getFileName()).toUri());
        this.proxyConfigPaths.add(path.resolve(ConfigurationFile.DYNAMIC_PROXY.getFileName()).toUri());
        this.resourceConfigPaths.add(path.resolve(ConfigurationFile.RESOURCES.getFileName()).toUri());
        this.serializationConfigPaths.add(path.resolve(ConfigurationFile.SERIALIZATION.getFileName()).toUri());
        this.predefinedClassesConfigPaths.add(path.resolve(ConfigurationFile.PREDEFINED_CLASSES_NAME.getFileName()).toUri());
        this.detectAgentLock(path.resolve(".lock"), x$0 -> Files.exists(x$0, new LinkOption[0]), Path::toUri);
    }

    private <T> void detectAgentLock(T location, Predicate<T> exists, Function<T, URI> toUri) {
        if (exists.test(location)) {
            if (this.lockFilePaths == null) {
                this.lockFilePaths = new LinkedHashSet<URI>();
            }
            this.lockFilePaths.add(toUri.apply(location));
        }
    }

    public void addDirectory(Function<String, URI> fileResolver) {
        this.jniConfigPaths.add(fileResolver.apply(ConfigurationFile.JNI.getFileName()));
        this.reflectConfigPaths.add(fileResolver.apply(ConfigurationFile.REFLECTION.getFileName()));
        this.proxyConfigPaths.add(fileResolver.apply(ConfigurationFile.DYNAMIC_PROXY.getFileName()));
        this.resourceConfigPaths.add(fileResolver.apply(ConfigurationFile.RESOURCES.getFileName()));
        this.serializationConfigPaths.add(fileResolver.apply(ConfigurationFile.SERIALIZATION.getFileName()));
        this.predefinedClassesConfigPaths.add(fileResolver.apply(ConfigurationFile.PREDEFINED_CLASSES_NAME.getFileName()));
        this.detectAgentLock(fileResolver.apply(".lock"), Objects::nonNull, Function.identity());
    }

    public Set<URI> getDetectedAgentLockPaths() {
        return this.lockFilePaths != null ? this.lockFilePaths : Collections.emptySet();
    }

    public boolean isEmpty() {
        return this.jniConfigPaths.isEmpty() && this.reflectConfigPaths.isEmpty() && this.proxyConfigPaths.isEmpty() && this.resourceConfigPaths.isEmpty() && this.serializationConfigPaths.isEmpty() && this.predefinedClassesConfigPaths.isEmpty();
    }

    public Set<URI> getJniConfigPaths() {
        return this.jniConfigPaths;
    }

    public Set<URI> getReflectConfigPaths() {
        return this.reflectConfigPaths;
    }

    public Set<URI> getProxyConfigPaths() {
        return this.proxyConfigPaths;
    }

    public Set<URI> getResourceConfigPaths() {
        return this.resourceConfigPaths;
    }

    public Set<URI> getSerializationConfigPaths() {
        return this.serializationConfigPaths;
    }

    public Set<URI> getPredefinedClassesConfigPaths() {
        return this.predefinedClassesConfigPaths;
    }

    public TypeConfiguration loadJniConfig(Function<IOException, Exception> exceptionHandler) throws Exception {
        return ConfigurationFileCollection.loadTypeConfig(this.jniConfigPaths, exceptionHandler);
    }

    public TypeConfiguration loadReflectConfig(Function<IOException, Exception> exceptionHandler) throws Exception {
        return ConfigurationFileCollection.loadTypeConfig(this.reflectConfigPaths, exceptionHandler);
    }

    public ProxyConfiguration loadProxyConfig(Function<IOException, Exception> exceptionHandler) throws Exception {
        ProxyConfiguration proxyConfiguration = new ProxyConfiguration();
        ConfigurationFileCollection.loadConfig(this.proxyConfigPaths, proxyConfiguration.createParser(), exceptionHandler);
        return proxyConfiguration;
    }

    public PredefinedClassesConfiguration loadPredefinedClassesConfig(Path[] classDestinationDirs, Predicate<String> shouldExcludeClassesWithHash, Function<IOException, Exception> exceptionHandler) throws Exception {
        PredefinedClassesConfiguration predefinedClassesConfiguration = new PredefinedClassesConfiguration(classDestinationDirs, shouldExcludeClassesWithHash);
        ConfigurationFileCollection.loadConfig(this.predefinedClassesConfigPaths, predefinedClassesConfiguration.createParser(), exceptionHandler);
        return predefinedClassesConfiguration;
    }

    public ResourceConfiguration loadResourceConfig(Function<IOException, Exception> exceptionHandler) throws Exception {
        ResourceConfiguration resourceConfiguration = new ResourceConfiguration();
        ConfigurationFileCollection.loadConfig(this.resourceConfigPaths, resourceConfiguration.createParser(), exceptionHandler);
        return resourceConfiguration;
    }

    public SerializationConfiguration loadSerializationConfig(Function<IOException, Exception> exceptionHandler) throws Exception {
        SerializationConfiguration serializationConfiguration = new SerializationConfiguration();
        ConfigurationFileCollection.loadConfig(this.serializationConfigPaths, serializationConfiguration.createParser(), exceptionHandler);
        return serializationConfiguration;
    }

    public ConfigurationSet loadConfigurationSet(Function<IOException, Exception> exceptionHandler, Path[] predefinedConfigClassDestinationDirs, Predicate<String> predefinedConfigClassWithHashExclusionPredicate) throws Exception {
        return new ConfigurationSet(this.loadReflectConfig(exceptionHandler), this.loadJniConfig(exceptionHandler), this.loadResourceConfig(exceptionHandler), this.loadProxyConfig(exceptionHandler), this.loadSerializationConfig(exceptionHandler), this.loadPredefinedClassesConfig(predefinedConfigClassDestinationDirs, predefinedConfigClassWithHashExclusionPredicate, exceptionHandler));
    }

    private static TypeConfiguration loadTypeConfig(Collection<URI> uris, Function<IOException, Exception> exceptionHandler) throws Exception {
        TypeConfiguration configuration = new TypeConfiguration();
        ConfigurationFileCollection.loadConfig(uris, configuration.createParser(), exceptionHandler);
        return configuration;
    }

    private static void loadConfig(Collection<URI> configPaths, ConfigurationParser configurationParser, Function<IOException, Exception> exceptionHandler) throws Exception {
        for (URI uri : configPaths) {
            try {
                configurationParser.parseAndRegister(uri);
            }
            catch (IOException ioe) {
                Exception e = ioe;
                if (exceptionHandler != null) {
                    e = exceptionHandler.apply(ioe);
                }
                if (e == null) continue;
                throw e;
            }
        }
    }
}

