/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graalvm.component.installer.yum;

import com.oracle.graalvm.component.installer.yum.PackageListReader;
import com.oracle.graalvm.component.installer.yum.RepositoryDownloader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.SoftwareChannel;
import org.graalvm.component.installer.SoftwareChannelSource;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentStorage;
import org.graalvm.component.installer.remote.FileDownloader;

public class YumSoftwareChannel
implements SoftwareChannel,
ComponentStorage {
    private final SoftwareChannelSource source;
    private final URL repositoryURL;
    private final CommandInput input;
    private final Feedback feedback;
    private boolean verifyJars = true;
    private Set<String> componentIDs;
    private Map<String, Collection<ComponentInfo>> components;

    public YumSoftwareChannel(SoftwareChannelSource source, URL repositoryURL, CommandInput input, Feedback feedback) {
        this.source = source;
        this.repositoryURL = repositoryURL;
        this.input = input;
        this.feedback = feedback.withBundle(YumSoftwareChannel.class);
    }

    public boolean isVerifyJars() {
        return this.verifyJars;
    }

    public void setVerifyJars(boolean verifyJars) {
        this.verifyJars = verifyJars;
    }

    public ComponentStorage getStorage() throws IOException {
        this.init();
        return this;
    }

    private void init() throws IOException {
        List<ComponentInfo> infos;
        if (this.componentIDs != null) {
            return;
        }
        try (RepositoryDownloader downloader = new RepositoryDownloader(this.repositoryURL, this.source, this, this.feedback);){
            downloader.setVerifyChecksum(this.verifyJars);
            downloader.download();
            try (InputStream primaryContents = downloader.getPrimaryInputStream();){
                PackageListReader reader = new PackageListReader(this.source, this.repositoryURL, primaryContents, this.feedback);
                infos = reader.build();
            }
        }
        this.componentIDs = new HashSet<String>();
        this.components = new HashMap<String, Collection<ComponentInfo>>();
        for (ComponentInfo ci : infos) {
            String os = (String)ci.getRequiredGraalValues().get("os_name");
            String arch = (String)ci.getRequiredGraalValues().get("os_arch");
            if (os != null && !os.equalsIgnoreCase((String)this.input.getLocalRegistry().getGraalCapabilities().get("os_name")) || arch != null && !arch.equalsIgnoreCase((String)this.input.getLocalRegistry().getGraalCapabilities().get("os_arch"))) continue;
            this.componentIDs.add(ci.getId());
            this.components.computeIfAbsent(ci.getId(), k -> new HashSet()).add(ci);
        }
    }

    public Set<String> listComponentIDs() throws IOException {
        this.init();
        return new HashSet<String>(this.componentIDs);
    }

    public ComponentInfo loadComponentFiles(ComponentInfo ci) throws IOException {
        this.init();
        return ci;
    }

    public Set<ComponentInfo> loadComponentMetadata(String id) throws IOException {
        this.init();
        return new HashSet<ComponentInfo>(this.components.get(id));
    }

    public Map<String, String> loadGraalVersionInfo() {
        return this.input.getLocalRegistry().getGraalCapabilities();
    }

    public FileDownloader configureDownloader(ComponentInfo info, FileDownloader dn) {
        return dn;
    }
}

