/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graalvm.component.installer.yum;

import com.oracle.graalvm.component.installer.yum.YumSoftwareChannel;
import java.net.MalformedURLException;
import java.net.URL;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.SoftwareChannel;
import org.graalvm.component.installer.SoftwareChannelSource;
import org.graalvm.component.installer.SystemUtils;

public class YumChannelFactory
implements SoftwareChannel.Factory {
    private static final String PROTOCOL_YUM_PREFIX = "yum:";
    private static final String PROTOCOL_HTTTPS_PREFIX = "https:";

    public SoftwareChannel createChannel(SoftwareChannelSource source, CommandInput input, Feedback output) {
        URL u;
        String urlString = source.getLocationURL();
        if (!urlString.startsWith(PROTOCOL_YUM_PREFIX)) {
            return null;
        }
        boolean verify = input.optValue("s") == null;
        Object rest = urlString.substring(PROTOCOL_YUM_PREFIX.length());
        if (!((String)rest).endsWith("/")) {
            rest = (String)rest + "/";
        }
        try {
            u = ((String)rest).startsWith("http:") || ((String)rest).startsWith("file:") || ((String)rest).startsWith("test:") ? SystemUtils.toURL((String)rest) : SystemUtils.toURL((String)(PROTOCOL_HTTTPS_PREFIX + (String)rest));
        }
        catch (MalformedURLException ex) {
            throw output.failure("YUM_InvalidLocation", (Throwable)ex, new Object[]{urlString, ex.getLocalizedMessage()});
        }
        YumSoftwareChannel ch = new YumSoftwareChannel(source, u, input, output);
        ch.setVerifyJars(verify);
        return ch;
    }

    public void init(CommandInput in, Feedback out) {
    }
}

