/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graalvm.component.installer.yum;

import com.oracle.graalvm.component.installer.uln.RpcUtils;
import com.oracle.graalvm.component.installer.util.XmlUtil;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.SoftwareChannel;
import org.graalvm.component.installer.SoftwareChannelSource;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.remote.FileDownloader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RepositoryDownloader
implements AutoCloseable {
    private final SoftwareChannelSource sourceSpec;
    private final URL repositoryURL;
    private final Feedback feedback;
    private final SoftwareChannel channel;
    private Path primaryFile;
    private Path checksumFile;
    private URL primaryFileURL;
    private String primaryDigestString;
    private String primaryOpenedDigestString;
    private boolean compressedFile;
    private boolean verifyChecksum = true;
    private static final String PATH_REPOMD_XML = "repodata/repomd.xml";

    public RepositoryDownloader(URL url, SoftwareChannelSource sspec, SoftwareChannel ch, Feedback fb) {
        this.channel = ch;
        this.repositoryURL = url;
        this.sourceSpec = sspec;
        this.feedback = fb.withBundle(RepositoryDownloader.class);
    }

    public boolean isVerifyChecksum() {
        return this.verifyChecksum;
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
        this.verifyChecksum = verifyChecksum;
    }

    public Path download() throws IOException {
        Path chk = this.downloadChecksumFile();
        URL url = this.findPrimaryFileInfo(this.parseRepomd(chk));
        return this.downloadPrimaryFile(url);
    }

    public SoftwareChannelSource getSourceSpec() {
        return this.sourceSpec;
    }

    public String getPrimaryDigestString() {
        return this.primaryDigestString;
    }

    public String getPrimaryOpenedDigestString() {
        return this.primaryOpenedDigestString;
    }

    public URL getRepositoryURL() {
        return this.repositoryURL;
    }

    public Path getPrimaryFile() {
        return this.primaryFile;
    }

    public Path getChecksumFile() {
        return this.checksumFile;
    }

    public URL getPrimaryFileURL() {
        return this.primaryFileURL;
    }

    public boolean isCompressedFile() {
        return this.compressedFile;
    }

    Document parseRepomd(Path file) throws IOException {
        Document document;
        block8: {
            DocumentBuilderFactory dbf = XmlUtil.configureBuilderFactory(this.feedback);
            InputStream fis = Files.newInputStream(file, new OpenOption[0]);
            try {
                Document doc;
                DocumentBuilder bld = XmlUtil.newDocumentBuilder(dbf);
                document = doc = bld.parse(fis);
                if (fis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParserConfigurationException | SAXException ex) {
                    throw new IOException(ex);
                }
            }
            fis.close();
        }
        return document;
    }

    URL findPrimaryFileInfo(Document doc) throws MalformedURLException {
        Node att;
        Node primaryNode = RpcUtils.findPath(doc, "data[@type=\"primary\"]");
        if (primaryNode == null) {
            throw this.feedback.failure("YUM_MissingPrimaryXmlEntry", null, new Object[0]);
        }
        Node sha256 = RpcUtils.findPath(primaryNode, "checksum[@type=\"sha256\"]");
        Node openSha256 = RpcUtils.findPath(primaryNode, "open-checksum[@type=\"sha256\"]");
        boolean comp = false;
        if (sha256 != null) {
            this.primaryDigestString = sha256.getTextContent().trim();
            comp = true;
        }
        if (openSha256 != null) {
            this.primaryOpenedDigestString = openSha256.getTextContent().trim();
        }
        if (this.primaryDigestString == null && this.primaryOpenedDigestString == null) {
            throw this.feedback.failure("YUM_RefusePrimaryNoDigest", null, new Object[0]);
        }
        Node loc = RpcUtils.findPath(primaryNode, "location");
        if (loc != null && (att = loc.getAttributes().getNamedItem("href")) != null) {
            String relativePath = att.getTextContent();
            this.compressedFile = comp || relativePath.endsWith(".gz");
            this.primaryFileURL = SystemUtils.toURL((URL)this.repositoryURL, (String)relativePath);
        }
        if (this.primaryFileURL == null) {
            throw this.feedback.failure("YUM_MissingPrimaryXmlUrl", null, new Object[]{this.sourceSpec.getLabel()});
        }
        return this.primaryFileURL;
    }

    Path downloadChecksumFile() throws IOException {
        if (this.checksumFile != null) {
            return this.checksumFile;
        }
        URL u = SystemUtils.toURL((URL)this.repositoryURL, (String)PATH_REPOMD_XML);
        try {
            FileDownloader dn = new FileDownloader(this.feedback.l10n("DOWNLOAD_DownloadChecksums", new Object[0]), u, this.feedback);
            this.channel.configureDownloader(null, dn);
            dn.download();
            this.checksumFile = dn.getLocalFile().toPath();
            return this.checksumFile;
        }
        catch (IOException ex) {
            throw this.feedback.failure("DOWNLOAD_CannotDownloadChecksum", (Throwable)ex, new Object[]{u, ex.getLocalizedMessage()});
        }
    }

    Path downloadPrimaryFile(URL primaryURL) throws IOException {
        if (this.primaryFile != null) {
            return this.primaryFile;
        }
        FileDownloader dn = new FileDownloader(this.feedback.l10n("YUM_DownloadPackageInfo", new Object[0]), primaryURL, this.feedback);
        this.channel.configureDownloader(null, dn);
        String digestString = null;
        if (this.primaryDigestString != null && this.compressedFile) {
            digestString = this.primaryDigestString;
        }
        if (this.primaryOpenedDigestString != null && !this.compressedFile) {
            digestString = this.primaryOpenedDigestString;
        }
        if (this.verifyChecksum && digestString != null) {
            byte[] bytes = SystemUtils.toHashBytes((String)digestString);
            if (bytes == null) {
                throw this.feedback.failure("YUM_InvalidSha256Hash", null, new Object[]{this.primaryDigestString});
            }
            dn.setDigestAlgorithm("SHA-256");
            dn.setShaDigest(bytes);
        }
        dn.download();
        this.primaryFile = dn.getLocalFile().toPath();
        return this.primaryFile;
    }

    @Override
    public void close() throws IOException {
        if (this.checksumFile != null) {
            Files.deleteIfExists(this.checksumFile);
        }
        if (this.primaryFile != null) {
            Files.deleteIfExists(this.primaryFile);
        }
    }

    public InputStream getPrimaryInputStream() throws IOException {
        InputStream content;
        if (this.primaryFile == null) {
            throw this.feedback.failure("DOWNLOAD_PackageFileNotFound", null, new Object[0]);
        }
        InputStream physStream = Files.newInputStream(this.primaryFile, StandardOpenOption.READ);
        InputStream inputStream = content = this.compressedFile ? new GZIPInputStream(physStream) : physStream;
        if (this.primaryOpenedDigestString == null) {
            return content;
        }
        byte[] expected = SystemUtils.toHashBytes((String)this.primaryOpenedDigestString);
        if (expected == null) {
            throw this.feedback.failure("YUM_InvalidOpenedSha256Hash", null, new Object[]{this.primaryOpenedDigestString});
        }
        if (!this.verifyChecksum) {
            return content;
        }
        try {
            MessageDigest dg = MessageDigest.getInstance("SHA-256");
            return new DigestCheckInputStream(content, dg, expected);
        }
        catch (NoSuchAlgorithmException ex) {
            throw this.feedback.failure("YUM_MessageDigestUnsupported", null, new Object[]{"SHA-256"});
        }
    }

    private class DigestCheckInputStream
    extends FilterInputStream {
        private final byte[] expectedDigest;
        private final MessageDigest digest;
        private boolean closed;

        DigestCheckInputStream(InputStream in, MessageDigest dg, byte[] expected) {
            super(in);
            this.digest = dg;
            this.expectedDigest = expected;
        }

        @Override
        public long skip(long n) throws IOException {
            if (n > Integer.MAX_VALUE) {
                throw new IOException("Unsupported long read");
            }
            byte[] b = new byte[(int)n];
            return this.read(b);
        }

        @Override
        public int read() throws IOException {
            int b = super.read();
            if (b == -1) {
                this.closeDigestAndVerify();
                return -1;
            }
            this.digest.update((byte)b);
            return b;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = super.read(b, off, len);
            if (read == -1) {
                this.closeDigestAndVerify();
                return -1;
            }
            this.digest.update(b, off, read);
            return read;
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                int r = this.read();
                if (r != -1) {
                    byte[] buffer = new byte[2048];
                    while (this.read(buffer) != -1) {
                    }
                }
                this.closeDigestAndVerify();
            }
            super.close();
        }

        private RuntimeException expectedDigestNotSame(byte[] dg) {
            throw RepositoryDownloader.this.feedback.failure("YUM_ExpectedDigestNotSame", null, new Object[]{SystemUtils.fingerPrint((byte[])this.expectedDigest), SystemUtils.fingerPrint((byte[])dg)});
        }

        private void closeDigestAndVerify() {
            if (this.closed) {
                return;
            }
            byte[] digested = this.digest.digest();
            if (digested.length != this.expectedDigest.length) {
                throw this.expectedDigestNotSame(digested);
            }
            for (int i = 0; i < this.expectedDigest.length; ++i) {
                if (digested[i] == this.expectedDigest[i]) continue;
                throw this.expectedDigestNotSame(digested);
            }
            this.closed = true;
        }
    }
}

