/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graalvm.component.installer.yum;

import com.oracle.graalvm.component.installer.rpm.RpmConstants;
import com.oracle.graalvm.component.installer.rpm.RpmUtils;
import com.oracle.graalvm.component.installer.uln.RpcUtils;
import com.oracle.graalvm.component.installer.util.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.MetadataException;
import org.graalvm.component.installer.SoftwareChannelSource;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.model.ComponentInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PackageListReader {
    private final SoftwareChannelSource source;
    private final Feedback feedback;
    private final List<ComponentInfo> components = new ArrayList<ComponentInfo>();
    private final Document pkgDocument;
    private final URL baseURL;
    private Node rootNode;
    private Node lastPackageNode;
    private String pkgName;

    public PackageListReader(SoftwareChannelSource s, URL base, InputStream xmlInput, Feedback fb) throws IOException {
        this.source = s;
        this.feedback = fb.withBundle(PackageListReader.class);
        this.baseURL = base;
        try {
            this.pkgDocument = XmlUtil.configureBuilderFactory(fb).newDocumentBuilder().parse(xmlInput);
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw this.feedback.failure("YUM_CorruptedPackageFile", (Throwable)ex, new Object[0]);
        }
        this.rootNode = this.pkgDocument.getDocumentElement();
    }

    private String getTextContent(String attribute) {
        return this.getTextContent(attribute, true);
    }

    private String getTextContent(String attribute, boolean required) {
        String s;
        Node n = RpcUtils.findPath(this.lastPackageNode, attribute);
        String string = s = n == null ? null : n.getTextContent();
        if (s == null || s.isEmpty()) {
            if (!required) {
                return null;
            }
            if (this.pkgName == null) {
                throw new MetadataException(attribute, this.feedback.l10n("YUM_MissingRequiredAttribute1", new Object[]{attribute}));
            }
            throw new MetadataException(attribute, this.feedback.l10n("YUM_MissingRequiredAttribute2", new Object[]{this.pkgName, attribute}));
        }
        return s;
    }

    private String getAttribute(String path, String attribute) {
        Node loc = RpcUtils.findPath(this.lastPackageNode, path);
        if (loc == null) {
            throw new MetadataException(path, this.feedback.l10n("YUM_MissingRequiredAttribute1", new Object[]{path}));
        }
        return this.getAttribute(loc, attribute);
    }

    private String getAttribute(Node loc, String attribute) {
        Node a = loc.getAttributes().getNamedItem(attribute);
        if (a == null) {
            throw new MetadataException(attribute, this.feedback.l10n("YUM_MissingRequiredAttribute1", new Object[]{attribute}));
        }
        return a.getTextContent();
    }

    private String readVersion() {
        String v = this.getAttribute("version", "ver");
        String rel = this.getAttribute("version", "rel");
        return RpmUtils.translateRpmVersion(v, rel);
    }

    private ComponentInfo readComponentInfo() throws IOException {
        String pn = this.getTextContent("name");
        String arch = this.getTextContent("arch");
        String summary = this.getTextContent("summary");
        String downloadUrlString = this.getAttribute("location", "href");
        String v = this.readVersion();
        String rel = this.getAttribute("version", "rel");
        String os = RpmUtils.getOSSuffix(rel);
        String compArch = null;
        if (arch != null) {
            switch (arch) {
                case "x86_64": {
                    compArch = "amd64";
                    break;
                }
                default: {
                    throw new MetadataException("arch", this.feedback.l10n("YUM_InvalidAttributeValue", new Object[]{"arch", arch, this.pkgName}));
                }
            }
        }
        String name = RpmUtils.getPackageName(pn, v);
        String serial = SystemUtils.digestString((String)downloadUrlString, (boolean)false);
        ComponentInfo info = new ComponentInfo(name, summary, v, serial);
        if (!RpmUtils.isOSNeutral(os)) {
            os = SystemUtils.normalizeOSName((String)os, (String)arch);
            info.addRequiredValue("os_name", os);
        }
        if (compArch != null) {
            compArch = SystemUtils.normalizeArchitecture((String)os, (String)compArch);
            info.addRequiredValue("os_arch", compArch);
        }
        info.setOrigin(this.source.getLabel());
        info.setRemoteURL(SystemUtils.toURL((URL)this.baseURL, (String)downloadUrlString));
        Node n = RpcUtils.findPath(this.lastPackageNode, "checksum[@type=\"sha256\"]");
        info.setShaDigest(SystemUtils.toHashBytes((String)n.getTextContent()));
        return info;
    }

    private void readDependencyInfo(ComponentInfo ci) {
        Node n = RpcUtils.findPath(this.lastPackageNode, "format/rpm:requires");
        if (n == null) {
            return;
        }
        HashSet<String> dependencies = new HashSet<String>();
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            String f;
            Node c = n.getChildNodes().item(i);
            if (!"rpm:entry".equals(c.getNodeName()) || !"EQ".equals(f = this.getAttribute(c, "flags"))) continue;
            Object rvers = this.getAttribute(c, "ver");
            Node aRel = c.getAttributes().getNamedItem("rel");
            String relver = aRel == null ? null : aRel.getTextContent().trim();
            String r = this.getAttribute(c, "name");
            if (RpmConstants.REAL_CAPABILITIES.contains(r)) {
                if ("org.graalvm".equals(r)) {
                    r = "graalvm_version";
                    if (relver != null && !relver.isEmpty()) {
                        rvers = (String)rvers + "-" + RpmUtils.stripOSSuffix(relver);
                    }
                }
                ci.addRequiredValue(r, (String)rvers);
                continue;
            }
            dependencies.add(r);
        }
        if (!dependencies.isEmpty()) {
            ci.setDependencies(dependencies);
        }
    }

    public List<ComponentInfo> build() {
        Node pkg = null;
        while ((pkg = RpcUtils.findPath(this.rootNode, this.lastPackageNode, "package[@type=\"rpm\"]")) != null) {
            this.lastPackageNode = pkg;
            this.pkgName = null;
            try {
                this.pkgName = this.getTextContent("name");
                ComponentInfo ci = this.readComponentInfo();
                this.readDependencyInfo(ci);
                this.components.add(ci);
            }
            catch (MetadataException ex) {
                this.feedback.message("YUM_PropagateMessage", new Object[]{ex.getMessage()});
            }
            catch (IOException ex) {
                throw this.feedback.failure("YUM_ErrorReadingPackageData", (Throwable)ex, new Object[]{ex.getLocalizedMessage()});
            }
        }
        return this.components;
    }
}

