/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graalvm.component.installer.util;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.graalvm.component.installer.Feedback;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {
    private static void setFeature(DocumentBuilderFactory dbf, String f, boolean enable, Feedback fb) {
        try {
            dbf.setFeature(f, enable);
        }
        catch (ParserConfigurationException ex) {
            fb.verboseOutput("ULN_ParserFeatureNotSupported", new Object[]{f});
        }
    }

    public static DocumentBuilder newDocumentBuilder(DocumentBuilderFactory dbf) throws ParserConfigurationException {
        return XmlUtil.configureDocumentBuilder(dbf.newDocumentBuilder());
    }

    public static DocumentBuilder configureDocumentBuilder(DocumentBuilder bldr) {
        bldr.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                InputSource s = new InputSource(systemId);
                s.setPublicId(publicId);
                s.setCharacterStream(new StringReader(""));
                return s;
            }
        });
        return bldr;
    }

    public static DocumentBuilderFactory configureBuilderFactory(Feedback fb) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        dbf.setIgnoringComments(true);
        dbf.setIgnoringElementContentWhitespace(true);
        XmlUtil.setFeature(dbf, "http://apache.org/xml/features/disallow-doctype-decl", false, fb);
        XmlUtil.setFeature(dbf, "http://xml.org/sax/features/external-general-entities", false, fb);
        XmlUtil.setFeature(dbf, "http://xml.org/sax/features/external-parameter-entities", false, fb);
        XmlUtil.setFeature(dbf, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false, fb);
        return dbf;
    }
}

