/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graalvm.component.installer.uln;

import com.oracle.graalvm.component.installer.rpm.RpmUtils;
import com.oracle.graalvm.component.installer.uln.Authenticator;
import com.oracle.graalvm.component.installer.uln.RpcAgent;
import com.oracle.graalvm.component.installer.uln.ULNStorageImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.SoftwareChannel;
import org.graalvm.component.installer.SoftwareChannelSource;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.model.CatalogContents;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentRegistry;
import org.graalvm.component.installer.model.ComponentStorage;
import org.graalvm.component.installer.remote.FileDownloader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ULNChannel
implements SoftwareChannel {
    static final String PROP_ENABLE_PASSWORD_INPUT = ULNChannel.class.getName() + ".enablePasswordInput";
    static final Map<String, String> ULN_OPTIONS = new HashMap<String, String>();
    private CommandInput input;
    private Feedback feedback;
    private CatalogContents registry;
    private ComponentRegistry localRegistry;
    private String osName;
    private String channel;
    private URL ulnEndpoint;
    private RpcAgent agent;
    private Authenticator authHelper;
    private ComponentStorage storage;
    private boolean nonInteractive;
    private boolean oracleLinux;
    private SoftwareChannelSource source;
    private URL endpointURL;
    private String currentComponentId;
    private Map<String, Collection<String>> componentNameToId = Collections.emptyMap();

    public SoftwareChannelSource getSource() {
        return this.source;
    }

    public URL getEndpointURL() {
        return this.endpointURL;
    }

    public boolean isOracleLinux() {
        return this.oracleLinux;
    }

    public void setOracleLinux(boolean osOracleLinux) {
        this.oracleLinux = osOracleLinux;
    }

    static boolean passwordOptionsEnabled() {
        return Boolean.valueOf(System.getProperty(PROP_ENABLE_PASSWORD_INPUT, Boolean.FALSE.toString()));
    }

    static void enablePasswordOptions() {
        if (ULNChannel.passwordOptionsEnabled()) {
            ULN_OPTIONS.put("P", "s");
            ULN_OPTIONS.put("password", "P");
        } else {
            ULN_OPTIONS.remove("P");
            ULN_OPTIONS.remove("password");
        }
    }

    static boolean isOracleLinux(Feedback fb) {
        if (SystemUtils.isWindows()) {
            return false;
        }
        Path p = Paths.get("/etc/os-release", new String[0]);
        if (!Files.isRegularFile(p, new LinkOption[0]) || !Files.isReadable(p)) {
            return false;
        }
        Properties vals = new Properties();
        try (InputStream is = Files.newInputStream(p, StandardOpenOption.READ);){
            vals.load(is);
        }
        catch (IOException ex) {
            fb.failure("ULN_CannotReadOSInfo", (Throwable)ex, new Object[0]);
            return false;
        }
        String osRel = vals.getProperty("ID");
        String forced = System.getProperty(ULNChannel.class.getName() + ".asOracleLinux");
        if (forced != null) {
            return Boolean.valueOf(forced);
        }
        return "ol".equals(osRel);
    }

    boolean setupLocation(String src) {
        return this.setupLocation(new SoftwareChannelSource(src));
    }

    public boolean setupLocation(SoftwareChannelSource src) {
        String urlString = src.getLocationURL();
        if (!urlString.startsWith("uln:")) {
            return false;
        }
        this.source = src;
        this.endpointURL = this.prepareULNEndpoint(this.source.getLocationURL());
        if (this.source.getLabel() == null) {
            this.source.setLabel(this.feedback.l10n("ULN_DefaultComponentChannel", new Object[0]));
        }
        return true;
    }

    public boolean isNonInteractive() {
        return this.nonInteractive;
    }

    public void setNonInteractive(boolean nonInteractive) {
        this.nonInteractive = nonInteractive;
    }

    public void init(CommandInput in, Feedback out) {
        this.input = in;
        this.feedback = out.withBundle(ULNChannel.class);
        this.setLocalRegistry(in.getLocalRegistry());
        if (in.optValue("N") != null) {
            this.nonInteractive = true;
        }
        this.oracleLinux = ULNChannel.isOracleLinux(this.feedback);
    }

    void setLocalRegistry(ComponentRegistry localReg) {
        this.localRegistry = localReg;
    }

    URL prepareULNEndpoint(String specifier) {
        try {
            String graalOSName = ((String)this.input.getLocalRegistry().getGraalCapabilities().get("os_name")).toLowerCase(Locale.ENGLISH);
            String spec = specifier.replace("uln:", "https:").replace("${OS_NAME}", graalOSName);
            URL temp = SystemUtils.toURL((String)spec);
            String p = temp.getPath();
            int i = p.lastIndexOf(47);
            String loc = URLDecoder.decode(p.substring(0, i), "UTF-8");
            String ch = URLDecoder.decode(p.substring(i + 1), "UTF-8");
            String paramCh = this.source.getParameter(graalOSName);
            if (paramCh != null) {
                this.osName = graalOSName;
                ch = paramCh;
            }
            ch = ch.replace("{base.jdk.version}", (CharSequence)this.input.getLocalRegistry().getGraalCapabilities().get("java_version"));
            this.ulnEndpoint = SystemUtils.toURL((URL)temp, (String)loc);
            this.channel = ch;
            return this.ulnEndpoint;
        }
        catch (UnsupportedEncodingException | MalformedURLException ex) {
            throw this.feedback.failure("ULN_InvalidULNLocation", (Throwable)ex, new Object[]{specifier});
        }
    }

    public String getOSName() {
        return this.osName;
    }

    public URL getULNEndpoint() {
        return this.ulnEndpoint;
    }

    public String getChannelName() {
        return this.channel;
    }

    CatalogContents getRegistry() {
        if (this.registry != null) {
            return this.registry;
        }
        this.start();
        try {
            this.storage = this.loadStorage();
            this.registry = new CatalogContents(this.feedback.withBundle(Feedback.class), this.storage, this.input.getLocalRegistry());
        }
        catch (IOException ex) {
            throw this.feedback.failure("ULN_ErrorLoadingChannel", (Throwable)ex, new Object[]{this.channel, ex.getLocalizedMessage()});
        }
        return this.registry;
    }

    RpcAgent getAgent() {
        return this.agent;
    }

    ComponentStorage loadStorage() throws IOException {
        ComponentInfo ci;
        if (this.isOracleLinux() && (ci = this.localRegistry.loadSingleComponent("org.graalvm", false)) != null && ci.isNativeComponent()) {
            return new ULNStorageImpl(this, Collections.emptySet(), this.localRegistry, this.feedback, this.ulnEndpoint);
        }
        this.start();
        HashMap<String, String> replaces = new HashMap<String, String>();
        replaces.put("channel", this.channel);
        if (this.agent.isLoggedIn()) {
            if (!this.feedback.verboseOutput("ULN_ListingChannelVerbose", new Object[]{this.channel, this.ulnEndpoint.toString(), this.source.getLabel()})) {
                this.feedback.output("ULN_ListingChannelNormal", new Object[]{this.channel, this.ulnEndpoint.getHost(), this.source.getLabel()});
            }
            this.componentNameToId = this.agent.makeRequest(this.feedback.l10n("ULN_FetchingComponentList", new Object[]{this.channel}), "channelContents.xml", replaces, this::readComponentList);
        } else {
            this.feedback.output("ULN_NotListingChannel", new Object[0]);
        }
        ULNStorageImpl impl = new ULNStorageImpl(this, this.componentNameToId.keySet(), this.localRegistry, this.feedback, this.ulnEndpoint);
        return impl;
    }

    ComponentInfo deserializeDetailMeta(Document d) {
        return this.deserializeDetailMeta(this.agent.findPath(d.getDocumentElement(), "params/param/value/struct", true));
    }

    String urlToOsName(String version, String arch, String url) {
        if (this.osName != null) {
            return this.osName;
        }
        String toFind = version.replaceAll("[^\\p{Alnum}]", ".") + "\\.([A-Za-z0-9]+)[_.]" + Pattern.quote(arch);
        Matcher m = Pattern.compile(toFind).matcher(url);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private String textContent(Node n, String path) {
        return this.agent.findPath(n, path, true).getTextContent().trim();
    }

    ComponentInfo deserializeDetailMeta(Node n) {
        try {
            String id = this.textContent(n, "member/name[package_name]/../value");
            String name = this.textContent(n, "member/name[package_summary]/../value");
            String version = this.textContent(n, "member/name[package_version]/../value");
            String digest = this.textContent(n, "member/name[package_md5sum]/../value");
            String licenseType = this.textContent(n, "member/name[package_license]/../value");
            String url = this.textContent(n, "member/name[download_urls]/../value/array/data/value/string");
            String archS = this.textContent(n, "member/name[package_arch_label]/../value");
            String arch = ULNChannel.translateArch(archS);
            Node releaseN = this.agent.findPath(n, "member/name[package_release]/../value", false);
            String release = releaseN == null ? "" : releaseN.getTextContent().trim();
            HashMap<String, String> caps = new HashMap<String, String>();
            version = RpmUtils.translateRpmVersion(version, release);
            id = RpmUtils.readPackageName(id, version, caps);
            ComponentInfo res = new ComponentInfo(id, name, version);
            res.setRemoteURL(SystemUtils.toURL((String)url));
            res.setLicenseType(licenseType);
            byte[] hashBytes = SystemUtils.toHashBytes((String)digest);
            if (hashBytes == null) {
                throw this.feedback.failure(release, null, new Object[]{name, digest});
            }
            res.setShaDigest(hashBytes);
            String os = this.urlToOsName(version, archS, url);
            if (os == null) {
                os = RpmUtils.getOSSuffix(release);
            }
            if (!RpmUtils.isOSNeutral(os)) {
                os = SystemUtils.normalizeOSName((String)os, (String)arch);
                res.addRequiredValue("os_name", os);
            }
            if (arch != null && !RpmUtils.isArchNeutral(arch)) {
                arch = SystemUtils.normalizeArchitecture((String)os, (String)arch);
                res.addRequiredValue("os_arch", arch);
            }
            for (String s : caps.keySet()) {
                res.addRequiredValue(s, (String)caps.get(s));
            }
            res.addRequiredValue("graalvm_version", Version.fromString((String)version).installVersion().toString());
            return res;
        }
        catch (IOException ex) {
            this.feedback.error("ULN_ErrorFetchingComponent", (Throwable)ex, new Object[]{this.currentComponentId});
            return null;
        }
    }

    Map<String, Collection<String>> readComponentList(Document doc) {
        Node array = this.agent.findPath("params/param/value/array/data");
        NodeList children = array.getChildNodes();
        int max = children.getLength();
        HashMap<String, Collection<String>> packageIds = new HashMap<String, Collection<String>>();
        this.feedback.verboseOutput("ULN_FetchingComponentList", new Object[0]);
        for (int i = 0; i < max; ++i) {
            Node ch = children.item(i);
            if (ch.getNodeType() != 1 || !"value".equals(ch.getNodeName())) continue;
            String name = this.textContent(ch, "struct/member/name[package_name]/../value");
            String arch = ULNChannel.translateArch(this.textContent(ch, "struct/member/name[package_arch_label]/../value"));
            String version = this.textContent(ch, "struct/member/name[package_version]/../value");
            Node releaseN = this.agent.findPath(ch, "struct/member/name[package_release]/../value", false);
            String release = releaseN == null ? "" : releaseN.getTextContent().trim();
            String os = RpmUtils.getOSSuffix(release);
            if (!this.matchGraalVersion(os = SystemUtils.normalizeOSName((String)os, (String)arch), arch = SystemUtils.normalizeArchitecture((String)os, (String)arch), version = RpmUtils.translateRpmVersion(version, release))) continue;
            name = RpmUtils.getPackageName(name, version);
            packageIds.computeIfAbsent(name, n -> new ArrayList()).add(this.agent.findPath(ch, "struct/member/name[package_id]/../value", true).getTextContent().trim());
        }
        return packageIds;
    }

    boolean matchGraalVersion(String os, String arch, String version) {
        Version v;
        if (Boolean.getBoolean("gu.all.match")) {
            return true;
        }
        Map caps = this.localRegistry.getGraalCapabilities();
        if (arch == null || !arch.equalsIgnoreCase((String)caps.get("os_arch"))) {
            return false;
        }
        if (os != null && !((String)caps.get("os_name")).toLowerCase(Locale.ENGLISH).equals(os)) {
            return false;
        }
        if (version == null) {
            return false;
        }
        try {
            v = Version.fromString((String)version);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        return this.localRegistry.getGraalVersion().match(Version.Match.Type.INSTALLABLE).test(v);
    }

    private static String translateArch(String ulnArch) {
        switch (ulnArch) {
            case "i386": 
            case "i686": {
                return "i386";
            }
            case "x86_64": {
                return "amd64";
            }
        }
        return null;
    }

    Set<ComponentInfo> getComponentDetails(String componentId) throws IOException {
        Collection<String> channelIds = this.componentNameToId.get(componentId);
        if (channelIds == null) {
            return null;
        }
        this.currentComponentId = componentId;
        HashSet<ComponentInfo> result = new HashSet<ComponentInfo>();
        for (String packageId : channelIds) {
            HashMap<String, String> replaces = new HashMap<String, String>();
            replaces.put("packageId", packageId);
            ComponentInfo info = this.agent.makeRequest(this.feedback.l10n("ULN_FetchComponentDetail", new Object[]{componentId}), "packageDetail.xml", replaces, this::deserializeDetailMeta);
            if (!this.matchGraalVersion((String)info.getRequiredGraalValues().get("os_name"), (String)info.getRequiredGraalValues().get("os_arch"), info.getVersionString()) || result.add(info)) continue;
            throw this.feedback.failure("ULN_AmbiguousComponent", null, new Object[]{packageId});
        }
        return result;
    }

    RpcAgent start() {
        if (this.agent != null) {
            return this.agent;
        }
        this.agent = this.doCreateAgent(this.endpointURL);
        return this.agent;
    }

    Authenticator createAuthenticator() {
        if (this.authHelper == null) {
            this.authHelper = new Authenticator(this.input, this.feedback, this.channel).setNonInteractive(this.nonInteractive);
        }
        return this.authHelper;
    }

    RpcAgent doCreateAgent(URL location) {
        RpcAgent a = new RpcAgent(this.feedback, location);
        a.setChannelName(this.getChannelName());
        this.createAuthenticator().setAgent(a);
        this.feedback.verboseOutput("ULN_TryingLogin", new Object[]{this.channel, location});
        try {
            this.authHelper.login();
        }
        catch (IOException ex) {
            String un = this.authHelper.getUserName(true);
            if (un == null) {
                un = this.feedback.l10n("ULN_CurrentUser", new Object[0]);
            }
            throw this.feedback.failure("ULN_CouldNotLogin", (Throwable)ex, new Object[]{un, ex.getLocalizedMessage()});
        }
        return a;
    }

    public FileDownloader configureDownloader(ComponentInfo info, FileDownloader dn) {
        if (this.agent != null) {
            this.agent.addAuthenticationHeader(dn);
        }
        return dn;
    }

    public ComponentStorage getStorage() throws IOException {
        if (this.storage != null) {
            return this.storage;
        }
        this.storage = this.loadStorage();
        return this.storage;
    }

    static {
        ULN_OPTIONS.put("U", "s");
        ULN_OPTIONS.put("username", "U");
        ULNChannel.enablePasswordOptions();
    }

    public static class Factory
    implements SoftwareChannel.Factory {
        private Feedback feedback;

        public SoftwareChannel createChannel(SoftwareChannelSource source, CommandInput input, Feedback output) {
            ULNChannel ch = new ULNChannel();
            ch.init(input, output);
            if (!ch.setupLocation(source)) {
                return null;
            }
            return ch;
        }

        public Map<String, String> globalOptions() {
            return ULN_OPTIONS;
        }

        public String globalOptionsHelp() {
            Object s = this.feedback.l10n("ULN_ExtraOptionsHelp", new Object[0]);
            if (ULNChannel.passwordOptionsEnabled()) {
                s = (String)s + this.feedback.l10n("ULN_ExtraOptionsHelp2", new Object[0]);
            }
            return s;
        }

        public void init(CommandInput input, Feedback output) {
            this.feedback = output.withBundle(ULNChannel.class);
        }
    }
}

