/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graalvm.component.installer.uln;

import com.oracle.graalvm.component.installer.uln.RpcUtils;
import com.oracle.graalvm.component.installer.uln.UnauthorizedException;
import com.oracle.graalvm.component.installer.util.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.IncompatibleException;
import org.graalvm.component.installer.URLConnectionFactory;
import org.graalvm.component.installer.remote.FileDownloader;
import org.graalvm.component.installer.remote.ProxyConnectionFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RpcAgent {
    private static final boolean PRINT_FAULTS = Boolean.getBoolean(RpcAgent.class.getName() + ".printFaults");
    private static final int FAULT_NO_SESSION = -2;
    private static final int FAULT_NO_CHANNEL = -210;
    private static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    private static final String HEADER_ACCEPT_CONTENT = "Accept";
    private static final String HEADER_CONTENT_XML = "text/xml";
    private static final String HEADER_CONTENT_LENGTH = "Content-Length";
    private static final String HEADER_CONTENT_TYPE = "Content-type";
    private static final String HEADER_USER_AGENT = "User-agent";
    private static final String HEADER_ACCEPT_ENCODING = "Accept-encoding";
    private static final String DOWNLOAD_DIGEST = "MD5";
    private static final String HEADER_ULN_AUTHORIZATION = "X-ULN-API-User-Key";
    private static final String HEADER_CONTENT_GZIP = "gzip";
    private final Feedback feedback;
    private final URL ulnApiURL;
    private String authToken;
    private Document response;
    private String requestLabel;
    private URLConnectionFactory connFactory;
    private String channelName;
    private DocumentBuilderFactory builderFactory;

    public RpcAgent(Feedback feedback, URL ulnApiURL) {
        this.feedback = feedback.withBundle(RpcAgent.class);
        this.ulnApiURL = ulnApiURL;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    void setResponseDocument(Document d) {
        this.response = d;
        this.throwFault(d);
    }

    public URL getURL() {
        return this.ulnApiURL;
    }

    RpcAgent setConnectionFactory(URLConnectionFactory f) {
        this.connFactory = f;
        return this;
    }

    HttpURLConnection postRequest(char[] content) throws IOException {
        if (this.connFactory == null) {
            this.connFactory = new ProxyConnectionFactory(this.feedback, this.ulnApiURL);
        }
        HttpURLConnection huc = (HttpURLConnection)this.connFactory.createConnection(this.ulnApiURL, con -> {
            try {
                HttpURLConnection uCon = (HttpURLConnection)con;
                RpcAgent.doConfigureAndPostConnection(content, uCon);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        });
        return huc;
    }

    private static void doConfigureAndPostConnection(char[] content, HttpURLConnection huc) throws IOException {
        CharBuffer cb = CharBuffer.wrap(content);
        Charset cs = Charset.forName("UTF-8");
        ByteBuffer bb = cs.newEncoder().encode(cb);
        byte[] payload = new byte[bb.limit()];
        System.arraycopy(bb.array(), bb.arrayOffset(), payload, 0, payload.length);
        huc.setDoInput(true);
        huc.setDoOutput(true);
        huc.setRequestMethod("POST");
        huc.addRequestProperty(HEADER_ACCEPT_ENCODING, HEADER_CONTENT_GZIP);
        huc.addRequestProperty(HEADER_USER_AGENT, "Graal Updater");
        huc.addRequestProperty(HEADER_CONTENT_TYPE, HEADER_CONTENT_XML);
        huc.setRequestProperty(HEADER_ACCEPT_CONTENT, HEADER_CONTENT_XML);
        huc.addRequestProperty(HEADER_CONTENT_LENGTH, Integer.toString(payload.length));
        huc.connect();
        try (OutputStream os = huc.getOutputStream();){
            os.write(payload);
            os.flush();
        }
    }

    private DocumentBuilderFactory configureBuilderFactory() {
        if (this.builderFactory != null) {
            return this.builderFactory;
        }
        this.builderFactory = XmlUtil.configureBuilderFactory(this.feedback);
        return this.builderFactory;
    }

    Document getResponse(HttpURLConnection con) throws IOException {
        Document doc;
        int respCode = con.getResponseCode();
        if (respCode == 401) {
            throw new UnauthorizedException(this.feedback.l10n("ULN_AccessDenied", new Object[]{this.requestLabel}));
        }
        try {
            DocumentBuilder bldr = XmlUtil.newDocumentBuilder(this.configureBuilderFactory());
            try (InputStream is = con.getInputStream();){
                String s = con.getHeaderField(HEADER_CONTENT_ENCODING);
                try (InputStream docSource = s != null && s.equalsIgnoreCase(HEADER_CONTENT_GZIP) ? new GZIPInputStream(is) : is;){
                    doc = bldr.parse(docSource, con.getURL().toString());
                }
            }
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new IOException(ex);
        }
        this.setResponseDocument(doc);
        return doc;
    }

    void throwFault(Document doc) {
        String s;
        Node faultNode;
        if (PRINT_FAULTS) {
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "no");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter((OutputStream)System.err, "UTF-8")));
            }
            catch (UnsupportedEncodingException | TransformerException ex) {
                Logger.getLogger(RpcAgent.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if ((faultNode = RpcUtils.findPath(doc.getDocumentElement(), "fault")) == null) {
            return;
        }
        Node codeNode = this.findPath(faultNode, "value/struct/member/name[faultCode]/../value/int", false);
        int code = 0;
        try {
            code = Integer.parseInt(codeNode.getTextContent());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Node descNode = this.findPath(faultNode, "value/struct/member/name[faultString]/../value/string", false);
        String string = s = descNode == null ? this.feedback.l10n("ULN_UnknownReqeustReason", new Object[0]) : descNode.getTextContent();
        if (code == -2) {
            throw new UnauthorizedException(s);
        }
        if (code == -210) {
            throw new IncompatibleException(this.feedback.l10n("ULN_ChannelNotExists", new Object[]{this.channelName}));
        }
        throw this.feedback.failure("ULN_RequestFailed", null, new Object[]{s});
    }

    public Node findPath(String pathSpec) {
        return this.findPath(this.response.getDocumentElement(), pathSpec, true);
    }

    public Node findPath(Node root, String path, boolean mustExist) {
        return this.findPath(root, 0, Arrays.asList(path.split("/")), mustExist);
    }

    Node findPath(Node root, int pos, List<String> path, boolean mustExist) {
        Node n = RpcUtils.findPath(root, pos, path);
        if (n != null) {
            return n;
        }
        if (mustExist) {
            throw this.feedback.failure("ULN_UnexpectedResponse", null, new Object[]{this.requestLabel});
        }
        return null;
    }

    private String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public Document getResponse() {
        return this.response;
    }

    public <T> T makeRequest(String label, String resource, Map<String, ?> replaces, Function<Document, T> callback) throws IOException {
        return this.makeRequest(label, this.formatMessage(resource, replaces).toCharArray(), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T makeRequest(String label, char[] msg, Function<Document, T> callback) throws IOException {
        this.requestLabel = label;
        HttpURLConnection con = null;
        try {
            con = this.postRequest(msg);
            this.getResponse(con);
            T t = callback.apply(this.getResponse());
            return t;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    public String formatMessage(String messageResource, Map<String, ?> replaces) {
        try {
            return RpcUtils.replaceToken(RpcUtils.formatMessage(this.getClass(), messageResource, replaces), "auth", k -> this.authToken);
        }
        catch (IOException ex) {
            throw this.feedback.failure("ULN_CannotFormatRequest", (Throwable)ex, new Object[]{messageResource, ex.getLocalizedMessage()});
        }
    }

    public void addAuthenticationHeader(FileDownloader dn) {
        dn.addRequestHeader(HEADER_ULN_AUTHORIZATION, this.getAuthToken());
        dn.setDigestAlgorithm(DOWNLOAD_DIGEST);
    }

    public boolean isLoggedIn() {
        return this.authToken != null;
    }
}

