/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graalvm.component.installer.rpm;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.Version;

public final class RpmUtils {
    private static final Map<Path, PGPPublicKey> cachedPublicKeys = new HashMap<Path, PGPPublicKey>();
    public static final String GRAALVM_RPM_PREFIX = "graalvm-";
    public static final String GRAALVM_COMPONENT_PREFIX = "org.graalvm.";
    public static final String GRAALVM_SHORT = "graalvm";
    public static final String GRAALVM_CE = "graalvm-ce";
    public static final String GRAALVM_EE = "graalvm-ee";
    private static final String PACKAGE_NAME_REGEXP = "graalvm-(?:(ce|ee)-)?(?:(?:java)?([0-9]+)-?)?(?:installable-)?(.*)";
    private static final Set<String> OS_NAMES = new HashSet<String>();
    private static final Pattern NO_LICENSE_REGEXP;
    private static final Pattern LICENSE_TYPE_AND_HREF;

    private RpmUtils() {
    }

    static void testCleanKeysCache() {
        cachedPublicKeys.clear();
    }

    static Path systemPublicKeyPath() {
        return Paths.get("/", new String[0]).resolve(SystemUtils.fromCommonString((String)"/etc/pki/rpm-gpg/RPM-GPG-KEY-oracle"));
    }

    static PGPPublicKey loadPublicKey(CommandInput input, Feedback feedback) throws IOException {
        PGPPublicKey pk;
        String s;
        Path systemKeyPath = RpmUtils.systemPublicKeyPath();
        Path publicKeyPath = input.getGraalHomePath().resolve(SystemUtils.fromCommonString((String)"lib/installer/gu_uln_key.asc"));
        if (systemKeyPath != null && Files.isReadable(systemKeyPath)) {
            publicKeyPath = systemKeyPath;
        }
        if ((s = input.optValue("k")) == null) {
            s = System.getenv("GRAALVM_PUBLIC_KEY");
        }
        if (s != null) {
            publicKeyPath = SystemUtils.fromUserString((String)s);
            if (publicKeyPath == null || !Files.isReadable(publicKeyPath)) {
                throw new IOException(feedback.l10n("ERR_MissingPublicKeyFile", new Object[]{s}));
            }
        } else if (publicKeyPath == null || !Files.isReadable(publicKeyPath)) {
            return null;
        }
        if ((pk = cachedPublicKeys.get(publicKeyPath)) != null) {
            return pk;
        }
        try (InputStream in = Files.newInputStream(publicKeyPath, new OpenOption[0]);){
            PGPPublicKey pGPPublicKey;
            block19: {
                InputStream in2 = PGPUtil.getDecoderStream((InputStream)in);
                try {
                    PGPPublicKeyRing ring = new PGPPublicKeyRing(in2, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                    pk = ring.getPublicKey();
                    cachedPublicKeys.put(publicKeyPath, pk);
                    pGPPublicKey = pk;
                    if (in2 == null) break block19;
                }
                catch (Throwable throwable) {
                    if (in2 != null) {
                        try {
                            in2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in2.close();
            }
            return pGPPublicKey;
        }
    }

    public static String digestAlgorithm(int code) {
        switch (code) {
            case 1: {
                return "MD5";
            }
            case 2: {
                return "SHA";
            }
            case 8: {
                return "SHA-256";
            }
            case 9: {
                return "SHA-384";
            }
            case 10: {
                return "SHA-512";
            }
            case 11: {
                return "SHA-224";
            }
        }
        return null;
    }

    public static String translateRpmVersion(String version, String release) {
        if (release == null || release.isEmpty()) {
            return version;
        }
        String releaseSuffix = RpmUtils.stripOSSuffix(release.replace("_", "-"));
        if ("0".equals(releaseSuffix)) {
            return version;
        }
        return version + "-" + releaseSuffix;
    }

    public static String readPackageName(String nameString, String version, Map<String, String> capabilities) {
        String name;
        Version v;
        String toFind;
        int ni;
        String nn = version != null && !version.isEmpty() ? ((ni = nameString.indexOf(toFind = "-" + (v = Version.fromString((String)version).onlyVersion()).displayString())) == -1 ? nameString : nameString.substring(0, ni)) : nameString;
        Matcher m = Pattern.compile(PACKAGE_NAME_REGEXP).matcher(nn);
        if (m.matches()) {
            String string = name = m.group(3).isEmpty() ? GRAALVM_SHORT : GRAALVM_COMPONENT_PREFIX + m.group(3);
            if (capabilities != null) {
                String ed = m.group(1);
                String j = m.group(2);
                if (ed != null) {
                    capabilities.putIfAbsent("edition", ed);
                }
                if (j != null) {
                    capabilities.putIfAbsent("java_version", j);
                }
            }
        } else {
            name = nn;
        }
        if (GRAALVM_SHORT.equals(name) || GRAALVM_CE.equals(name) || GRAALVM_EE.equals(name)) {
            return "org.graalvm";
        }
        return name;
    }

    public static String getPackageName(String name, String version) {
        return RpmUtils.readPackageName(name, version, null);
    }

    public static String stripOSSuffix(String release) {
        String suffix = RpmUtils.getOSSuffix(release);
        if (suffix == null) {
            return release;
        }
        return release.substring(0, release.length() - (suffix.length() + 1));
    }

    public static String getOSSuffix(String release) {
        if (release == null) {
            return null;
        }
        String lowerRelease = release.toLowerCase(Locale.ENGLISH);
        for (String s : OS_NAMES) {
            if (!lowerRelease.endsWith("." + s)) continue;
            return s;
        }
        return null;
    }

    public static boolean isOSNeutral(String os) {
        return os == null || "all".equals(os);
    }

    public static boolean isArchNeutral(String arch) {
        return arch == null || "all".equals(arch);
    }

    private static boolean isRemoteURL(String toCheck) {
        try {
            URL u = SystemUtils.toURL((String)toCheck);
            String proto = u.getProtocol();
            if (!"file".equals(proto)) {
                return true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return false;
    }

    public static String[] parseLicenseHeader(String headerText) {
        if (headerText == null) {
            return null;
        }
        String t = headerText.trim();
        if ("".equals(t)) {
            return null;
        }
        if (NO_LICENSE_REGEXP.matcher(t).matches()) {
            return null;
        }
        Matcher m = LICENSE_TYPE_AND_HREF.matcher(t);
        if (m.matches()) {
            String url = m.group(2);
            if (url == null) {
                url = m.group(3);
            }
            String type = m.group(1).trim();
            if (RpmUtils.isRemoteURL(url)) {
                return new String[]{type.length() == 0 ? url.trim() : type, url.trim()};
            }
            return new String[]{t, null};
        }
        return new String[]{t, RpmUtils.isRemoteURL(t) ? t : null};
    }

    static {
        OS_NAMES.add("linux");
        OS_NAMES.add("macos");
        OS_NAMES.add("darwin");
        OS_NAMES.add("windows");
        OS_NAMES.add("all");
        NO_LICENSE_REGEXP = Pattern.compile("None|Freely redistributable without restriction", 2);
        LICENSE_TYPE_AND_HREF = Pattern.compile("(.*?)(?:[- :.]*)?(?:\\(([a-z][-+.0-9a-z]*:[^)]*)\\)|([a-z][-+.0-9a-z]*:.*$))", 2);
    }
}

