/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graalvm.component.installer.rpm;

import com.oracle.graalvm.component.installer.rpm.RpmArchive;
import com.oracle.graalvm.component.installer.rpm.RpmConstants;
import com.oracle.graalvm.component.installer.rpm.RpmUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.component.installer.Archive;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.InstallerStopException;
import org.graalvm.component.installer.MetadataException;
import org.graalvm.component.installer.SuppressFBWarnings;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.persist.MetadataLoader;
import org.redline_rpm.ChannelWrapper;
import org.redline_rpm.ReadableChannelWrapper;
import org.redline_rpm.header.AbstractHeader;
import org.redline_rpm.header.Format;
import org.redline_rpm.header.Header;

public class RpmMetaLoader
implements MetadataLoader,
Closeable {
    private static final Logger LOG = Logger.getLogger(RpmMetaLoader.class.getName());
    private static final int LICENSE_NOT_INITIALIZED = -2;
    private static final int LICENSE_NONE = -1;
    private static final int LICENSE_CONTENT_MISSING = -3;
    private static final String LICENSE_NONE_VAL = new String();
    private static final int DEFAULT_FILE_PERMISSIONS_INT = 436;
    private static final int DEFAULT_DIR_PERMISSIONS_INT = 509;
    private static final int PERMISSION_MASK = 511;
    private final Path rpmFile;
    private final Feedback fb;
    private final boolean verifyIntegrity;
    private ComponentInfo info;
    private Format rpmFormat;
    private Header rpmHeader;
    private ReadableChannelWrapper fileWrapper;
    private boolean noVerifySymlinks;
    private String[] baseNames;
    private String[] dirNames;
    private int[] dirIndexes;
    private short[] fileModes;
    private int[] fileFlags;
    private int licenseContentIndex = -2;
    private boolean ignoreErrors;
    private Map<String, String> filePrefixes = Collections.emptyMap();
    private Collection<RuntimeException> errors = new ArrayList<RuntimeException>();
    private String serial;
    private int metadataIndex = -1;
    private int relocationsIndex = -1;
    private RpmArchive rpmArchive;
    private String licenseType;
    private String licensePath;
    private static final char[] PERM_CHARS = new char[]{'r', 'w', 'x', 'r', 'w', 'x', 'r', 'w', 'x'};

    public RpmMetaLoader(Path rpmFile, String serial, Feedback feedback, boolean verify) {
        this.rpmFile = rpmFile;
        this.serial = serial;
        this.fb = feedback.withBundle(RpmMetaLoader.class);
        this.verifyIntegrity = verify;
        LOG.log(Level.FINE, "Metaloader created for {0}", rpmFile.toString());
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.fileWrapper != null) {
                this.fileWrapper.close();
            }
        }
        finally {
            this.rpmFormat = null;
            this.fileWrapper = null;
            this.dirIndexes = null;
            this.fileModes = null;
            this.fileFlags = null;
            this.baseNames = null;
            this.dirNames = null;
        }
    }

    private void openFileChannel() throws IOException {
        if (this.fileWrapper != null) {
            return;
        }
        FileChannel fileChannel = FileChannel.open(this.rpmFile, StandardOpenOption.READ);
        this.fileWrapper = new ReadableChannelWrapper((ReadableByteChannel)fileChannel);
    }

    private void loadRpmMetadata() throws IOException {
        Format f;
        if (this.rpmFormat != null) {
            return;
        }
        this.rpmFormat = f = this.fillRpmMetadata();
        this.rpmHeader = f.getHeader();
    }

    Format fillRpmMetadata() throws IOException {
        this.openFileChannel();
        Format f = new Format();
        ChannelWrapper.Key headerStartKey = this.fileWrapper.start();
        f.getLead().read((ReadableByteChannel)this.fileWrapper);
        f.getSignature().read((ReadableByteChannel)this.fileWrapper);
        int headerStartPos = (Integer)this.fileWrapper.finish(headerStartKey);
        f.getHeader().setStartPos(headerStartPos);
        ChannelWrapper.Key headerKey = this.fileWrapper.start();
        f.getHeader().read((ReadableByteChannel)this.fileWrapper);
        Integer headerLength = (Integer)this.fileWrapper.finish(headerKey);
        f.getHeader().setEndPos(headerStartPos + headerLength);
        return f;
    }

    ComponentInfo createInfoInstance(Header hdr) {
        AbstractHeader.Entry otherMeta;
        String[] v2;
        String[] id = (String[])this.getRequiredHeader(hdr, Header.HeaderTag.NAME);
        String[] disp = (String[])this.getRequiredHeader(hdr, Header.HeaderTag.SUMMARY);
        String[] v1 = (String[])this.getRequiredHeader(hdr, Header.HeaderTag.VERSION);
        String[] os = (String[])this.getRequiredHeader(hdr, Header.HeaderTag.OS);
        String[] arch = (String[])this.getRequiredHeader(hdr, Header.HeaderTag.ARCH);
        AbstractHeader.Entry relEntry = hdr.getEntry((AbstractHeader.Tag)Header.HeaderTag.RELEASE);
        if (relEntry == null) {
            v2 = null;
        } else {
            v2 = (String[])relEntry.getValues();
            if (v2.length == 1 && "0".equals(v2[0])) {
                v2 = null;
            }
        }
        String versionString = RpmUtils.translateRpmVersion(v1[0], v2 == null ? null : v2[0]);
        String name = RpmUtils.getPackageName(id[0], v1[0]);
        String ser = this.computeSerial();
        ComponentInfo ci = new ComponentInfo(name, disp[0], versionString, ser);
        AbstractHeader.Entry en = hdr.getEntry((AbstractHeader.Tag)Header.HeaderTag.REQUIRENAME);
        if (en != null) {
            HashSet<String> dependencies = new HashSet<String>();
            String[] reqs = (String[])en.getValues();
            int[] rflags = (int[])this.getRequiredHeader(hdr, Header.HeaderTag.REQUIREFLAGS);
            String[] rvers = (String[])this.getRequiredHeader(hdr, Header.HeaderTag.REQUIREVERSION);
            for (int i = 0; i < reqs.length; ++i) {
                if (rflags[i] != 8) continue;
                String r = reqs[i];
                if (RpmConstants.REAL_CAPABILITIES.contains(r)) {
                    if ("org.graalvm".equals(r)) {
                        r = "graalvm_version";
                    }
                    ci.addRequiredValue(r, rvers[i]);
                    continue;
                }
                dependencies.add(r);
            }
            if (!dependencies.isEmpty()) {
                ci.setDependencies(dependencies);
            }
        }
        String[] archName = arch[0];
        String osName = null;
        if (!"all".equals(os[0]) && os[0] != null) {
            osName = SystemUtils.normalizeOSName((String)os[0], (String)archName);
            ci.addRequiredValue("os_name", osName);
        }
        String aval = switch (archName) {
            case "i386" -> "i386";
            case "x86_64" -> "amd64";
            case "aarch64" -> "aarch64";
            default -> null;
        };
        if (aval != null) {
            String normArch = SystemUtils.normalizeArchitecture((String)osName, (String)aval);
            ci.addRequiredValue("os_arch", normArch);
        }
        if ((otherMeta = hdr.getEntry(1182)) != null) {
            RpmMetaLoader.loadMetas(ci, (String[])otherMeta.getValues());
        }
        ci.setLicenseType(this.getLicenseType());
        return ci;
    }

    private String computeSerial() {
        if (this.serial != null) {
            return this.serial;
        }
        try {
            this.serial = SystemUtils.fingerPrint((byte[])SystemUtils.computeFileDigest((Path)this.rpmFile, null), (boolean)false);
            return this.serial;
        }
        catch (IOException ex) {
            throw this.fb.failure("ERR_LoadingMetadata", (Throwable)ex, new Object[]{this.rpmFile.toString(), ex.getLocalizedMessage()});
        }
    }

    private static void loadMetas(ComponentInfo info, String[] lines) {
        block8: for (String l : lines) {
            String v;
            String n;
            int colon = l.indexOf(58);
            if (colon == -1) {
                n = l;
                v = "";
            } else {
                n = l.substring(0, colon);
                v = l.substring(colon + 1);
            }
            switch (n) {
                case "x-GraalVM-Message-PostInst": {
                    String text = v.replace("\\n", "\n").replace("\\\\", "\\");
                    info.setPostinstMessage(text);
                    continue block8;
                }
                case "x-GraalVM-Working-Directories": {
                    info.addWorkingDirectories(Arrays.asList(v.split(":")));
                }
            }
        }
    }

    void loadPathHeaders(Header hdr) {
        if (this.dirIndexes != null) {
            return;
        }
        this.baseNames = this.getRequiredStringHeader(hdr, Header.HeaderTag.BASENAMES);
        this.dirNames = this.getRequiredStringHeader(hdr, Header.HeaderTag.DIRNAMES);
        this.dirIndexes = this.getRequiredIntHeader(hdr, Header.HeaderTag.DIRINDEXES);
        this.fileModes = this.getRequiredShortHeader(hdr, Header.HeaderTag.FILEMODES);
        this.fileFlags = this.getRequiredIntHeader(hdr, Header.HeaderTag.FILEFLAGS);
        AbstractHeader.Entry prefixes = hdr.getEntry((AbstractHeader.Tag)Header.HeaderTag.PREFIXES);
        if (prefixes != null) {
            this.filePrefixes = new HashMap<String, String>();
            for (String s : (String[])prefixes.getValues()) {
                this.filePrefixes.put(s, "");
            }
        }
        if (this.dirIndexes.length != this.baseNames.length) {
            this.fail(this.fb.failure("RPM_CorruptedFileList", null, new Object[0]));
            this.dirIndexes = new int[this.baseNames.length];
        }
        int m = this.dirNames.length;
        for (int i = this.dirIndexes.length - 1; i >= 0; --i) {
            if (this.dirIndexes[i] < m) continue;
            this.fail(this.fb.failure("RPM_CorruptedFileList", null, new Object[0]));
            this.dirIndexes[i] = 0;
        }
        for (int fi = 0; fi < this.fileFlags.length; ++fi) {
            String fn = this.buildFileName(fi);
            if (!fn.startsWith("lib/installer/components")) continue;
            int l = "lib/installer/components".length();
            if (fn.length() <= l || fn.indexOf(47, l + 1) != -1) continue;
            if (fn.endsWith(".meta")) {
                this.metadataIndex = fi;
                continue;
            }
            if (!fn.endsWith(".relocations")) continue;
            this.relocationsIndex = fi;
        }
        if (this.relocationsIndex != -1) {
            this.loadRelocations();
        }
    }

    private void loadRelocations() {
        try {
            Properties relocs;
            RpmArchive ar = this.getArchive();
            Archive.FileEntry relocEntry = ar.findEntryByIndex(this.relocationsIndex);
            if (relocEntry == null) {
                throw new IllegalStateException("Relocation file not found");
            }
            try (InputStream is = ar.getInputStream(relocEntry);){
                relocs = new Properties();
                relocs.load(is);
            }
            ArrayList<String> roots = new ArrayList<String>(relocs.stringPropertyNames());
            Collections.sort(roots, Comparator.naturalOrder().reversed());
            this.filePrefixes = new LinkedHashMap<String, String>();
            for (String k : roots) {
                String target = relocs.getProperty(k, "").trim();
                if (target.isEmpty()) {
                    this.filePrefixes.put(k, null);
                    continue;
                }
                if (target.startsWith("/")) {
                    this.filePrefixes.put(k, target.substring(1));
                    continue;
                }
                this.filePrefixes.put(k, target);
            }
            ar.setFilePrefixes(this.filePrefixes);
        }
        catch (IOException ex) {
            throw this.fb.failure("RPM_CouldNotLoadRelocations", (Throwable)ex, new Object[]{ex.getLocalizedMessage()});
        }
    }

    void fail(RuntimeException e) {
        if (!this.ignoreErrors) {
            throw e;
        }
        this.errors.add(e);
    }

    String buildFileName(int i) {
        int di = this.dirIndexes[i];
        if (di == -1) {
            return this.baseNames[i];
        }
        String pn = this.dirNames[di] + this.baseNames[i];
        if (this.filePrefixes.isEmpty()) {
            return pn.substring(1);
        }
        for (String p : this.filePrefixes.keySet()) {
            if (!pn.startsWith(p)) continue;
            return pn.length() <= p.length() + 1 ? "" : pn.substring(p.length() + 1);
        }
        return "";
    }

    Map<String, String> loadSymlinks(Header hdr) {
        this.loadPathHeaders(hdr);
        AbstractHeader.Entry linkTos = hdr.getEntry((AbstractHeader.Tag)Header.HeaderTag.FILELINKTOS);
        if (linkTos == null) {
            return Collections.emptyMap();
        }
        this.loadPathHeaders(hdr);
        String[] targets = (String[])linkTos.getValues();
        HashMap<String, String> symlinkInfo = new HashMap<String, String>();
        for (int i = 0; i < targets.length; ++i) {
            String tgt;
            String filename = this.buildFileName(i);
            if (filename.trim().isEmpty() || (tgt = targets[i]).isEmpty()) continue;
            symlinkInfo.put(filename, tgt);
        }
        return symlinkInfo;
    }

    List<String> loadFileList(Header hdr) {
        this.loadPathHeaders(hdr);
        ArrayList<String> files = new ArrayList<String>();
        for (int i = 0; i < this.fileModes.length; ++i) {
            int m;
            Object fn = this.buildFileName(i);
            int f = this.fileFlags[i];
            if ((f & 0x40) > 0 || (m = this.filemode(i) >> 12) == 10) continue;
            if (m == 4) {
                fn = (String)fn + "/";
            }
            if (((String)fn).trim().isEmpty()) continue;
            files.add((String)fn);
        }
        return files;
    }

    public ComponentInfo getComponentInfo() {
        if (this.info != null) {
            return this.info;
        }
        try {
            this.loadRpmMetadata();
            this.info = this.createInfoInstance(this.rpmHeader);
        }
        catch (IOException | IllegalStateException ex) {
            this.fail(this.fb.failure("ERR_LoadingMetadata", (Throwable)ex, new Object[]{this.rpmFile.toString(), ex.getLocalizedMessage()}));
        }
        return this.info;
    }

    String[] getRequiredStringHeader(Header hdr, Header.HeaderTag tag) {
        String[] stringArray;
        String[] a = (String[])this.getRequiredHeader(hdr, tag);
        if (a == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = a;
        }
        return stringArray;
    }

    short[] getRequiredShortHeader(Header hdr, Header.HeaderTag tag) {
        short[] sArray;
        short[] a = (short[])this.getRequiredHeader(hdr, tag);
        if (a == null) {
            short[] sArray2 = new short[1];
            sArray = sArray2;
            sArray2[0] = 0;
        } else {
            sArray = a;
        }
        return sArray;
    }

    int[] getRequiredIntHeader(Header hdr, Header.HeaderTag tag) {
        int[] nArray;
        int[] a = (int[])this.getRequiredHeader(hdr, tag);
        if (a == null) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = a;
        }
        return nArray;
    }

    <T> T getRequiredHeader(Header hdr, Header.HeaderTag tag) {
        AbstractHeader.Entry e = hdr.getEntry((AbstractHeader.Tag)tag);
        if (e == null) {
            this.fail((RuntimeException)((Object)new MetadataException(tag.getName(), this.fb.l10n("RPM_InvalidPackageTagMissing", new Object[]{null, tag.getName()}))));
            return null;
        }
        Object ret = e.getValues();
        return (T)ret;
    }

    public List<InstallerStopException> getErrors() {
        return Collections.emptyList();
    }

    public RpmArchive getArchive() throws IOException {
        if (this.rpmArchive == null) {
            this.rpmArchive = new RpmArchive(this.rpmFile, this.fb, this.verifyIntegrity);
            this.loadRpmMetadata();
            this.loadPathHeaders(this.rpmHeader);
            this.rpmArchive.setMetadataFileIndex(this.metadataIndex);
            this.rpmArchive.setRelocationsFileIndex(this.relocationsIndex);
        }
        return this.rpmArchive;
    }

    private String findDigest(String path, int index) {
        AbstractHeader.Entry dgE = this.rpmHeader.getEntry((AbstractHeader.Tag)Header.HeaderTag.FILEDIGESTS);
        if (dgE == null) {
            return null;
        }
        String[] digests = (String[])dgE.getValues();
        if (index > digests.length) {
            this.fail(this.fb.failure("ERR_InvalidDigestIndex", null, new Object[]{path}));
            return "00000000";
        }
        String dg = digests[index];
        if ((dg.length() & 1) > 0) {
            this.fail(this.fb.failure("ERR_InvalidDigestContent", null, new Object[]{path}));
            return "00000000";
        }
        return dg;
    }

    public String getLicenseID() {
        String licPath = this.getLicensePath();
        if (licPath == null || this.licenseContentIndex < 0) {
            return null;
        }
        return this.findDigest(licPath, this.licenseContentIndex);
    }

    public String getLicensePath() {
        this.parseLicenseHeader();
        if (this.licensePath != null) {
            return this.licensePath;
        }
        this.loadPathHeaders(this.rpmHeader);
        if (this.licenseContentIndex == -2) {
            this.loadFileList(this.rpmHeader);
            for (int i = 0; i < this.fileFlags.length; ++i) {
                int type = this.fileFlags[i];
                if ((type & 0x80) <= 0) continue;
                this.licenseContentIndex = i;
                break;
            }
            if (this.licenseContentIndex == -2) {
                int n = this.licenseContentIndex = this.getLicenseType() != null ? -3 : -1;
            }
        }
        if (this.licenseContentIndex < 0) {
            return null;
        }
        this.licensePath = this.buildFileName(this.licenseContentIndex);
        return this.licensePath;
    }

    private void parseLicenseHeader() {
        if (this.licenseType != null) {
            return;
        }
        try {
            this.loadRpmMetadata();
        }
        catch (IOException ex) {
            this.fail(this.fb.failure("RPM_CorruptedHeader", (Throwable)ex, new Object[0]));
        }
        AbstractHeader.Entry licenses = this.rpmHeader.getEntry((AbstractHeader.Tag)Header.HeaderTag.LICENSE);
        if (licenses == null) {
            this.licenseType = LICENSE_NONE_VAL;
            this.licenseContentIndex = -1;
        } else {
            String[] typeAndPath = RpmUtils.parseLicenseHeader(((String[])licenses.getValues())[0]);
            if (typeAndPath == null) {
                this.licenseType = LICENSE_NONE_VAL;
                this.licenseContentIndex = -1;
            } else {
                this.licenseType = typeAndPath[0];
                this.licensePath = typeAndPath[1];
            }
        }
    }

    @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="LINCESE_NONE_VAL acts like not interned tag value")
    public String getLicenseType() {
        this.parseLicenseHeader();
        return this.licenseType == LICENSE_NONE_VAL ? null : this.licenseType;
    }

    public MetadataLoader infoOnly(boolean only) {
        this.ignoreErrors = true;
        return this;
    }

    public boolean isNoVerifySymlinks() {
        return this.noVerifySymlinks;
    }

    public void loadPaths() throws IOException {
        this.loadRpmMetadata();
        ComponentInfo ci = this.getComponentInfo();
        if (ci.getPaths().isEmpty()) {
            ci.addPaths(this.loadFileList(this.rpmHeader));
        }
        ci.setLicensePath(this.getLicensePath());
    }

    private static String accessMode(int mode) {
        StringBuilder sb = new StringBuilder("---------");
        int c = 8;
        int bit = 1;
        while (bit < 511) {
            if ((mode & bit) > 0) {
                sb.setCharAt(c, PERM_CHARS[c]);
            }
            bit <<= 1;
            --c;
        }
        return sb.toString();
    }

    private int filemode(int i) {
        short fm = this.fileModes[i];
        if (fm >= 0) {
            return fm;
        }
        return (fm & Short.MAX_VALUE) + 32768;
    }

    public Map<String, String> loadPermissions() throws IOException {
        this.loadRpmMetadata();
        this.loadPathHeaders(this.rpmHeader);
        HashMap<String, String> perms = new HashMap<String, String>();
        for (int i = 0; i < this.fileModes.length; ++i) {
            String fn = this.buildFileName(i);
            if (fn.trim().isEmpty()) continue;
            int fm = this.filemode(i);
            int am = fm & 0x1FF;
            String p = am == ((fm & 0x4000) > 0 ? 509 : 436) ? "" : RpmMetaLoader.accessMode(fm);
            perms.put(fn, p);
        }
        return perms;
    }

    public Map<String, String> loadSymlinks() throws IOException {
        this.loadRpmMetadata();
        return this.loadSymlinks(this.rpmHeader);
    }

    public void setNoVerifySymlinks(boolean vfy) {
        this.noVerifySymlinks = vfy;
    }

    public ComponentInfo completeMetadata() throws IOException {
        return this.getComponentInfo();
    }
}

