/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graalvm.component.installer.rpm;

import com.oracle.graalvm.component.installer.rpm.RpmUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.graalvm.component.installer.Archive;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.persist.DirectoryStorage;
import org.redline_rpm.ChannelWrapper;
import org.redline_rpm.ReadableChannelWrapper;
import org.redline_rpm.Util;
import org.redline_rpm.header.AbstractHeader;
import org.redline_rpm.header.Format;
import org.redline_rpm.header.Header;
import org.redline_rpm.header.Signature;
import org.redline_rpm.payload.CpioHeader;

public class RpmArchive
implements Archive {
    private static final int SKIP_SIZE = 4096;
    private static final int DIGEST_BUFFER_SIZE = 4096;
    private final Feedback fb;
    private final Path rpmPath;
    private final Map<String, String> filePrefixes = new LinkedHashMap<String, String>();
    private SeekableByteChannel rpmFileChannel;
    private final Format rpmFormat;
    private final long headerStartPos;
    private final Header rpmHeader;
    private final int cpioStartPos;
    private final boolean verifyIntegrity;
    private ReadableByteChannel cpioChannel;
    private RpmFileEntry currentEntry;
    private EntryInputStream openedStream;
    private String[] digests;
    private int[] fileFlags;
    private String fileDigestAlgorithm;
    private Iterator<Archive.FileEntry> lastIterator;
    private boolean skipLinks = true;
    private int metadataIndex = -1;
    private int relocationsIndex = -1;
    private List<String> relocationRoots = null;
    private Properties componentMeta;
    private ByteArrayOutputStream captureMetaContents;

    public RpmArchive(Path rpmPath, Feedback fb, boolean verify) throws IOException {
        this.rpmPath = rpmPath;
        this.fb = fb.withBundle(this.getClass());
        this.verifyIntegrity = verify;
        FileChannel raw = FileChannel.open(rpmPath, StandardOpenOption.READ);
        ReadableChannelWrapper in = new ReadableChannelWrapper((ReadableByteChannel)raw);
        try {
            Format format = new Format();
            ChannelWrapper.Key headerStartKey = in.start();
            format.getLead().read((ReadableByteChannel)in);
            format.getSignature().read((ReadableByteChannel)in);
            Integer hsp = (Integer)in.finish(headerStartKey);
            format.getHeader().setStartPos(hsp.intValue());
            ChannelWrapper.Key headerKey = in.start();
            format.getHeader().read((ReadableByteChannel)in);
            Integer headerLength = (Integer)in.finish(headerKey);
            format.getHeader().setEndPos(hsp + headerLength);
            this.rpmFileChannel = raw;
            this.cpioStartPos = hsp + headerLength;
            this.rpmHeader = format.getHeader();
            this.rpmFormat = format;
            this.headerStartPos = hsp.intValue();
            AbstractHeader.Entry prefE = this.rpmHeader.getEntry((AbstractHeader.Tag)Header.HeaderTag.PREFIXES);
            if (prefE != null) {
                for (String p : (String[])prefE.getValues()) {
                    this.filePrefixes.put(p, "");
                }
            }
            AbstractHeader.Entry flags = this.rpmHeader.getEntry((AbstractHeader.Tag)Header.HeaderTag.FILEFLAGS);
            this.fileFlags = (int[])flags.getValues();
        }
        catch (RuntimeException ex) {
            throw new IOException(ex.getLocalizedMessage(), ex);
        }
    }

    public void setFilePrefixes(Map<String, String> prefixes) {
        this.filePrefixes.clear();
        this.filePrefixes.putAll(prefixes);
    }

    public void setMetadataFileIndex(int mi) {
        this.metadataIndex = mi;
    }

    public void setRelocationsFileIndex(int ri) {
        this.relocationsIndex = ri;
    }

    int getMetadataFileIndex() {
        return this.metadataIndex;
    }

    int getRelocationsFileIndex() {
        return this.metadataIndex;
    }

    public boolean isSkipLinks() {
        return this.skipLinks;
    }

    public void setSkipLinks(boolean skipLinks) {
        this.skipLinks = skipLinks;
    }

    private void ensureOpen() throws IOException {
        if (this.rpmFileChannel == null || !this.rpmFileChannel.isOpen()) {
            this.rpmFileChannel = FileChannel.open(this.rpmPath, StandardOpenOption.READ);
        }
    }

    private void finishCurrentEntry() {
        try {
            if (this.currentEntry != null) {
                this.currentEntry.finish();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.currentEntry = null;
        this.openedStream = null;
    }

    public InputStream getInputStream(Archive.FileEntry e) throws IOException {
        this.ensureOpen();
        return ((RpmFileEntry)e).openInputStream();
    }

    private int h2b(Archive.FileEntry e, char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw this.fb.failure("ERR_InvalidDigestContent", null, new Object[]{e.getName()});
    }

    private byte[] findDigest(Archive.FileEntry e) {
        int index;
        RpmFileEntry rfe = (RpmFileEntry)e;
        if (this.digests == null) {
            AbstractHeader.Entry dgE = this.rpmHeader.getEntry((AbstractHeader.Tag)Header.HeaderTag.FILEDIGESTS);
            if (dgE == null) {
                return null;
            }
            this.digests = (String[])dgE.getValues();
            AbstractHeader.Entry algoE = this.rpmHeader.getEntry(5011);
            if (algoE == null) {
                AbstractHeader.Entry algoE2;
                algoE = algoE2 = this.rpmHeader.getEntry(1177);
            }
            if (algoE != null) {
                this.fileDigestAlgorithm = RpmUtils.digestAlgorithm(((int[])algoE.getValues())[0]);
                if (this.fileDigestAlgorithm == null) {
                    throw this.fb.failure("ERR_DigestUnsupported", null, new Object[]{((int[])algoE.getValues())[0]});
                }
            } else {
                this.fileDigestAlgorithm = "MD5";
            }
        }
        if ((index = rfe.index) > this.digests.length) {
            throw this.fb.failure("ERR_InvalidDigestIndex", null, new Object[]{e.getName()});
        }
        String dg = this.digests[index];
        if ((dg.length() & 1) > 0) {
            throw this.fb.failure("ERR_InvalidDigestContent", null, new Object[]{e.getName()});
        }
        byte[] dgBytes = new byte[dg.length() / 2];
        for (int i = 0; i < dgBytes.length; ++i) {
            byte b;
            int p = i * 2;
            dgBytes[i] = b = (byte)((this.h2b(e, dg.charAt(p)) << 4) + this.h2b(e, dg.charAt(p + 1)));
        }
        return dgBytes;
    }

    public boolean checkContentsMatches(ReadableByteChannel bc, Archive.FileEntry entry) throws IOException {
        if (entry.isDirectory() || entry.isSymbolicLink()) {
            return true;
        }
        byte[] digest = this.findDigest(entry);
        if (digest == null) {
            return false;
        }
        try {
            MessageDigest dg = MessageDigest.getInstance(this.fileDigestAlgorithm);
            ByteBuffer buffer = ByteBuffer.allocate(4096);
            while (bc.read(buffer) != -1) {
                buffer.flip();
                dg.update(buffer);
                buffer.rewind();
            }
            byte[] contentDigest = dg.digest();
            if (contentDigest.length != digest.length) {
                return false;
            }
            for (int i = 0; i < contentDigest.length; ++i) {
                if (digest[i] == contentDigest[i]) continue;
                return false;
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw this.fb.failure("ERR_DigestUnavailable", (Throwable)ex, new Object[]{this.fileDigestAlgorithm});
        }
        return true;
    }

    public Iterator<Archive.FileEntry> iterator() {
        try {
            return this.createIterator(false);
        }
        catch (IOException ex) {
            throw this.fb.failure("ERR_AccessRpmContents", (Throwable)ex, new Object[]{this.rpmPath.toString(), ex.getLocalizedMessage()});
        }
    }

    ContentIterator createIterator(boolean invis) throws IOException {
        this.finishCurrentEntry();
        this.ensureOpen();
        this.rpmFileChannel.position(this.cpioStartPos);
        InputStream uncompressed = Util.openPayloadStream((Header)this.rpmHeader, (InputStream)Channels.newInputStream(this.rpmFileChannel));
        return new ContentIterator(uncompressed, invis);
    }

    public void close() throws IOException {
        this.finishCurrentEntry();
        this.cpioChannel = null;
        if (this.rpmFileChannel != null) {
            this.rpmFileChannel.close();
        }
    }

    public boolean verifyIntegrity(CommandInput input) throws IOException {
        PGPPublicKey pkey;
        if (!this.verifyIntegrity) {
            return true;
        }
        try {
            pkey = RpmUtils.loadPublicKey(input, this.fb);
        }
        catch (IOException ex) {
            throw this.fb.failure("ERR_PublicKeyError", (Throwable)ex, new Object[]{ex.getLocalizedMessage()});
        }
        if (pkey != null && !this.verifyHeaderSignature(pkey)) {
            return false;
        }
        return this.verifyFileHashes();
    }

    boolean verifyHeaderSignature(PGPPublicKey pkey) throws IOException {
        AbstractHeader.Entry en = this.rpmFormat.getSignature().getEntry((AbstractHeader.Tag)Signature.SignatureTag.RSAHEADER);
        if (en == null) {
            return true;
        }
        byte[] sign = (byte[])en.getValues();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(sign);){
            boolean bl;
            block19: {
                InputStream signature = PGPUtil.getDecoderStream((InputStream)bais);
                try {
                    JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(signature);
                    PGPSignatureList sigList = (PGPSignatureList)pgpFact.nextObject();
                    PGPSignature sig = null;
                    for (PGPSignature candidate : sigList) {
                        if (candidate.getKeyID() != pkey.getKeyID()) continue;
                        sig = candidate;
                        break;
                    }
                    if (sig == null) {
                        throw this.fb.failure("ERR_TrustedSignatureNotFound", null, new Object[0]);
                    }
                    SeekableByteChannel raw = this.rpmFileChannel.position(this.headerStartPos);
                    ByteBuffer bb = ByteBuffer.allocate(4096);
                    try {
                        int r;
                        sig.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider(), pkey);
                        for (long size = (long)this.rpmHeader.getEndPos() - this.headerStartPos; size > 0L; size -= (long)r) {
                            if ((long)bb.limit() > size) {
                                bb.limit((int)size);
                            }
                            if ((r = raw.read(bb)) < 0) break;
                            bb.flip();
                            sig.update(bb.array(), bb.arrayOffset(), bb.limit());
                            bb.clear();
                        }
                        if (!sig.verify()) {
                            throw this.fb.failure("ERR_HeaderBroken", null, new Object[0]);
                        }
                    }
                    catch (PGPException ex) {
                        throw this.fb.failure("ERR_VerifyHeader", (Throwable)ex, new Object[]{ex.getLocalizedMessage()});
                    }
                    bl = true;
                    if (signature == null) break block19;
                }
                catch (Throwable throwable) {
                    if (signature != null) {
                        try {
                            signature.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                signature.close();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean verifyFileHashes() throws IOException {
        AbstractHeader.Entry digestsEntry = this.rpmHeader.getEntry((AbstractHeader.Tag)Header.HeaderTag.FILEDIGESTS);
        if (digestsEntry == null) {
            return true;
        }
        this.fb.outputPart("PROGRESS_VerifyingIntegrity", new Object[0]);
        try {
            Iterator<Archive.FileEntry> iterator = this.iterator();
            while (iterator.hasNext()) {
                MessageDigest dg;
                Archive.FileEntry fe = iterator.next();
                if (fe.isDirectory()) continue;
                byte[] fileDigest = this.findDigest(fe);
                ByteBuffer bb = ByteBuffer.allocate(4096);
                try {
                    dg = MessageDigest.getInstance(this.fileDigestAlgorithm);
                }
                catch (NoSuchAlgorithmException ex) {
                    throw this.fb.failure("ERR_UnsupportedDigestAlgorithm", (Throwable)ex, new Object[]{this.fileDigestAlgorithm});
                }
                try (InputStream contents = this.getInputStream(fe);
                     ReadableByteChannel bch = Channels.newChannel(contents);){
                    int r;
                    while ((r = bch.read(bb)) >= 0) {
                        bb.flip();
                        dg.update(bb);
                        bb.clear();
                    }
                }
                byte[] digest = dg.digest();
                if (Arrays.equals(fileDigest, digest)) continue;
                throw this.fb.failure("ERR_FileBroken", null, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            this.fb.output("PROGRESS_VerifyingIntegrityDone", new Object[]{false});
            throw throwable;
        }
        this.fb.output("PROGRESS_VerifyingIntegrityDone", new Object[]{false});
        return true;
    }

    void finishMetadata() {
        if (this.captureMetaContents != null) {
            try {
                this.captureMetaContents.close();
                ByteArrayInputStream bais = new ByteArrayInputStream(this.captureMetaContents.toByteArray());
                InputStreamReader r = new InputStreamReader((InputStream)bais, "UTF-8");
                Properties p = new Properties();
                p.load(r);
                this.componentMeta = p;
            }
            catch (IOException ex) {
                this.fb.verboseOutput("RPM_MetadataBroken", new Object[]{ex.getLocalizedMessage()});
            }
            this.captureMetaContents = null;
        }
    }

    void skipBytes(int bytes, ReadableByteChannel in) throws IOException {
        int r;
        ByteBuffer bb = ByteBuffer.allocate(4096);
        for (int counter = bytes; counter > 0; counter -= r) {
            bb.rewind().limit(Math.min(counter, bb.capacity()));
            r = in.read(bb);
            if (this.captureMetaContents == null) continue;
            bb.flip();
            byte[] ar = bb.array();
            int off = bb.position() + bb.arrayOffset();
            int len = bb.remaining();
            this.captureMetaContents.write(ar, off, len);
        }
    }

    Header getRpmHeader() {
        return this.rpmHeader;
    }

    int getFileIndex(Archive.FileEntry fe) {
        return ((RpmFileEntry)fe).index;
    }

    Archive.FileEntry findEntryByIndex(int index) throws IOException {
        RpmFileEntry ret = null;
        ContentIterator ie = this.createIterator(true);
        while (index >= ie.headerIndex) {
            if (!ie.hasNext()) continue;
            RpmFileEntry e = (RpmFileEntry)ie.next();
            if (e.index != index) continue;
            ret = e;
            break;
        }
        return ret;
    }

    Map<String, String> readRelocations() throws IOException {
        Properties relocs;
        if (this.relocationRoots != null) {
            return this.filePrefixes;
        }
        this.relocationRoots = Collections.emptyList();
        if (this.relocationsIndex == -1) {
            return this.filePrefixes;
        }
        Archive.FileEntry relocEntry = this.findEntryByIndex(this.relocationsIndex);
        if (relocEntry == null) {
            throw new IllegalStateException("Relocation file not found");
        }
        try (InputStream is = this.getInputStream(relocEntry);){
            relocs = new Properties();
            relocs.load(is);
        }
        ArrayList<String> roots = new ArrayList<String>(relocs.stringPropertyNames());
        Collections.sort(roots, Comparator.naturalOrder().reversed());
        HashMap<String, String> map = new HashMap<String, String>(roots.size());
        this.filePrefixes.clear();
        for (String k : roots) {
            String target = relocs.getProperty(k, "").trim();
            if (target.isEmpty()) {
                this.filePrefixes.put(k, null);
                continue;
            }
            if (target.startsWith("/")) {
                this.filePrefixes.put(k, target.substring(1));
                continue;
            }
            this.filePrefixes.put(k, target);
        }
        this.relocationRoots = roots;
        return map;
    }

    public void completeMetadata(ComponentInfo info) throws IOException {
        if (this.metadataIndex == -1) {
            return;
        }
        Properties meta = this.componentMeta;
        if (meta == null) {
            Archive.FileEntry e = this.findEntryByIndex(this.metadataIndex);
            Properties p = new Properties();
            try (InputStream is = this.getInputStream(e);){
                p.load(is);
            }
            meta = this.componentMeta = p;
        }
        DirectoryStorage.propertiesToMeta((Properties)meta, (ComponentInfo)info, (Feedback)this.fb);
    }

    Properties getComponentMetaProperties() {
        return this.componentMeta;
    }

    class RpmFileEntry
    implements Archive.FileEntry {
        final CpioHeader header;
        final String path;
        final ReadableByteChannel dataChannel;
        final int index;
        String linkTarget;
        EntryInputStream openedStream;

        RpmFileEntry(int idx, CpioHeader header, String path, ReadableByteChannel skipChannel) {
            this.index = idx;
            this.header = header;
            this.path = path;
            this.dataChannel = skipChannel;
        }

        public String getName() {
            return this.path;
        }

        public boolean isDirectory() {
            return this.header.getType() == 4;
        }

        public boolean isSymbolicLink() {
            return this.header.getType() == 10;
        }

        public String getLinkTarget() throws IOException {
            if (this.linkTarget != null) {
                return this.linkTarget;
            }
            this.checkCurrentEntry();
            ByteBuffer bb = ByteBuffer.allocate((int)this.getSize());
            try (InputStream istm = RpmArchive.this.getInputStream(this);
                 ReadableByteChannel ch = Channels.newChannel(istm);){
                ch.read(bb);
            }
            try {
                this.linkTarget = new String(bb.array(), "UTF-8");
                return this.linkTarget;
            }
            catch (UnsupportedEncodingException ex) {
                return null;
            }
        }

        public long getSize() {
            return this.header.getFileSize();
        }

        InputStream openInputStream() throws IOException {
            this.checkCurrentEntry();
            if (this.openedStream != null) {
                throw new IOException("Already opened");
            }
            this.openedStream = new EntryInputStream(this.header.getFileSize(), Channels.newInputStream(this.dataChannel));
            return this.openedStream;
        }

        void finish() throws IOException {
            if (this.openedStream != null) {
                this.openedStream.close();
            } else {
                RpmArchive.this.skipBytes(this.header.getFileSize(), this.dataChannel);
            }
            RpmArchive.this.finishMetadata();
        }

        private void checkCurrentEntry() {
            if (RpmArchive.this.currentEntry != this) {
                throw RpmArchive.this.fb.failure("ERR_ObsoleteRPMEntry", null, new Object[]{this.path});
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.isSymbolicLink()) {
                sb.append("LINK:");
            } else if (this.isDirectory()) {
                sb.append("DIR:");
            } else {
                sb.append("FILE:");
            }
            sb.append(this.path);
            sb.append("(").append(this.getSize()).append(")");
            return sb.toString();
        }
    }

    class EntryInputStream
    extends FilterInputStream {
        private final long totalSize;
        private long readSize;
        private boolean closed;

        EntryInputStream(long total, InputStream in) {
            super(in);
            this.totalSize = total;
            RpmArchive.this.openedStream = this;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            long len2 = (int)Math.min(this.totalSize - this.readSize, (long)len);
            if (len > 0 && len2 == 0L) {
                return -1;
            }
            int r = super.read(b, off, (int)len2);
            this.readSize += (long)r;
            return r;
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.finish();
            }
            this.closed = true;
        }

        public void finish() throws IOException {
            if (RpmArchive.this.openedStream == this) {
                if (this.totalSize > this.readSize) {
                    RpmArchive.this.skipBytes((int)(this.totalSize - this.readSize), Channels.newChannel(this));
                }
                RpmArchive.this.finishMetadata();
            }
        }
    }

    class ContentIterator
    implements Iterator<Archive.FileEntry> {
        final ReadableChannelWrapper in;
        final boolean allowInvisible;
        boolean last;
        CpioHeader header;
        String name;
        int total;
        int nextTotal;
        int headerIndex;

        ContentIterator(InputStream uncompressed, boolean allow) {
            RpmArchive.this.lastIterator = this;
            this.in = new ReadableChannelWrapper(Channels.newChannel(uncompressed));
            RpmArchive.this.cpioChannel = null;
            this.allowInvisible = allow;
        }

        private void checkActive() {
            if (RpmArchive.this.lastIterator != this) {
                throw RpmArchive.this.fb.failure("ERR_ContentsParallelRead", null, new Object[0]);
            }
        }

        /*
         * Unable to fully structure code
         */
        private void readItem() throws IOException {
            this.checkActive();
            block4: while (true) {
                if (this.last) {
                    return;
                }
                RpmArchive.this.finishCurrentEntry();
                hd = new CpioHeader();
                nI = this.headerIndex++;
                this.total = hd.read((ReadableByteChannel)this.in, this.nextTotal);
                this.header = hd;
                this.last = this.header.isLast();
                this.nextTotal = this.total + hd.getFileSize();
                if (this.last) {
                    this.header = null;
                    return;
                }
                path = hd.getName();
                if (path.startsWith("./")) {
                    path = path.substring(1);
                }
                process = true;
                if (!RpmArchive.this.filePrefixes.isEmpty()) {
                    process = false;
                    for (String pref : RpmArchive.this.filePrefixes.keySet()) {
                        if (!path.startsWith(pref)) continue;
                        target = RpmArchive.this.filePrefixes.get(pref);
                        if (target != null) {
                            if (path.equals(pref)) {
                                if (target.isEmpty()) {
                                    target = null;
                                }
                            } else {
                                path = target + path.substring(pref.length() + 1);
                            }
                        }
                        if (target == null) break;
                        process = true;
                        break;
                    }
                    if (!process) {
                        RpmArchive.this.skipBytes(hd.getFileSize(), (ReadableByteChannel)this.in);
                        continue;
                    }
                } else if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                this.name = path;
                if (nI == RpmArchive.this.metadataIndex) {
                    RpmArchive.this.captureMetaContents = new ByteArrayOutputStream(1024);
                    process = false;
                } else {
                    RpmArchive.this.captureMetaContents = null;
                    v0 = process = nI != RpmArchive.this.relocationsIndex;
                }
                if (!this.allowInvisible && (!process || (RpmArchive.this.fileFlags[nI] & 64) != 0)) ** GOTO lbl-1000
                switch (hd.getType()) {
                    case 4: 
                    case 8: {
                        break block4;
                    }
                    case 10: {
                        if (!RpmArchive.this.skipLinks) break block4;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        RpmArchive.this.skipBytes(hd.getFileSize(), (ReadableByteChannel)this.in);
                        RpmArchive.this.finishMetadata();
                        continue block4;
                    }
                }
                break;
            }
            if (RpmArchive.this.cpioChannel == null) {
                RpmArchive.this.cpioChannel = this.in;
            }
            --this.headerIndex;
        }

        @Override
        public boolean hasNext() {
            if (this.last) {
                return false;
            }
            if (this.header != null) {
                return true;
            }
            try {
                this.readItem();
            }
            catch (IOException | IllegalStateException ex) {
                throw RpmArchive.this.fb.failure("ERR_AccessRpmContents", (Throwable)ex, new Object[]{RpmArchive.this.rpmPath.toString(), ex.getLocalizedMessage()});
            }
            return !this.last;
        }

        @Override
        public Archive.FileEntry next() {
            if (this.header == null && !this.last && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.checkActive();
            RpmArchive.this.finishCurrentEntry();
            CpioHeader ret = this.header;
            if (this.last && ret == null) {
                throw new NoSuchElementException();
            }
            this.header = null;
            RpmArchive.this.currentEntry = new RpmFileEntry(this.headerIndex++, ret, this.name, (ReadableByteChannel)this.in);
            return RpmArchive.this.currentEntry;
        }
    }
}

