/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.utils;

import com.oracle.truffle.api.source.SourceSection;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.Position;
import org.graalvm.tools.lsp.server.types.Range;

public final class SourceSectionReference {
    private int startLine;
    private int endLine;
    private int startColumn;
    private int endColumn;

    private SourceSectionReference() {
    }

    public SourceSectionReference(SourceSectionReference section) {
        this.startLine = section.startLine;
        this.endLine = section.endLine;
        this.startColumn = section.startColumn;
        this.endColumn = section.endColumn;
    }

    public static SourceSectionReference from(SourceSection section) {
        SourceSectionReference mutableSection = new SourceSectionReference();
        mutableSection.startLine = section.getStartLine();
        mutableSection.endLine = section.getEndLine();
        mutableSection.startColumn = section.getStartColumn();
        mutableSection.endColumn = section.getEndColumn();
        return mutableSection;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int startLine) {
        this.startLine = startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public void setStartColumn(int startColumn) {
        this.startColumn = startColumn;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public void setEndColumn(int endColumn) {
        this.endColumn = endColumn;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SourceSectionReference)) {
            return false;
        }
        SourceSectionReference other = (SourceSectionReference)obj;
        return this.startLine == other.startLine && this.endLine == other.endLine && this.startColumn == other.startColumn && this.endColumn == other.endColumn;
    }

    public int hashCode() {
        return Objects.hash(this.startLine, this.startColumn, this.endLine, this.endColumn);
    }

    public String toString() {
        return String.format("Location[%d:%d - %d:%d]", this.startLine, this.startColumn, this.endLine, this.endColumn);
    }

    public boolean includes(Range range) {
        Position start = range.getStart();
        Position end = range.getEnd();
        int otherStartLine = start.getLine() + 1;
        int otherEndLine = end.getLine() + 1;
        if (this.startLine < otherStartLine && otherEndLine < this.endLine) {
            return true;
        }
        int otherStartColumn = start.getCharacter() + 1;
        int otherEndColumn = end.getCharacter() + 1;
        return (this.startLine < otherStartLine || this.startLine == otherStartLine && this.startColumn <= otherStartColumn) && (otherEndLine < this.endLine || otherEndLine == this.endLine && otherEndColumn <= this.endColumn);
    }

    public boolean before(Range range) {
        Position start = range.getStart();
        int otherStartLine = start.getLine() + 1;
        int otherStartColumn = start.getCharacter() + 1;
        return this.endLine < otherStartLine || this.endLine == otherStartLine && this.endColumn < otherStartColumn;
    }

    public boolean behind(Range range) {
        Position end = range.getEnd();
        int otherEndLine = end.getLine() + 1;
        int otherEndColumn = end.getCharacter() + 1;
        return otherEndLine < this.startLine || otherEndLine == this.startLine && otherEndColumn < this.startColumn;
    }
}

