/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.TextDocumentIdentifier;

public class VersionedTextDocumentIdentifier
extends TextDocumentIdentifier {
    VersionedTextDocumentIdentifier(JSONObject jsonData) {
        super(jsonData);
    }

    public Integer getVersion() {
        Object obj = this.jsonData.get("version");
        return JSONObject.NULL.equals(obj) ? null : (Integer)obj;
    }

    public VersionedTextDocumentIdentifier setVersion(Integer version) {
        this.jsonData.put("version", version == null ? JSONObject.NULL : version);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionedTextDocumentIdentifier other = (VersionedTextDocumentIdentifier)obj;
        if (!Objects.equals(this.getVersion(), other.getVersion())) {
            return false;
        }
        return Objects.equals(this.getUri(), other.getUri());
    }

    @Override
    public int hashCode() {
        int hash = 7;
        if (this.getVersion() != null) {
            hash = 73 * hash + Integer.hashCode(this.getVersion());
        }
        hash = 73 * hash + Objects.hashCode(this.getUri());
        return hash;
    }

    public static VersionedTextDocumentIdentifier create(String uri, Integer version) {
        JSONObject json = new JSONObject();
        json.put("version", version == null ? JSONObject.NULL : version);
        json.put("uri", uri);
        return new VersionedTextDocumentIdentifier(json);
    }
}

