/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.Unregistration;

public class UnregistrationParams
extends JSONBase {
    UnregistrationParams(JSONObject jsonData) {
        super(jsonData);
    }

    public List<Unregistration> getUnregisterations() {
        JSONArray json = this.jsonData.getJSONArray("unregisterations");
        ArrayList<Unregistration> list = new ArrayList<Unregistration>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new Unregistration(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public UnregistrationParams setUnregisterations(List<Unregistration> unregisterations) {
        JSONArray json = new JSONArray();
        for (Unregistration unregistration : unregisterations) {
            json.put(unregistration.jsonData);
        }
        this.jsonData.put("unregisterations", json);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnregistrationParams other = (UnregistrationParams)obj;
        return Objects.equals(this.getUnregisterations(), other.getUnregisterations());
    }

    public int hashCode() {
        int hash = 2;
        hash = 37 * hash + Objects.hashCode(this.getUnregisterations());
        return hash;
    }

    public static UnregistrationParams create(List<Unregistration> unregisterations) {
        JSONObject json = new JSONObject();
        JSONArray unregisterationsJsonArr = new JSONArray();
        for (Unregistration unregistration : unregisterations) {
            unregisterationsJsonArr.put(unregistration.jsonData);
        }
        json.put("unregisterations", unregisterationsJsonArr);
        return new UnregistrationParams(json);
    }
}

