/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.SignatureHelp;
import org.graalvm.tools.lsp.server.types.SignatureHelpTriggerKind;

public class SignatureHelpContext
extends JSONBase {
    SignatureHelpContext(JSONObject jsonData) {
        super(jsonData);
    }

    public SignatureHelpTriggerKind getTriggerKind() {
        return SignatureHelpTriggerKind.get(this.jsonData.getInt("triggerKind"));
    }

    public SignatureHelpContext setTriggerKind(SignatureHelpTriggerKind triggerKind) {
        this.jsonData.put("triggerKind", triggerKind.getIntValue());
        return this;
    }

    public String getTriggerCharacter() {
        return this.jsonData.optString("triggerCharacter", null);
    }

    public SignatureHelpContext setTriggerCharacter(String triggerCharacter) {
        this.jsonData.putOpt("triggerCharacter", triggerCharacter);
        return this;
    }

    public boolean isRetrigger() {
        return this.jsonData.getBoolean("isRetrigger");
    }

    public SignatureHelpContext setRetrigger(boolean isRetrigger) {
        this.jsonData.put("isRetrigger", isRetrigger);
        return this;
    }

    public SignatureHelp getActiveSignatureHelp() {
        return this.jsonData.has("activeSignatureHelp") ? new SignatureHelp(this.jsonData.optJSONObject("activeSignatureHelp")) : null;
    }

    public SignatureHelpContext setActiveSignatureHelp(SignatureHelp activeSignatureHelp) {
        this.jsonData.putOpt("activeSignatureHelp", activeSignatureHelp != null ? activeSignatureHelp.jsonData : null);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignatureHelpContext other = (SignatureHelpContext)obj;
        if (this.getTriggerKind() != other.getTriggerKind()) {
            return false;
        }
        if (!Objects.equals(this.getTriggerCharacter(), other.getTriggerCharacter())) {
            return false;
        }
        if (this.isRetrigger() != other.isRetrigger()) {
            return false;
        }
        return Objects.equals(this.getActiveSignatureHelp(), other.getActiveSignatureHelp());
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hashCode((Object)this.getTriggerKind());
        if (this.getTriggerCharacter() != null) {
            hash = 31 * hash + Objects.hashCode(this.getTriggerCharacter());
        }
        hash = 31 * hash + Boolean.hashCode(this.isRetrigger());
        if (this.getActiveSignatureHelp() != null) {
            hash = 31 * hash + Objects.hashCode(this.getActiveSignatureHelp());
        }
        return hash;
    }

    public static SignatureHelpContext create(SignatureHelpTriggerKind triggerKind, Boolean isRetrigger) {
        JSONObject json = new JSONObject();
        json.put("triggerKind", triggerKind.getIntValue());
        json.put("isRetrigger", isRetrigger);
        return new SignatureHelpContext(json);
    }
}

