/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.SignatureInformation;

public class SignatureHelp
extends JSONBase {
    SignatureHelp(JSONObject jsonData) {
        super(jsonData);
    }

    public List<SignatureInformation> getSignatures() {
        JSONArray json = this.jsonData.getJSONArray("signatures");
        ArrayList<SignatureInformation> list = new ArrayList<SignatureInformation>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new SignatureInformation(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public SignatureHelp setSignatures(List<SignatureInformation> signatures) {
        JSONArray json = new JSONArray();
        for (SignatureInformation signatureInformation : signatures) {
            json.put(signatureInformation.jsonData);
        }
        this.jsonData.put("signatures", json);
        return this;
    }

    public Integer getActiveSignature() {
        Object obj = this.jsonData.get("activeSignature");
        return JSONObject.NULL.equals(obj) ? null : (Integer)obj;
    }

    public SignatureHelp setActiveSignature(Integer activeSignature) {
        this.jsonData.put("activeSignature", activeSignature == null ? JSONObject.NULL : activeSignature);
        return this;
    }

    public Integer getActiveParameter() {
        Object obj = this.jsonData.get("activeParameter");
        return JSONObject.NULL.equals(obj) ? null : (Integer)obj;
    }

    public SignatureHelp setActiveParameter(Integer activeParameter) {
        this.jsonData.put("activeParameter", activeParameter == null ? JSONObject.NULL : activeParameter);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignatureHelp other = (SignatureHelp)obj;
        if (!Objects.equals(this.getSignatures(), other.getSignatures())) {
            return false;
        }
        if (!Objects.equals(this.getActiveSignature(), other.getActiveSignature())) {
            return false;
        }
        return Objects.equals(this.getActiveParameter(), other.getActiveParameter());
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.getSignatures());
        if (this.getActiveSignature() != null) {
            hash = 73 * hash + Integer.hashCode(this.getActiveSignature());
        }
        if (this.getActiveParameter() != null) {
            hash = 73 * hash + Integer.hashCode(this.getActiveParameter());
        }
        return hash;
    }

    public static SignatureHelp create(List<SignatureInformation> signatures, Integer activeSignature, Integer activeParameter) {
        JSONObject json = new JSONObject();
        JSONArray signaturesJsonArr = new JSONArray();
        for (SignatureInformation signatureInformation : signatures) {
            signaturesJsonArr.put(signatureInformation.jsonData);
        }
        json.put("signatures", signaturesJsonArr);
        json.put("activeSignature", activeSignature == null ? JSONObject.NULL : activeSignature);
        json.put("activeParameter", activeParameter == null ? JSONObject.NULL : activeParameter);
        return new SignatureHelp(json);
    }
}

