/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.Message;

public class NotificationMessage
extends Message {
    NotificationMessage(JSONObject jsonData) {
        super(jsonData);
    }

    public String getMethod() {
        return this.jsonData.getString("method");
    }

    public NotificationMessage setMethod(String method) {
        this.jsonData.put("method", method);
        return this;
    }

    public Object getParams() {
        return this.jsonData.opt("params");
    }

    public NotificationMessage setParams(Object params) {
        this.jsonData.putOpt("params", params);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NotificationMessage other = (NotificationMessage)obj;
        if (!Objects.equals(this.getMethod(), other.getMethod())) {
            return false;
        }
        if (!Objects.equals(this.getParams(), other.getParams())) {
            return false;
        }
        return Objects.equals(this.getJsonrpc(), other.getJsonrpc());
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.getMethod());
        if (this.getParams() != null) {
            hash = 29 * hash + Objects.hashCode(this.getParams());
        }
        hash = 29 * hash + Objects.hashCode(this.getJsonrpc());
        return hash;
    }

    public static NotificationMessage create(String method, String jsonrpc) {
        JSONObject json = new JSONObject();
        json.put("method", method);
        json.put("jsonrpc", jsonrpc);
        return new NotificationMessage(json);
    }
}

