/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.tools.lsp.server.DelegateServers;
import org.graalvm.tools.lsp.server.TruffleAdapter;
import org.graalvm.tools.lsp.server.types.ApplyWorkspaceEditParams;
import org.graalvm.tools.lsp.server.types.ApplyWorkspaceEditResponse;
import org.graalvm.tools.lsp.server.types.CodeAction;
import org.graalvm.tools.lsp.server.types.CodeActionParams;
import org.graalvm.tools.lsp.server.types.CodeLens;
import org.graalvm.tools.lsp.server.types.CodeLensParams;
import org.graalvm.tools.lsp.server.types.ColorInformation;
import org.graalvm.tools.lsp.server.types.ColorPresentation;
import org.graalvm.tools.lsp.server.types.ColorPresentationParams;
import org.graalvm.tools.lsp.server.types.CompletionItem;
import org.graalvm.tools.lsp.server.types.CompletionList;
import org.graalvm.tools.lsp.server.types.CompletionParams;
import org.graalvm.tools.lsp.server.types.ConfigurationParams;
import org.graalvm.tools.lsp.server.types.DeclarationParams;
import org.graalvm.tools.lsp.server.types.DefinitionParams;
import org.graalvm.tools.lsp.server.types.DidChangeConfigurationParams;
import org.graalvm.tools.lsp.server.types.DidChangeTextDocumentParams;
import org.graalvm.tools.lsp.server.types.DidChangeWatchedFilesParams;
import org.graalvm.tools.lsp.server.types.DidChangeWorkspaceFoldersParams;
import org.graalvm.tools.lsp.server.types.DidCloseTextDocumentParams;
import org.graalvm.tools.lsp.server.types.DidOpenTextDocumentParams;
import org.graalvm.tools.lsp.server.types.DidSaveTextDocumentParams;
import org.graalvm.tools.lsp.server.types.DocumentColorParams;
import org.graalvm.tools.lsp.server.types.DocumentFormattingParams;
import org.graalvm.tools.lsp.server.types.DocumentHighlight;
import org.graalvm.tools.lsp.server.types.DocumentHighlightParams;
import org.graalvm.tools.lsp.server.types.DocumentLink;
import org.graalvm.tools.lsp.server.types.DocumentLinkParams;
import org.graalvm.tools.lsp.server.types.DocumentOnTypeFormattingParams;
import org.graalvm.tools.lsp.server.types.DocumentRangeFormattingParams;
import org.graalvm.tools.lsp.server.types.DocumentSymbolParams;
import org.graalvm.tools.lsp.server.types.ErrorCodes;
import org.graalvm.tools.lsp.server.types.ExecuteCommandParams;
import org.graalvm.tools.lsp.server.types.FoldingRange;
import org.graalvm.tools.lsp.server.types.FoldingRangeParams;
import org.graalvm.tools.lsp.server.types.Hover;
import org.graalvm.tools.lsp.server.types.HoverParams;
import org.graalvm.tools.lsp.server.types.ImplementationParams;
import org.graalvm.tools.lsp.server.types.InitializeParams;
import org.graalvm.tools.lsp.server.types.InitializeResult;
import org.graalvm.tools.lsp.server.types.InitializedParams;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.LanguageClient;
import org.graalvm.tools.lsp.server.types.Location;
import org.graalvm.tools.lsp.server.types.LogMessageParams;
import org.graalvm.tools.lsp.server.types.MessageActionItem;
import org.graalvm.tools.lsp.server.types.NotificationMessage;
import org.graalvm.tools.lsp.server.types.PrepareRenameParams;
import org.graalvm.tools.lsp.server.types.PublishDiagnosticsParams;
import org.graalvm.tools.lsp.server.types.Range;
import org.graalvm.tools.lsp.server.types.ReferenceParams;
import org.graalvm.tools.lsp.server.types.RegistrationParams;
import org.graalvm.tools.lsp.server.types.RenameParams;
import org.graalvm.tools.lsp.server.types.RequestMessage;
import org.graalvm.tools.lsp.server.types.ResponseErrorLiteral;
import org.graalvm.tools.lsp.server.types.ResponseMessage;
import org.graalvm.tools.lsp.server.types.SelectionRange;
import org.graalvm.tools.lsp.server.types.SelectionRangeParams;
import org.graalvm.tools.lsp.server.types.ServerCapabilities;
import org.graalvm.tools.lsp.server.types.ShowMessageParams;
import org.graalvm.tools.lsp.server.types.ShowMessageRequestParams;
import org.graalvm.tools.lsp.server.types.SignatureHelp;
import org.graalvm.tools.lsp.server.types.SignatureHelpParams;
import org.graalvm.tools.lsp.server.types.SymbolInformation;
import org.graalvm.tools.lsp.server.types.TextDocumentPositionParams;
import org.graalvm.tools.lsp.server.types.TextEdit;
import org.graalvm.tools.lsp.server.types.TypeDefinitionParams;
import org.graalvm.tools.lsp.server.types.UnregistrationParams;
import org.graalvm.tools.lsp.server.types.WillSaveTextDocumentParams;
import org.graalvm.tools.lsp.server.types.WorkDoneProgressCancelParams;
import org.graalvm.tools.lsp.server.types.WorkDoneProgressCreateParams;
import org.graalvm.tools.lsp.server.types.WorkspaceEdit;
import org.graalvm.tools.lsp.server.types.WorkspaceFolder;
import org.graalvm.tools.lsp.server.types.WorkspaceSymbolParams;

public class LanguageServer {
    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        throw new UnsupportedOperationException();
    }

    public void initialized(InitializedParams params) {
    }

    public CompletableFuture<Object> shutdown() {
        throw new UnsupportedOperationException();
    }

    public void exit() {
    }

    public void cancelProgress(WorkDoneProgressCancelParams params) {
    }

    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
    }

    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        throw new UnsupportedOperationException();
    }

    public void didOpen(DidOpenTextDocumentParams params) {
    }

    public void didChange(DidChangeTextDocumentParams params) {
    }

    public void willSave(WillSaveTextDocumentParams params) {
    }

    public CompletableFuture<List<? extends TextEdit>> willSaveWaitUntil(WillSaveTextDocumentParams params) {
        throw new UnsupportedOperationException();
    }

    public void didSave(DidSaveTextDocumentParams params) {
    }

    public void didClose(DidCloseTextDocumentParams params) {
    }

    public CompletableFuture<CompletionList> completion(CompletionParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<CompletionItem> resolveCompletion(CompletionItem params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Hover> hover(TextDocumentPositionParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<SignatureHelp> signatureHelp(TextDocumentPositionParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<? extends Location>> declaration(TextDocumentPositionParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<? extends Location>> definition(TextDocumentPositionParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<? extends Location>> typeDefinition(TextDocumentPositionParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<? extends Location>> implementation(TextDocumentPositionParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(TextDocumentPositionParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<? extends SymbolInformation>> documentSymbol(DocumentSymbolParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<? extends CodeAction>> codeAction(CodeActionParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<? extends DocumentLink>> documentLink(DocumentLinkParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<DocumentLink> resolveDocumentLink(DocumentLink params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<ColorInformation>> documentColor(DocumentColorParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<ColorPresentation>> colorPresentation(ColorPresentationParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Range> prepareRename(TextDocumentPositionParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<? extends FoldingRange>> foldingRange(FoldingRangeParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<? extends SelectionRange>> selectionRange(SelectionRangeParams params) {
        throw new UnsupportedOperationException();
    }

    protected void connect(LanguageClient client) {
    }

    protected boolean supportsMethod(String method, JSONObject params) {
        return true;
    }

    public LoggerProxy getLogger() {
        final Logger l = Logger.getLogger(LanguageServer.class.getName());
        return new LoggerProxy(){

            @Override
            public boolean isLoggable(Level level) {
                return l.isLoggable(level);
            }

            @Override
            public void log(Level level, String msg) {
                l.log(level, msg);
            }

            @Override
            public void log(Level level, String msg, Throwable thrown) {
                l.log(level, msg, thrown);
            }
        };
    }

    private static String format(String format, Object ... args) {
        return String.format(Locale.ENGLISH, format, args);
    }

    public static interface LoggerProxy {
        public boolean isLoggable(Level var1);

        public void log(Level var1, String var2);

        public void log(Level var1, String var2, Throwable var3);
    }

    public static final class Session
    implements Runnable {
        private static final String CONTENT_LENGTH_HEADER = "Content-Length:";
        private final LanguageServer server;
        private final InputStream in;
        private final OutputStream out;
        private final DelegateServers delegateServers;
        private final Map<Object, CompletableFuture<?>> pendingReceivedRequests = new ConcurrentHashMap();
        private boolean closed = false;

        private Session(LanguageServer server, InputStream in, OutputStream out, DelegateServers delegateServers) {
            this.server = server;
            this.in = in;
            this.out = out;
            this.delegateServers = delegateServers;
            this.server.connect(new LanguageClient(){

                @Override
                public void showMessage(ShowMessageParams params) {
                    this.sendNotification("window/showMessage", params);
                }

                @Override
                public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams params) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void logMessage(LogMessageParams params) {
                    this.sendNotification("window/logMessage", params);
                }

                @Override
                public void event(Object object) {
                    this.sendNotification("telemetry/event", object);
                }

                @Override
                public CompletableFuture<Void> createProgress(WorkDoneProgressCreateParams params) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public CompletableFuture<Void> registerCapability(RegistrationParams params) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public CompletableFuture<Void> unregisterCapability(UnregistrationParams params) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public CompletableFuture<List<WorkspaceFolder>> workspaceFolders() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public CompletableFuture<List<Object>> configuration(ConfigurationParams params) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public CompletableFuture<ApplyWorkspaceEditResponse> applyEdit(ApplyWorkspaceEditParams params) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void publishDiagnostics(PublishDiagnosticsParams params) {
                    this.sendNotification("textDocument/publishDiagnostics", params);
                }

                @Override
                public void sendCustomNotification(String method, Object params) {
                    this.sendNotification(method, params);
                }
            });
        }

        @Override
        public void run() {
            try {
                while (!this.closed) {
                    byte[] messageBytes = Session.readMessageBytes(this.in, this.server.getLogger());
                    if (messageBytes == null) {
                        this.closed = true;
                        continue;
                    }
                    this.processMessage(messageBytes);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.delegateServers.close();
            }
        }

        private static byte[] readMessageBytes(InputStream in, LoggerProxy logger) throws IOException {
            StringBuilder line = new StringBuilder();
            int contentLength = -1;
            int c;
            while ((c = in.read()) != -1) {
                if (c == 10) {
                    String header = line.toString().trim();
                    if (header.length() > 0) {
                        if (header.startsWith(CONTENT_LENGTH_HEADER)) {
                            try {
                                contentLength = Integer.parseInt(header.substring(CONTENT_LENGTH_HEADER.length()).trim());
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    } else if (contentLength < 0) {
                        logger.log(Level.SEVERE, "Error while processing an incomming message: Missing header Content-Length: in input.");
                    } else {
                        int read;
                        byte[] buffer = new byte[contentLength];
                        for (int bytesRead = 0; bytesRead < contentLength; bytesRead += read) {
                            read = in.read(buffer, bytesRead, contentLength - bytesRead);
                            if (read != -1) continue;
                            return null;
                        }
                        return buffer;
                    }
                    line = new StringBuilder();
                    continue;
                }
                if (c == 13) continue;
                line.append((char)c);
            }
            return null;
        }

        private void processMessage(byte[] messageBytes) {
            try {
                String content = new String(messageBytes, StandardCharsets.UTF_8);
                JSONObject json = new JSONObject(content);
                if (json.has("id")) {
                    RequestMessage message = new RequestMessage(json);
                    if (this.server.getLogger().isLoggable(Level.FINER)) {
                        String format = "[Trace - %s] Received request '%s - (%s)'\nParams: %s";
                        this.server.getLogger().log(Level.FINER, LanguageServer.format(format, Instant.now().toString(), message.getMethod(), message.getId(), message.getParams().toString()));
                    }
                    this.processRequest(message, messageBytes);
                } else {
                    NotificationMessage message = new NotificationMessage(json);
                    if (this.server.getLogger().isLoggable(Level.FINER)) {
                        String format = "[Trace - %s] Received notification '%s'\nParams: %s";
                        this.server.getLogger().log(Level.FINER, LanguageServer.format(format, Instant.now().toString(), message.getMethod(), message.getParams().toString()));
                    }
                    this.processNotification(message, messageBytes);
                }
            }
            catch (Exception e) {
                this.server.getLogger().log(Level.SEVERE, "Error while processing an incomming message: " + e.getMessage());
            }
        }

        private void processRequest(RequestMessage req, byte[] buffer) {
            Object id = req.getId();
            try {
                JSONObject params = req.getParams() instanceof JSONObject ? (JSONObject)req.getParams() : new JSONObject();
                CompletionStage<Void> future = null;
                String method = req.getMethod();
                this.delegateServers.sendMessageToDelegates(buffer, id, method, params);
                if (this.server.supportsMethod(method, params)) {
                    switch (method) {
                        case "initialize": {
                            future = this.server.initialize(new InitializeParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "shutdown": {
                            future = this.server.shutdown().thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "workspace/symbol": {
                            future = this.server.symbol(new WorkspaceSymbolParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "workspace/executeCommand": {
                            future = this.server.executeCommand(new ExecuteCommandParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/willSaveWaitUntil": {
                            future = this.server.willSaveWaitUntil(new WillSaveTextDocumentParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/completion": {
                            future = this.server.completion(new CompletionParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "completionItem/resolve": {
                            future = this.server.resolveCompletion(new CompletionItem(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/hover": {
                            future = this.server.hover(new HoverParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/signatureHelp": {
                            future = this.server.signatureHelp(new SignatureHelpParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/declaration": {
                            future = this.server.declaration(new DeclarationParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/definition": {
                            future = this.server.definition(new DefinitionParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/typeDefinition": {
                            future = this.server.typeDefinition(new TypeDefinitionParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/implementation": {
                            future = this.server.implementation(new ImplementationParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/references": {
                            future = this.server.references(new ReferenceParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/documentHighlight": {
                            future = this.server.documentHighlight(new DocumentHighlightParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/documentSymbol": {
                            future = this.server.documentSymbol(new DocumentSymbolParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/codeAction": {
                            future = this.server.codeAction(new CodeActionParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/codeLens": {
                            future = this.server.codeLens(new CodeLensParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "codeLens/resolve": {
                            future = this.server.resolveCodeLens(new CodeLens(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/documentLink": {
                            future = this.server.documentLink(new DocumentLinkParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "documentLink/resolve": {
                            future = this.server.resolveDocumentLink(new DocumentLink(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/documentColor": {
                            future = this.server.documentColor(new DocumentColorParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/colorPresentation": {
                            future = this.server.colorPresentation(new ColorPresentationParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/formatting": {
                            future = this.server.formatting(new DocumentFormattingParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/rangeFormatting": {
                            future = this.server.rangeFormatting(new DocumentRangeFormattingParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/onTypeFormatting": {
                            future = this.server.onTypeFormatting(new DocumentOnTypeFormattingParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/rename": {
                            future = this.server.rename(new RenameParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/prepareRename": {
                            future = this.server.prepareRename(new PrepareRenameParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/foldingRange": {
                            future = this.server.foldingRange(new FoldingRangeParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        case "textDocument/selectionRange": {
                            future = this.server.selectionRange(new SelectionRangeParams(params)).thenAccept(result -> this.sendResponse(id, result));
                            break;
                        }
                        default: {
                            this.sendErrorResponse(id, ErrorCodes.InvalidRequest, LanguageServer.format("Unexpected method `%s`", req.getMethod()));
                            break;
                        }
                    }
                } else {
                    future = CompletableFuture.runAsync(() -> this.sendResponse(id, null));
                }
                if (future != null) {
                    this.pendingReceivedRequests.put(id, (CompletableFuture<?>)future);
                    ((CompletableFuture)future.exceptionally(throwable -> {
                        if (this.isCancel((Throwable)throwable)) {
                            String msg = LanguageServer.format("The request '%s - (%s)' has been cancelled", req.getMethod(), id);
                            this.sendErrorResponse(id, ErrorCodes.RequestCancelled, msg);
                        } else {
                            this.sendErrorResponse(id, ErrorCodes.InternalError, throwable.getMessage());
                        }
                        return null;
                    })).thenApply(obj -> {
                        this.pendingReceivedRequests.remove(id);
                        return null;
                    });
                }
            }
            catch (Exception e) {
                this.server.getLogger().log(Level.SEVERE, e.getMessage(), e);
                this.sendErrorResponse(id, ErrorCodes.InternalError, e.getMessage());
            }
        }

        private void processNotification(NotificationMessage msg, byte[] buffer) {
            try {
                JSONObject params = msg.getParams() instanceof JSONObject ? (JSONObject)msg.getParams() : new JSONObject();
                String method = msg.getMethod();
                this.delegateServers.sendMessageToDelegates(buffer, null, method, params);
                switch (method) {
                    case "initialized": {
                        this.server.initialized(new InitializedParams(params));
                        break;
                    }
                    case "exit": {
                        this.server.exit();
                        break;
                    }
                    case "window/workDoneProgress/cancel": {
                        this.server.cancelProgress(new WorkDoneProgressCancelParams(params));
                        break;
                    }
                    case "workspace/didChangeWorkspaceFolders": {
                        this.server.didChangeWorkspaceFolders(new DidChangeWorkspaceFoldersParams(params));
                        break;
                    }
                    case "workspace/didChangeConfiguration": {
                        this.server.didChangeConfiguration(new DidChangeConfigurationParams(params));
                        break;
                    }
                    case "workspace/didChangeWatchedFiles": {
                        this.server.didChangeWatchedFiles(new DidChangeWatchedFilesParams(params));
                        break;
                    }
                    case "textDocument/didOpen": {
                        this.server.didOpen(new DidOpenTextDocumentParams(params));
                        break;
                    }
                    case "textDocument/didChange": {
                        this.server.didChange(new DidChangeTextDocumentParams(params));
                        break;
                    }
                    case "textDocument/willSave": {
                        this.server.willSave(new WillSaveTextDocumentParams(params));
                        break;
                    }
                    case "textDocument/didSave": {
                        this.server.didSave(new DidSaveTextDocumentParams(params));
                        break;
                    }
                    case "textDocument/didClose": {
                        this.server.didClose(new DidCloseTextDocumentParams(params));
                        break;
                    }
                    case "$/cancelRequest": {
                        Object id = params.get("id");
                        CompletableFuture<?> pending = this.pendingReceivedRequests.get(id);
                        if (pending != null) {
                            pending.cancel(true);
                        }
                        break;
                    }
                    default: {
                        this.server.getLogger().log(Level.WARNING, LanguageServer.format("Unexpected method `%s`", msg.getMethod()));
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.server.getLogger().log(Level.SEVERE, e.getMessage(), e);
            }
        }

        private void sendResponse(Object id, Object result) {
            ResponseMessage response = ResponseMessage.create(id, "2.0");
            Object allResults = this.delegateServers.mergeResults(id, Session.getJSONData(result));
            response.setResult(allResults != null ? allResults : JSONObject.NULL);
            if (this.server.getLogger().isLoggable(Level.FINER)) {
                String format = "[Trace - %s] Sending response '(%s)'\nResult: %s";
                this.server.getLogger().log(Level.FINER, LanguageServer.format(format, Instant.now().toString(), id, Objects.toString(allResults)));
            }
            this.writeMessage(Session.getJSONData(response).toString());
        }

        private void sendErrorResponse(Object id, ErrorCodes code, String message) {
            ResponseMessage response = ResponseMessage.create(id, "2.0");
            Object allResults = this.delegateServers.mergeResults(id, null);
            if (allResults != null) {
                response.setResult(allResults);
                if (this.server.getLogger().isLoggable(Level.FINER)) {
                    String format = "[Trace - %s] Sending response '(%s)'\nResult: %s";
                    this.server.getLogger().log(Level.FINER, LanguageServer.format(format, Instant.now().toString(), id, allResults.toString()));
                }
            } else {
                ResponseErrorLiteral error = ResponseErrorLiteral.create(code.getIntValue(), message);
                response.setError(error);
                if (this.server.getLogger().isLoggable(Level.FINER)) {
                    String format = "[Trace - %s] Sending error response '(%s)'\nError: %s";
                    this.server.getLogger().log(Level.FINER, LanguageServer.format(format, Instant.now().toString(), id, Session.getJSONData(error).toString()));
                }
            }
            this.writeMessage(Session.getJSONData(response).toString());
        }

        private void sendNotification(String method, Object params) {
            NotificationMessage notification = NotificationMessage.create(method, "2.0");
            notification.setParams(Session.getJSONData(params));
            if (this.server.getLogger().isLoggable(Level.FINER)) {
                String format = "[Trace - %s] Sending notification '%s'\nParams: %s";
                this.server.getLogger().log(Level.FINER, LanguageServer.format(format, Instant.now().toString(), method, Session.getJSONData(params).toString()));
            }
            this.writeMessage(Session.getJSONData(notification).toString());
        }

        private void writeMessage(String message) {
            try {
                byte[] messageBytes = message.getBytes(StandardCharsets.UTF_8);
                Session.writeMessageBytes(this.out, messageBytes);
            }
            catch (IOException ex) {
                this.server.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
                throw new RuntimeException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void writeMessageBytes(OutputStream out, byte[] messageBytes) throws IOException {
            int contentLength = messageBytes.length;
            String header = LanguageServer.format("Content-Length: %d\r\n\r\n", contentLength);
            byte[] headerBytes = header.getBytes(StandardCharsets.US_ASCII);
            OutputStream outputStream = out;
            synchronized (outputStream) {
                out.write(headerBytes);
                out.write(messageBytes);
                out.flush();
            }
        }

        private static Object getJSONData(Object object) {
            if (object instanceof List) {
                JSONArray json = new JSONArray();
                for (Object obj : (List)object) {
                    json.put(Session.getJSONData(obj));
                }
                return json;
            }
            if (object instanceof JSONBase) {
                return ((JSONBase)object).jsonData;
            }
            return object;
        }

        private boolean isCancel(Throwable t) {
            return t instanceof CompletionException ? this.isCancel(t.getCause()) : t instanceof CancellationException;
        }

        public static Future<?> connect(LanguageServer server, InputStream in, OutputStream out, ExecutorService executors, DelegateServers delegateServers) {
            Session s = new Session(server, in, out, delegateServers);
            Future<?> sessionFuture = executors.submit(s);
            delegateServers.submitAll(executors);
            return sessionFuture;
        }
    }

    public static final class DelegateServer
    implements Runnable {
        private final LoggerProxy logger;
        private final String languageId;
        private final Socket socket;
        private final InputStream in;
        private final OutputStream out;
        private final OutputStream serverOutput;
        private final TruffleAdapter truffleAdapter;
        private final Map<Object, JSONObject> receivedMessages = new HashMap<Object, JSONObject>();
        private Object initializeId;
        private ServerCapabilities capabilities;

        public DelegateServer(String languageId, SocketAddress socketAddress, OutputStream serverOutput, TruffleAdapter truffleAdapter, LoggerProxy logger) throws IOException {
            this.languageId = languageId;
            this.socket = new Socket();
            this.serverOutput = serverOutput;
            this.truffleAdapter = truffleAdapter;
            this.logger = logger;
            this.socket.connect(socketAddress);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
        }

        public String getLanguageId() {
            return this.languageId;
        }

        public String getAddress() {
            return this.socket.getRemoteSocketAddress().toString();
        }

        public void close() {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addAwaitingId(Object id) {
            Map<Object, JSONObject> map = this.receivedMessages;
            synchronized (map) {
                this.receivedMessages.put(id, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JSONObject awaitMessage(Object id) throws InterruptedException {
            Map<Object, JSONObject> map = this.receivedMessages;
            synchronized (map) {
                JSONObject message = null;
                if (this.receivedMessages.containsKey(id)) {
                    message = this.receivedMessages.get(id);
                    while (message == null) {
                        this.receivedMessages.wait();
                        message = this.receivedMessages.get(id);
                    }
                    this.receivedMessages.remove(id);
                }
                return message;
            }
        }

        public void sendMessage(byte[] bytes, Object id, String method) throws IOException {
            if ("initialize".equals(method)) {
                this.initializeId = id;
            }
            Session.writeMessageBytes(this.out, bytes);
            if (id != null) {
                this.addAwaitingId(id);
            }
        }

        public ServerCapabilities getCapabilities() {
            return this.capabilities;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.socket.isClosed()) {
                    byte[] messageBytes = Session.readMessageBytes(this.in, this.logger);
                    if (messageBytes == null) {
                        return;
                    }
                    String content = new String(messageBytes, StandardCharsets.UTF_8);
                    JSONObject json = new JSONObject(content);
                    if (json.has("id")) {
                        JSONObject result;
                        Object id = json.get("id");
                        if (id.equals(this.initializeId) && json.has("result") && (result = (JSONObject)json.get("result")).has("capabilities")) {
                            JSONObject c = (JSONObject)result.get("capabilities");
                            this.capabilities = new ServerCapabilities(c);
                            this.truffleAdapter.setServerCapabilities(this.languageId, this.capabilities);
                        }
                        Map<Object, JSONObject> map = this.receivedMessages;
                        synchronized (map) {
                            if (this.receivedMessages.containsKey(id)) {
                                this.receivedMessages.put(id, json);
                                this.receivedMessages.notifyAll();
                            }
                            continue;
                        }
                    }
                    Session.writeMessageBytes(this.serverOutput, messageBytes);
                }
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String toString() {
            return "Delegate LS " + (this.languageId != null ? this.languageId : "") + "@" + this.getAddress();
        }
    }
}

