/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.Position;
import org.graalvm.tools.lsp.server.types.TextDocumentIdentifier;
import org.graalvm.tools.lsp.server.types.TextDocumentPositionParams;

public class HoverParams
extends TextDocumentPositionParams {
    HoverParams(JSONObject jsonData) {
        super(jsonData);
    }

    public Object getWorkDoneToken() {
        return this.jsonData.opt("workDoneToken");
    }

    public HoverParams setWorkDoneToken(Object workDoneToken) {
        this.jsonData.putOpt("workDoneToken", workDoneToken);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HoverParams other = (HoverParams)obj;
        if (!Objects.equals(this.getWorkDoneToken(), other.getWorkDoneToken())) {
            return false;
        }
        if (!Objects.equals(this.getTextDocument(), other.getTextDocument())) {
            return false;
        }
        return Objects.equals(this.getPosition(), other.getPosition());
    }

    @Override
    public int hashCode() {
        int hash = 7;
        if (this.getWorkDoneToken() != null) {
            hash = 59 * hash + Objects.hashCode(this.getWorkDoneToken());
        }
        hash = 59 * hash + Objects.hashCode(this.getTextDocument());
        hash = 59 * hash + Objects.hashCode(this.getPosition());
        return hash;
    }

    public static HoverParams create(TextDocumentIdentifier textDocument, Position position) {
        JSONObject json = new JSONObject();
        json.put("textDocument", textDocument.jsonData);
        json.put("position", position.jsonData);
        return new HoverParams(json);
    }
}

